/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.ui;

import java.util.Map;
import java.util.Vector;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import webwork.util.BeanUtil;
import webwork.util.TabbedPane;
import webwork.view.taglib.ui.ComponentTag;

public class TabbedPaneTag
extends ComponentTag {
    protected TabbedPane tabPane = new TabbedPane(0);
    protected String contentName = null;

    protected String strVal(String objName) {
        try {
            return String.valueOf(this.findValue(objName));
        }
        catch (Exception e) {
            return objName;
        }
    }

    public TabbedPaneTag() {
        super.setTemplate("tabbedpane.jsp");
        this.setSelectedIndex(0);
        if (this.getTabAlign() == null) {
            this.setTabAlign("'CENTER'");
        }
    }

    public String getSelectedUrl() {
        Map.Entry me = (Map.Entry)this.getContent().elementAt(this.getSelectedIndex());
        String str = BeanUtil.toStringValue(me.getValue());
        return str;
    }

    public int getColSpanLength() {
        return this.getTabAlign().compareToIgnoreCase("CENTER") == 0 ? this.getContent().size() + 2 : this.getContent().size() + 1;
    }

    public String getIndexLink() {
        return "TABBEDPANE_" + this.getId() + "_INDEX";
    }

    public String getContentName() {
        return this.contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = this.strVal(contentName);
        Object obj = this.findValue(this.contentName);
        if (obj instanceof Vector) {
            this.setContent((Vector)obj);
        }
    }

    public int getSelectedIndex() {
        return this.tabPane.getSelectedIndex();
    }

    public void setSelectedIndex(int selectedIndex) {
        this.tabPane.setSelectedIndex(selectedIndex);
    }

    public Vector getContent() {
        return this.tabPane.getContent();
    }

    public void setContent(Vector content) {
        this.tabPane.setContent(content);
    }

    public String getTabAlign() {
        return this.tabPane.getTabAlign();
    }

    public void setTabAlign(String tabAlign) {
        this.tabPane.setTabAlign(this.strVal(tabAlign));
    }

    public int doStartTag() throws JspException {
        String indexStr = this.pageContext.getRequest().getParameter(this.getIndexLink());
        if (indexStr != null) {
            try {
                int index = Integer.parseInt(indexStr);
                this.setSelectedIndex(index < 0 ? 0 : index);
            }
            catch (Exception e) {
                throw new JspTagException("TabbedPane Error: " + e.toString());
            }
        }
        return super.doStartTag();
    }

    public void release() {
        this.setSelectedIndex(0);
        if (this.getTabAlign() == null) {
            this.setTabAlign("'CENTER'");
        }
    }
}

