/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.fileupload.ParameterParser;

public class ParameterParserTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public ParameterParserTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.fileupload.ParameterParserTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        String[] testCaseName = stringArray;
        TestRunner.main((String[])testCaseName);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.fileupload.ParameterParserTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testParsing() {
        String s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff";
        ParameterParser parser = new ParameterParser();
        Map params = parser.parse(s, ';');
        Assert.assertEquals(null, params.get("test"));
        Assert.assertEquals((Object)"stuff", params.get("test1"));
        Assert.assertEquals((Object)"stuff; stuff", params.get("test2"));
        Assert.assertEquals((Object)"\"stuff", params.get("test3"));
        s = "  test  , test1=stuff   ,  , test2=, test3, ";
        params = parser.parse(s, ',');
        Assert.assertEquals(null, params.get("test"));
        Assert.assertEquals((Object)"stuff", params.get("test1"));
        Assert.assertEquals(null, params.get("test2"));
        Assert.assertEquals(null, params.get("test3"));
        s = "  test";
        params = parser.parse(s, ';');
        Assert.assertEquals(null, params.get("test"));
        s = "  ";
        params = parser.parse(s, ';');
        Assert.assertEquals((int)0, (int)params.size());
        s = " = stuff ";
        params = parser.parse(s, ';');
        Assert.assertEquals((int)0, (int)params.size());
    }

    public void testContentTypeParsing() {
        String s = "text/plain; Charset=UTF-8";
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(s, ';');
        Assert.assertEquals((Object)"UTF-8", params.get("charset"));
    }

    public void testParsingEscapedChars() {
        String s = "param = \"stuff\\\"; more stuff\"";
        ParameterParser parser = new ParameterParser();
        Map params = parser.parse(s, ';');
        Assert.assertEquals((int)1, (int)params.size());
        Assert.assertEquals((Object)"stuff\\\"; more stuff", params.get("param"));
        s = "param = \"stuff\\\\\"; anotherparam";
        params = parser.parse(s, ';');
        Assert.assertEquals((int)2, (int)params.size());
        Assert.assertEquals((Object)"stuff\\\\", params.get("param"));
        Assert.assertNull(params.get("anotherparam"));
    }
}

