/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.Vector;
import org.hsqldb.util.ConnectionDialog;
import org.hsqldb.util.Grid;
import org.hsqldb.util.Transfer;
import org.hsqldb.util.Tree;

public class DatabaseManager
extends Applet
implements ActionListener,
WindowListener,
KeyListener {
    static final int iMaxRecent = 24;
    Connection cConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    Menu mRecent;
    String[] sRecent;
    int iRecent;
    TextArea txtCommand;
    Button butExecute;
    Tree tTree;
    Panel pResult;
    long lTime;
    int iResult;
    Grid gResult;
    TextArea txtResult;
    boolean bHelp;
    Frame fMain;
    Image imgEmpty;
    static boolean bMustExit;
    static Random rRandom;

    void connect(Connection c) {
        if (c == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.cConn = c;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.refreshTree();
    }

    public void init() {
        DatabaseManager m = new DatabaseManager();
        m.main();
        try {
            m.connect(ConnectionDialog.createConnection("org.hsqldb.jdbcDriver", "jdbc:hsqldb:.", "sa", ""));
            m.insertTestData();
            m.refreshTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] arg) {
        bMustExit = true;
        DatabaseManager m = new DatabaseManager();
        m.main();
        Connection c = ConnectionDialog.createConnection(m.fMain, "Connect");
        if (c == null) {
            return;
        }
        m.connect(c);
    }

    void insertTestData() {
        String[] demo = new String[]{"DROP TABLE Address", "DROP TABLE Product", "DROP TABLE Document", "DROP TABLE Position", "CREATE TABLE Address(ID INTEGER PRIMARY KEY,FirstName VARCHAR(255),LastName VARCHAR(255),Street VARCHAR(255),City VARCHAR(255))", "CREATE TABLE Product(ID INTEGER PRIMARY KEY,Name VARCHAR(255),Cost DECIMAL)", "CREATE TABLE Document(ID INTEGER PRIMARY KEY,AddressID INTEGER,Total DECIMAL)", "CREATE TABLE Position(DocumentID INTEGER,Position INTEGER,ProductID INTEGER,Quantity INTEGER,Price DECIMAL,PRIMARY KEY(DocumentID,Position))"};
        String[] name = new String[]{"White", "Karsen", "Smith", "Ringer", "May", "King", "Fuller", "Miller", "Ott", "Sommer", "Schneider", "Steel", "Peterson", "Heiniger", "Clancy"};
        String[] firstname = new String[]{"Mary", "James", "Anne", "George", "Sylvia", "Robert", "Janet", "Michael", "Andrew", "Bill", "Susanne", "Laura", "Bob", "Julia", "John"};
        String[] street = new String[]{"Upland Pl.", "College Av.", "- 20th Ave.", "Seventh Av."};
        String[] city = new String[]{"New York", "Dallas", "Boston", "Chicago", "Seattle", "San Francisco", "Berne", "Oslo", "Paris", "Lyon", "Palo Alto", "Olten"};
        String[] product = new String[]{"Iron", "Ice Tea", "Clock", "Chair", "Telephone", "Shoe"};
        try {
            int i = 0;
            while (i < demo.length) {
                try {
                    this.sStatement.execute(demo[i]);
                }
                catch (SQLException e) {
                    // empty catch block
                }
                ++i;
            }
            this.refreshTree();
            int max = 50;
            int i2 = 0;
            while (i2 < max) {
                this.sStatement.execute("INSERT INTO Address VALUES(" + i2 + ",'" + DatabaseManager.random(firstname) + "','" + DatabaseManager.random(name) + "','" + DatabaseManager.random(554) + " " + DatabaseManager.random(street) + "','" + DatabaseManager.random(city) + "')");
                this.sStatement.execute("INSERT INTO Product VALUES(" + i2 + ",'" + DatabaseManager.random(product) + " " + DatabaseManager.random(product) + "'," + (20 + 2 * DatabaseManager.random(120)) + ")");
                this.sStatement.execute("INSERT INTO Document VALUES(" + i2 + "," + DatabaseManager.random(max) + ",0.0)");
                int j = DatabaseManager.random(20) + 2;
                while (j >= 0) {
                    this.sStatement.execute("INSERT INTO Position VALUES(" + i2 + "," + j + "," + DatabaseManager.random(max) + "," + (1 + DatabaseManager.random(24)) + ",1.5)");
                    --j;
                }
                ++i2;
            }
            this.sStatement.execute("UPDATE Product SET Cost=ROUND(Cost*.1,2)");
            this.sStatement.execute("UPDATE Position SET Price=Price*SELECT Cost FROM Product prod WHERE ProductID=prod.ID");
            this.sStatement.execute("UPDATE Document SET Total=SELECT SUM(Price*Quantity) FROM Position WHERE DocumentID=Document.ID");
            String[] recent = new String[]{"SELECT * FROM Product", "SELECT * FROM Document", "SELECT * FROM Position", "SELECT * FROM Address a\nINNER JOIN Document d ON a.ID=d.AddressID", "SELECT * FROM Document d\nINNER JOIN Position p ON d.ID=p.DocumentID", "SELECT * FROM Address WHERE Street LIKE '1%' ORDER BY Lastname"};
            int i3 = 0;
            while (i3 < recent.length) {
                this.addToRecent(recent[i3]);
                ++i3;
            }
            this.refreshTree();
            this.txtCommand.setText("SELECT * FROM Address");
            this.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String random(String[] s) {
        return s[DatabaseManager.random(s.length)];
    }

    public static int random(int i) {
        i = rRandom.nextInt() % i;
        return i < 0 ? -i : i;
    }

    void main() {
        this.fMain = new Frame("HSQL Database Manager");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        MenuBar bar = new MenuBar();
        String[] fitems = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(bar, "File", fitems);
        String[] vitems = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text", "--", "1Shrink Tree", "2Enlarge Tree", "3Shrink Command", "4Enlarge Command"};
        this.addMenu(bar, "View", vitems);
        String[] sitems = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "--", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-SCRIPT", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(bar, "Command", sitems);
        Menu recent = new Menu("Recent");
        this.mRecent = new Menu("Recent");
        bar.add(this.mRecent);
        String[] soptions = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data", "-Transfer"};
        this.addMenu(bar, "Options", soptions);
        this.fMain.setMenuBar(bar);
        ((Component)this.fMain).setSize(640, 480);
        this.fMain.add("Center", this);
        this.initGUI();
        this.sRecent = new String[24];
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.fMain.getSize();
        ((Component)this.fMain).setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        this.fMain.show();
        this.txtCommand.requestFocus();
    }

    void addMenu(MenuBar b, String name, String[] items) {
        Menu menu = new Menu(name);
        this.addMenuItems(menu, items);
        b.add(menu);
    }

    void addMenuItems(Menu f, String[] m) {
        int i = 0;
        while (i < m.length) {
            MenuItem item = new MenuItem(m[i].substring(1));
            char c = m[i].charAt(0);
            if (c != '-') {
                item.setShortcut(new MenuShortcut(c));
            }
            item.addActionListener(this);
            f.add(item);
            ++i;
        }
    }

    public void keyPressed(KeyEvent k) {
    }

    public void keyReleased(KeyEvent k) {
    }

    public void keyTyped(KeyEvent k) {
        if (k.getKeyChar() == '\n' && k.isControlDown()) {
            k.consume();
            this.execute();
        }
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s == null && ev.getSource() instanceof MenuItem) {
            s = ((MenuItem)ev.getSource()).getLabel();
        }
        if (s.equals("Execute")) {
            this.execute();
        } else if (s.equals("Exit")) {
            this.windowClosing(null);
        } else if (s.equals("Transfer")) {
            Transfer.work();
        } else if (s.equals("Logging on")) {
            DriverManager.setLogStream(System.out);
        } else if (s.equals("Logging off")) {
            DriverManager.setLogStream(null);
        } else if (s.equals("Refresh Tree")) {
            this.refreshTree();
        } else if (s.startsWith("#")) {
            int i = Integer.parseInt(s.substring(1));
            this.txtCommand.setText(this.sRecent[i]);
        } else if (s.equals("Connect...")) {
            this.connect(ConnectionDialog.createConnection(this.fMain, "Connect"));
            this.refreshTree();
        } else if (s.equals("Results in Grid")) {
            this.iResult = 0;
            this.pResult.removeAll();
            this.pResult.add("Center", this.gResult);
            this.pResult.doLayout();
        } else if (s.equals("Open Script...")) {
            FileDialog f = new FileDialog(this.fMain, "Open Script", 0);
            f.show();
            String file = f.getFile();
            if (file != null) {
                this.txtCommand.setText(this.readFile(f.getDirectory() + file));
            }
        } else if (s.equals("Save Script...")) {
            FileDialog f = new FileDialog(this.fMain, "Save Script", 1);
            f.show();
            String file = f.getFile();
            if (file != null) {
                this.writeFile(f.getDirectory() + file, this.txtCommand.getText());
            }
        } else if (s.equals("Save Result...")) {
            FileDialog f = new FileDialog(this.fMain, "Save Result", 1);
            f.show();
            String file = f.getFile();
            if (file != null) {
                this.showResultInText();
                this.writeFile(f.getDirectory() + file, this.txtResult.getText());
            }
        } else if (s.equals("Results in Text")) {
            this.iResult = 1;
            this.pResult.removeAll();
            this.pResult.add("Center", this.txtResult);
            this.pResult.doLayout();
            this.showResultInText();
        } else if (s.equals("AutoCommit on")) {
            try {
                this.cConn.setAutoCommit(true);
            }
            catch (SQLException e) {}
        } else if (s.equals("AutoCommit off")) {
            try {
                this.cConn.setAutoCommit(false);
            }
            catch (SQLException e) {}
        } else if (s.equals("Enlarge Tree")) {
            Dimension d = this.tTree.getMinimumSize();
            d.width += 20;
            this.tTree.setMinimumSize(d);
            this.fMain.pack();
        } else if (s.equals("Shrink Tree")) {
            Dimension d = this.tTree.getMinimumSize();
            d.width -= 20;
            if (d.width >= 0) {
                this.tTree.setMinimumSize(d);
            }
            this.fMain.pack();
        } else if (s.equals("Enlarge Command")) {
            this.txtCommand.setRows(this.txtCommand.getRows() + 1);
            this.fMain.pack();
        } else if (s.equals("Shrink Command")) {
            int i = this.txtCommand.getRows() - 1;
            this.txtCommand.setRows(i < 1 ? 1 : i);
            this.fMain.pack();
        } else if (s.equals("Commit")) {
            try {
                this.cConn.commit();
            }
            catch (SQLException e) {}
        } else if (s.equals("Insert test data")) {
            this.insertTestData();
        } else if (s.equals("Rollback")) {
            try {
                this.cConn.rollback();
            }
            catch (SQLException e) {}
        } else if (s.equals("Disable MaxRows")) {
            try {
                this.sStatement.setMaxRows(0);
            }
            catch (SQLException e) {}
        } else if (s.equals("Set MaxRows to 100")) {
            try {
                this.sStatement.setMaxRows(100);
            }
            catch (SQLException sQLException) {}
        } else if (s.equals("SELECT")) {
            this.showHelp("SELECT * FROM ", "SELECT [DISTINCT] \n{ selectExpression | table.* | * } [, ... ] \n[INTO newTable] \nFROM tableList \n[WHERE Expression] \n[ORDER BY selectExpression [{ASC | DESC}] [, ...] ] \n[GROUP BY Expression [, ...] ] \n[UNION [ALL] selectStatement]");
        } else if (s.equals("INSERT")) {
            this.showHelp("INSERT INTO ", "INSERT INTO table [ (column [,...] ) ] \n{ VALUES(Expression [,...]) | SelectStatement }");
        } else if (s.equals("UPDATE")) {
            this.showHelp("UPDATE ", "UPDATE table SET column = Expression [, ...] \n[WHERE Expression]");
        } else if (s.equals("DELETE")) {
            this.showHelp("DELETE FROM ", "DELETE FROM table [WHERE Expression]");
        } else if (s.equals("CREATE TABLE")) {
            this.showHelp("CREATE TABLE ", "CREATE TABLE name \n( columnDefinition [, ...] ) \n\ncolumnDefinition: \ncolumn DataType [ [NOT] NULL] [PRIMARY KEY] \nDataType: \n{ INTEGER | DOUBLE | VARCHAR | DATE | TIME |... }");
        } else if (s.equals("DROP TABLE")) {
            this.showHelp("DROP TABLE ", "DROP TABLE table");
        } else if (s.equals("CREATE INDEX")) {
            this.showHelp("CREATE INDEX ", "CREATE [UNIQUE] INDEX index ON \ntable (column [, ...])");
        } else if (s.equals("DROP INDEX")) {
            this.showHelp("DROP INDEX ", "DROP INDEX table.index");
        } else if (s.equals("SCRIPT")) {
            this.showHelp("SCRIPT", "SCRIPT ['file']\n\n(HSQL Database Engine only)");
        } else if (s.equals("SHUTDOWN")) {
            this.showHelp("SHUTDOWN", "SHUTDOWN [IMMEDIATELY]\n\n(HSQL Database Engine only)");
        } else if (s.equals("Test Script")) {
            this.showHelp("-->>>TEST<<<-- ;\n--#1000;\nDROP TABLE Test ;\nCREATE TABLE Test(\n  Id INTEGER PRIMARY KEY,\n  FirstName VARCHAR(20),\n  Name VARCHAR(50),\n  ZIP INTEGER) ;\nINSERT INTO Test \n  VALUES(#,'Julia','Peterson-Clancy',#) ;\nUPDATE Test SET Name='Hans' WHERE Id=# ;\nSELECT * FROM Test WHERE Id=# ;\nDELETE FROM Test WHERE Id=# ;\nDROP TABLE Test", "This test script is parsed by the DatabaseManager\nIt may be changed manually. Rules:\n- it must start with -->>>TEST<<<--.\n- each line must end with ';' (no spaces after)\n- lines starting with -- are comments\n- lines starting with --#<count> means set new count\n");
        }
    }

    String readFile(String file) {
        try {
            int i;
            FileReader read = new FileReader(file);
            char[] buffer = new char[1024];
            StringBuffer b = new StringBuffer();
            while ((i = read.read(buffer, 0, 1024)) != -1) {
                b.append(buffer, 0, i);
            }
            read.close();
            return b.toString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    void writeFile(String file, String text) {
        try {
            FileWriter write = new FileWriter(file);
            write.write(text.toCharArray());
            write.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void showHelp(String s, String help) {
        this.txtCommand.setText(s);
        this.txtResult.setText(help);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add("Center", this.txtResult);
        this.pResult.doLayout();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(s.length());
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent ev) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    void trace(String s) {
        System.out.println(s);
    }

    void execute() {
        String sCmd = this.txtCommand.getText();
        if (sCmd.startsWith("-->>>TEST<<<--")) {
            this.testPerformance();
            return;
        }
        String[] g = new String[1];
        try {
            this.lTime = System.currentTimeMillis();
            this.sStatement.execute(sCmd);
            int r = this.sStatement.getUpdateCount();
            if (r == -1) {
                this.formatResultSet(this.sStatement.getResultSet());
            } else {
                g[0] = "update count";
                this.gResult.setHead(g);
                g[0] = "" + r;
                this.gResult.addRow(g);
            }
            this.lTime = System.currentTimeMillis() - this.lTime;
            this.addToRecent(this.txtCommand.getText());
        }
        catch (SQLException e) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            g[0] = "SQL Error";
            this.gResult.setHead(g);
            String s = e.getMessage();
            s = s + " / Error Code: " + e.getErrorCode();
            g[0] = s = s + " / State: " + e.getSQLState();
            this.gResult.addRow(g);
        }
        this.updateResult();
    }

    void updateResult() {
        if (this.iResult == 0) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add("Center", this.gResult);
                this.pResult.doLayout();
                this.bHelp = false;
            }
            this.gResult.update();
            this.gResult.repaint();
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    void formatResultSet(ResultSet r) {
        if (r == null) {
            String[] g = new String[]{"Result"};
            this.gResult.setHead(g);
            g[0] = "(empty)";
            this.gResult.addRow(g);
            return;
        }
        try {
            ResultSetMetaData m = r.getMetaData();
            int col = m.getColumnCount();
            String[] h = new String[col];
            int i = 1;
            while (i <= col) {
                h[i - 1] = m.getColumnLabel(i);
                ++i;
            }
            this.gResult.setHead(h);
            while (r.next()) {
                int i2 = 1;
                while (i2 <= col) {
                    h[i2 - 1] = r.getString(i2);
                    if (r.wasNull()) {
                        h[i2 - 1] = "(null)";
                    }
                    ++i2;
                }
                this.gResult.addRow(h);
            }
            r.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    long testStatement(String sql, int max) throws SQLException {
        long start = System.currentTimeMillis();
        if (sql.indexOf(35) == -1) {
            max = 1;
        }
        int i = 0;
        while (i < max) {
            int j;
            String s = sql;
            while ((j = s.indexOf("#r#")) != -1) {
                s = s.substring(0, j) + (int)(Math.random() * (double)i) + s.substring(j + 3);
            }
            while ((j = s.indexOf(35)) != -1) {
                s = s.substring(0, j) + i + s.substring(j + 1);
            }
            this.sStatement.execute(s);
            ++i;
        }
        return System.currentTimeMillis() - start;
    }

    void testPerformance() {
        String all = this.txtCommand.getText();
        StringBuffer b = new StringBuffer();
        long total = 0L;
        int i = 0;
        while (i < all.length()) {
            char c = all.charAt(i);
            if (c != '\n') {
                b.append(c);
            }
            ++i;
        }
        all = b.toString();
        String[] g = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(g);
        int max = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!all.equals("")) {
            String sql;
            int i2 = all.indexOf(59);
            if (i2 != -1) {
                sql = all.substring(0, i2);
                all = all.substring(i2 + 1);
            } else {
                sql = all;
                all = "";
            }
            if (sql.startsWith("--#")) {
                max = Integer.parseInt(sql.substring(3));
                continue;
            }
            if (sql.startsWith("--")) continue;
            g[2] = sql;
            long l = 0L;
            try {
                l = this.testStatement(sql, max);
                total += l;
                g[0] = "" + l;
                g[1] = "" + max;
                g[3] = "";
            }
            catch (SQLException e) {
                g[1] = "n/a";
                g[0] = "n/a";
                g[3] = e.toString();
            }
            this.gResult.addRow(g);
            System.out.println(l + " ms : " + sql);
        }
        g[0] = "" + total;
        g[1] = "total";
        g[2] = "";
        this.gResult.addRow(g);
        this.lTime = System.currentTimeMillis() - this.lTime;
        this.updateResult();
    }

    void showResultInText() {
        String[] row = this.gResult.getHead();
        int width = row.length;
        Vector data = this.gResult.getData();
        int[] size = new int[width];
        int i = 0;
        while (i < width) {
            size[i] = row[i].length();
            ++i;
        }
        int len = data.size();
        int i2 = 0;
        while (i2 < len) {
            row = (String[])data.elementAt(i2);
            int j = 0;
            while (j < width) {
                int l = row[j].length();
                if (l > size[j]) {
                    size[j] = l;
                }
                ++j;
            }
            ++i2;
        }
        StringBuffer b = new StringBuffer();
        row = this.gResult.getHead();
        int i3 = 0;
        while (i3 < width) {
            b.append(row[i3]);
            int l = row[i3].length();
            while (l <= size[i3]) {
                b.append(' ');
                ++l;
            }
            ++i3;
        }
        b.append('\n');
        int i4 = 0;
        while (i4 < width) {
            int l = 0;
            while (l < size[i4]) {
                b.append('-');
                ++l;
            }
            b.append(' ');
            ++i4;
        }
        b.append('\n');
        int i5 = 0;
        while (i5 < len) {
            row = (String[])data.elementAt(i5);
            int j = 0;
            while (j < width) {
                b.append(row[j]);
                int l = row[j].length();
                while (l <= size[j]) {
                    b.append(' ');
                    ++l;
                }
                ++j;
            }
            b.append('\n');
            ++i5;
        }
        b.append("\n" + len + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(b.toString());
    }

    private void addToRecent(String s) {
        int i = 0;
        while (i < 24) {
            if (s.equals(this.sRecent[i])) {
                return;
            }
            ++i;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = s;
        if (s.length() > 43) {
            s = s.substring(0, 40) + "...";
        }
        MenuItem item = new MenuItem(s);
        item.setActionCommand("#" + this.iRecent);
        item.addActionListener(this);
        this.mRecent.insert(item, this.iRecent);
        this.iRecent = (this.iRecent + 1) % 24;
    }

    private void initGUI() {
        Panel pQuery = new Panel();
        Panel pCommand = new Panel();
        this.pResult = new Panel();
        pQuery.setLayout(new BorderLayout());
        pCommand.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font fFont = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.addKeyListener(this);
        this.txtResult = new TextArea(20, 40);
        this.txtCommand.setFont(fFont);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        this.butExecute = new Button("Execute");
        this.butExecute.addActionListener(this);
        pCommand.add("East", this.butExecute);
        pCommand.add("Center", this.txtCommand);
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        this.pResult.add("Center", this.gResult);
        pQuery.add("North", pCommand);
        pQuery.add("Center", this.pResult);
        this.fMain.add("Center", pQuery);
        this.tTree = new Tree();
        this.tTree.setMinimumSize(new Dimension(200, 100));
        this.gResult.setMinimumSize(new Dimension(200, 300));
        this.fMain.add("West", this.tTree);
        this.doLayout();
        this.fMain.pack();
    }

    private void refreshTree() {
        this.tTree.removeAll();
        try {
            int color_table = Color.yellow.getRGB();
            int color_column = Color.orange.getRGB();
            int color_index = Color.red.getRGB();
            this.tTree.addRow("", this.dMeta.getURL(), "-", 0);
            String[] usertables = new String[]{"TABLE"};
            ResultSet result = this.dMeta.getTables(null, null, null, usertables);
            Vector<String> tables = new Vector<String>();
            while (result.next()) {
                tables.addElement(result.getString(3));
            }
            result.close();
            int i = 0;
            while (i < tables.size()) {
                String name = (String)tables.elementAt(i);
                String key = "tab-" + name + "-";
                this.tTree.addRow(key, name, "+", color_table);
                ResultSet col = this.dMeta.getColumns(null, null, name, null);
                while (col.next()) {
                    String c = col.getString(4);
                    String k1 = key + "col-" + c + "-";
                    this.tTree.addRow(k1, c, "+", color_column);
                    String type = col.getString(6);
                    this.tTree.addRow(k1 + "t", "Type: " + type);
                    boolean nullable = col.getInt(11) != 0;
                    this.tTree.addRow(k1 + "n", "Nullable: " + nullable);
                }
                col.close();
                this.tTree.addRow(key + "ind", "Indices", "+", 0);
                ResultSet ind = this.dMeta.getIndexInfo(null, null, name, false, false);
                String oldiname = null;
                while (ind.next()) {
                    boolean nonunique = ind.getBoolean(4);
                    String iname = ind.getString(6);
                    String k2 = key + "ind-" + iname + "-";
                    if (oldiname == null || !oldiname.equals(iname)) {
                        this.tTree.addRow(k2, iname, "+", color_index);
                        this.tTree.addRow(k2 + "u", "Unique: " + !nonunique);
                        oldiname = iname;
                    }
                    String c = ind.getString(9);
                    this.tTree.addRow(k2 + "c-" + c + "-", c);
                }
                ind.close();
                ++i;
            }
            this.tTree.addRow("p", "Properties", "+", 0);
            this.tTree.addRow("pu", "User: " + this.dMeta.getUserName());
            this.tTree.addRow("pr", "ReadOnly: " + this.cConn.isReadOnly());
            this.tTree.addRow("pa", "AutoCommit: " + this.cConn.getAutoCommit());
            this.tTree.addRow("pd", "Driver: " + this.dMeta.getDriverName());
            this.tTree.addRow("pp", "Product: " + this.dMeta.getDatabaseProductName());
            this.tTree.addRow("pv", "Version: " + this.dMeta.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            this.tTree.addRow("", "Error getting metadata:", "-", 0);
            this.tTree.addRow("-", e.getMessage());
            this.tTree.addRow("-", e.getSQLState());
        }
        this.tTree.update();
    }

    static {
        rRandom = new Random(100L);
    }
}

