/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.oro.text.perl.Perl5Util;

public class GenericValidator
implements Serializable {
    public static final String REGEXP_DELIM = "/";

    public static boolean isBlankOrNull(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean matchRegexp(String string, String string2) {
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            Perl5Util perl5Util = new Perl5Util();
            bl = perl5Util.match(GenericValidator.getDelimittedRegexp(string2), string);
        }
        return bl;
    }

    public static boolean isByte(String string) {
        return GenericTypeValidator.formatByte(string) != null;
    }

    public static boolean isShort(String string) {
        return GenericTypeValidator.formatShort(string) != null;
    }

    public static boolean isInt(String string) {
        return GenericTypeValidator.formatInt(string) != null;
    }

    public static boolean isLong(String string) {
        return GenericTypeValidator.formatLong(string) != null;
    }

    public static boolean isFloat(String string) {
        return GenericTypeValidator.formatFloat(string) != null;
    }

    public static boolean isDouble(String string) {
        return GenericTypeValidator.formatDouble(string) != null;
    }

    public static boolean isDate(String string, Locale locale) {
        boolean bl = true;
        if (string != null) {
            try {
                DateFormat dateFormat = null;
                dateFormat = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
                dateFormat.setLenient(false);
                Date date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean isDate(String string, String string2, boolean bl) {
        boolean bl2 = true;
        if (string != null && string2 != null && string2.length() > 0) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string);
                if (bl && string2.length() != string.length()) {
                    bl2 = false;
                }
            }
            catch (ParseException parseException) {
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isInRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static boolean isCreditCard(String string) {
        return GenericValidator.validateCreditCardLuhnCheck(string) && GenericValidator.validateCreditCardPrefixCheck(string);
    }

    protected static boolean validateCreditCardLuhnCheck(String string) {
        int n = string.length();
        int n2 = n & 1;
        long l = 0L;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            try {
                n4 = Integer.parseInt(String.valueOf(string.charAt(n3)));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if ((n3 & 1 ^ n2) == 0 && (n4 *= 2) > 9) {
                n4 -= 9;
            }
            l += (long)n4;
            ++n3;
        }
        if (l == 0L) {
            return false;
        }
        return l % 10L == 0L;
    }

    protected static boolean validateCreditCardPrefixCheck(String string) {
        int n = string.length();
        if (n < 13) {
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        String string2 = string.substring(0, 2) + ",";
        if ("34,37,".indexOf(string2) != -1) {
            n2 = 3;
        }
        if (string.substring(0, 1).equals("4")) {
            n2 = 4;
        }
        if ("51,52,53,54,55,".indexOf(string2) != -1) {
            n2 = 5;
        }
        if (string.substring(0, 4).equals("6011")) {
            n2 = 6;
        }
        if (n2 == 3 && n == 15) {
            bl = true;
        }
        if (n2 == 4 && (n == 13 || n == 16)) {
            bl = true;
        }
        if (n2 == 5 && n == 16) {
            bl = true;
        }
        if (n2 == 6 && n == 16) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEmail(String string) {
        boolean bl;
        block15: {
            bl = true;
            try {
                int n;
                String string2;
                String string3 = "\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
                String string4 = "[^\\s" + string3 + "]";
                String string5 = "(\"[^\"]*\")";
                String string6 = string4 + '+';
                String string7 = "(" + string6 + "|" + string5 + ")";
                String string8 = GenericValidator.getDelimittedRegexp("^(.+)@(.+)$");
                String string9 = GenericValidator.getDelimittedRegexp("^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$");
                String string10 = GenericValidator.getDelimittedRegexp("^" + string7 + "(\\." + string7 + ")*$");
                String string11 = GenericValidator.getDelimittedRegexp("^" + string6 + "(\\." + string6 + ")*$");
                String string12 = GenericValidator.getDelimittedRegexp("(" + string6 + ")");
                Perl5Util perl5Util = new Perl5Util();
                Perl5Util perl5Util2 = new Perl5Util();
                Perl5Util perl5Util3 = new Perl5Util();
                Perl5Util perl5Util4 = new Perl5Util();
                Perl5Util perl5Util5 = new Perl5Util();
                boolean bl2 = false;
                boolean bl3 = false;
                bl = perl5Util.match(string8, string);
                if (bl) {
                    string2 = perl5Util.group(1);
                    bl = perl5Util2.match(string10, string2);
                }
                if (!bl) break block15;
                string2 = perl5Util.group(2);
                bl2 = perl5Util3.match(string9, string2);
                if (bl2) {
                    int n2 = 1;
                    while (n2 <= 4) {
                        String string13 = perl5Util3.group(n2);
                        if (string13 != null && string13.length() > 0) {
                            n = 0;
                            try {
                                n = Integer.parseInt(string13);
                            }
                            catch (Exception exception) {
                                bl = false;
                            }
                            if (n > 255) {
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                        ++n2;
                    }
                } else {
                    bl3 = perl5Util4.match(string11, string2);
                }
                if (bl3) {
                    String[] stringArray = new String[10];
                    boolean bl4 = true;
                    n = 0;
                    int n3 = 0;
                    while (bl4) {
                        bl4 = perl5Util5.match(string12, string2);
                        if (!bl4) continue;
                        stringArray[n] = perl5Util5.group(1);
                        n3 = stringArray[n].length() + 1;
                        string2 = n3 >= string2.length() ? "" : string2.substring(n3);
                        ++n;
                    }
                    int n4 = n;
                    if (stringArray[n4 - 1].length() < 2 || stringArray[n4 - 1].length() > 4) {
                        bl = false;
                    }
                    if (n4 < 2) {
                        bl = false;
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean maxLength(String string, int n) {
        return string.length() <= n;
    }

    public static boolean minLength(String string, int n) {
        return string.length() >= n;
    }

    protected static String getDelimittedRegexp(String string) {
        return REGEXP_DELIM + string + REGEXP_DELIM;
    }
}

