/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.Debug;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.w3c.dom.Element;

public class ImageRenderer
extends DomBasicRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter;
        Element root;
        this.validateParameters(facesContext, uiComponent, UIGraphic.class);
        UIGraphic uiGraphic = (UIGraphic)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            root = domContext.createElement("img");
            domContext.setRootNode(root);
        }
        root = (Element)domContext.getRootNode();
        ImageRenderer.setRootElementId(facesContext, root, (UIComponent)uiGraphic);
        String srcAttribute = this.processSrcAttribute(facesContext, uiGraphic);
        root.setAttribute("src", srcAttribute);
        String styleClass = String.valueOf(uiComponent.getAttributes().get("styleClass"));
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        Debug.assertTrue((responseWriter = facesContext.getResponseWriter()) != null, "ResponseWriter is null");
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null);
        String altAttribute = (String)uiComponent.getAttributes().get("alt");
        if (altAttribute == null) {
            altAttribute = "";
        }
        root.setAttribute("alt", altAttribute);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
        this.validateParameters(facesContext, uiComponent, UIGraphic.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIGraphic.class);
    }

    protected String processSrcAttribute(FacesContext facesContext, UIGraphic uiGraphic) {
        String value = (String)uiGraphic.getValue();
        if (value == null) {
            value = uiGraphic.getUrl();
        }
        if (value != null) {
            value = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value);
            return value;
        }
        return "";
    }
}

