/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.remoting.InterfaceGenerator;
import org.jboss.seam.remoting.wrapper.BaseWrapper;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class BeanWrapper
extends BaseWrapper
implements Wrapper {
    private static final byte[] REF_START_TAG_OPEN = "<ref id=\"".getBytes();
    private static final byte[] REF_START_TAG_END = "\"/>".getBytes();
    private static final byte[] BEAN_START_TAG_OPEN = "<bean type=\"".getBytes();
    private static final byte[] BEAN_START_TAG_CLOSE = "\">".getBytes();
    private static final byte[] BEAN_CLOSE_TAG = "</bean>".getBytes();
    private static final byte[] MEMBER_START_TAG_OPEN = "<member name=\"".getBytes();
    private static final byte[] MEMBER_START_TAG_CLOSE = "\">".getBytes();
    private static final byte[] MEMBER_CLOSE_TAG = "</member>".getBytes();

    public void setElement(Element element) {
        super.setElement(element);
        String beanType = element.attributeValue("type");
        Component component = Component.forName(beanType);
        if (component != null) {
            this.value = Component.newInstance(beanType);
        } else {
            try {
                this.value = Class.forName(beanType).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not unmarshal bean element: " + element.getText(), ex);
            }
        }
    }

    public void unmarshal() {
        List members = this.element.elements("member");
        for (Element member : members) {
            String name = member.attributeValue("name");
            Wrapper w = this.context.createWrapperFromElement((Element)member.elementIterator().next());
            Field field = null;
            try {
                field = this.value.getClass().getDeclaredField(name);
            }
            catch (NoSuchFieldException ex) {
                try {
                    field = this.value.getClass().getField(name);
                }
                catch (NoSuchFieldException ex2) {
                    throw new RuntimeException("Field not found in bean: " + name, ex2);
                }
            }
            Object fieldValue = null;
            try {
                fieldValue = w.convert(field.getGenericType());
            }
            catch (ConversionException ex) {
                throw new RuntimeException("Could not convert value while unmarshaling", ex);
            }
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(this.value, fieldValue);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not set field value.", ex);
            }
            finally {
                field.setAccessible(accessible);
            }
        }
    }

    public Object convert(Type type) throws ConversionException {
        if (type instanceof Class && ((Class)type).isAssignableFrom(this.value.getClass())) {
            return this.value;
        }
        throw new ConversionException(String.format("Value [%s] cannot be converted to type [%s].", this.value, type));
    }

    public void marshal(OutputStream out) throws IOException {
        this.context.addOutRef(this);
        out.write(REF_START_TAG_OPEN);
        out.write(Integer.toString(this.context.getOutRefs().indexOf(this)).getBytes());
        out.write(REF_START_TAG_END);
    }

    public void serialize(OutputStream out) throws IOException {
        String componentName;
        out.write(BEAN_START_TAG_OPEN);
        Class<?> cls = this.value.getClass();
        if (cls.getName().contains("EnhancerByCGLIB")) {
            cls = cls.getSuperclass();
        }
        if ((componentName = Seam.getComponentName(cls)) != null) {
            out.write(componentName.getBytes());
        } else {
            out.write(cls.getName().getBytes());
        }
        out.write(BEAN_START_TAG_CLOSE);
        for (Field f : InterfaceGenerator.getAccessibleFields(cls)) {
            out.write(MEMBER_START_TAG_OPEN);
            out.write(f.getName().getBytes());
            out.write(MEMBER_START_TAG_CLOSE);
            boolean accessible = f.isAccessible();
            try {
                f.setAccessible(true);
                this.context.createWrapperFromObject(f.get(this.value)).marshal(out);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Error reading value from field.");
            }
            finally {
                f.setAccessible(accessible);
            }
            out.write(MEMBER_CLOSE_TAG);
        }
        out.write(BEAN_CLOSE_TAG);
    }

    public ConversionScore conversionScore(Class cls) {
        if (cls.equals(this.value.getClass())) {
            return ConversionScore.exact;
        }
        if (cls.isAssignableFrom(this.value.getClass()) || cls.equals(Object.class)) {
            return ConversionScore.compatible;
        }
        return ConversionScore.nomatch;
    }
}

