/*
 * Decompiled with CFR 0.152.
 */
package webwork.dispatcher;

import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.ResultException;
import webwork.action.ServletActionContext;
import webwork.config.Configuration;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.GenericDispatcher;
import webwork.multipart.MultiPartRequest;
import webwork.multipart.MultiPartRequestWrapper;
import webwork.util.ServletValueStack;
import webwork.util.ValueStack;

public class ServletDispatcher
extends HttpServlet {
    public static final String STACK_HEAD = "webwork.valuestack.head";
    protected static Log log = LogFactory.getLog((Class)(class$webwork$dispatcher$ServletDispatcher == null ? (class$webwork$dispatcher$ServletDispatcher = ServletDispatcher.class$("webwork.dispatcher.ServletDispatcher")) : class$webwork$dispatcher$ServletDispatcher));
    private static String saveDir;
    private static Integer maxSize;
    static /* synthetic */ Class class$webwork$dispatcher$ServletDispatcher;

    public void init(ServletConfig config) throws ServletException {
        block9: {
            super.init(config);
            Introspector.flushCaches();
            ValueStack.clearMethods();
            try {
                saveDir = Configuration.getString("webwork.multipart.saveDir");
                if (saveDir.compareTo("") == 0) {
                    throw new IllegalArgumentException("saveDir=null");
                }
            }
            catch (IllegalArgumentException e) {
                File tempdir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
                log.warn((Object)"Unable to find 'webwork.multipart.saveDir' property setting. Defaulting to javax.servlet.context.tempdir");
                if (tempdir == null) break block9;
                saveDir = tempdir.toString();
            }
        }
        log.debug((Object)("saveDir=" + saveDir));
        try {
            String maxSizeStr = Configuration.getString("webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    maxSize = new Integer(Integer.MAX_VALUE);
                    log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                maxSize = new Integer(Integer.MAX_VALUE);
                log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            maxSize = new Integer(Integer.MAX_VALUE);
            log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
        }
        log.debug((Object)("maxSize=" + maxSize));
        log.info((Object)"Action dispatcher initialized");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException {
        String servletPath = (String)(aRequest = this.wrapRequest(aRequest)).getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = aRequest.getServletPath();
        }
        String actionPath = aRequest.getServletPath();
        actionPath = actionPath.substring(0, actionPath.lastIndexOf("/") + 1);
        String actionName = this.getActionName(servletPath);
        GenericDispatcher gd = new GenericDispatcher(actionName, false);
        gd.prepareContext();
        ServletActionContext.setContext(aRequest, aResponse, this.getServletContext(), actionName);
        ActionResult ar = null;
        try {
            gd.executeAction();
            ar = gd.finish();
        }
        catch (Exception e) {
            log.error((Object)"Could not execute action", (Throwable)e);
            try {
                aResponse.sendError(404, "Could not execute action [" + actionName + "]:" + e.getMessage());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                e.printStackTrace(ps);
                aResponse.getOutputStream().println("<pre>" + baos.toString() + "</pre>");
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (ar != null && ar.getActionException() != null) {
            log.error((Object)"Could not execute action", (Throwable)ar.getActionException());
            try {
                aResponse.sendError(500, ar.getActionException().getMessage());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                ar.getActionException().printStackTrace(ps);
                aResponse.getOutputStream().println("<pre>" + baos.toString() + "</pre>");
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (ar != null && ar.getResult() != null && ar.getView() == null && !ar.getResult().equals("none")) {
            try {
                aResponse.sendError(404, "No view for result [" + ar.getResult() + "] exists for action [" + actionName + "]");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (ar != null && ar.getView() != null && ar.getActionException() == null) {
            String view = ar.getView().toString();
            log.debug((Object)("Result:" + view));
            RequestDispatcher dispatcher = null;
            try {
                dispatcher = aRequest.getRequestDispatcher(view);
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (dispatcher == null) {
                throw new ServletException("No presentation file with name '" + view + "' found!");
            }
            try {
                try {
                    if (aRequest.getAttribute("javax.servlet.include.servlet_path") == null) {
                        aRequest.setAttribute("webwork.view_uri", (Object)view);
                        aRequest.setAttribute("webwork.request_uri", (Object)aRequest.getRequestURI());
                        dispatcher.forward((ServletRequest)aRequest, (ServletResponse)aResponse);
                    } else {
                        dispatcher.include((ServletRequest)aRequest, (ServletResponse)aResponse);
                    }
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                aRequest.setAttribute(STACK_HEAD, ServletValueStack.getStack((ServletRequest)aRequest).popValue());
                throw throwable;
            }
            aRequest.setAttribute(STACK_HEAD, ServletValueStack.getStack((ServletRequest)aRequest).popValue());
        }
        gd.finalizeContext();
    }

    private String getActionName(String name) {
        int beginIdx = name.lastIndexOf("/");
        int endIdx = name.lastIndexOf("." + Configuration.getString("webwork.action.extension"));
        return name.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? name.length() : endIdx);
    }

    private boolean isAction(String action) {
        return action == null ? false : action.endsWith("." + Configuration.getString("webwork.action.extension")) || action.indexOf("." + Configuration.getString("webwork.action.extension") + "?") != -1;
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request) {
        block3: {
            if (request instanceof MultiPartRequestWrapper) {
                return request;
            }
            if (!MultiPartRequest.isMultiPart(request)) break block3;
            try {
                request = new MultiPartRequestWrapper((HttpServletRequest)request, saveDir, maxSize);
            }
            catch (IOException e) {
                request.setAttribute("webwork.action.ResultException", (Object)new ResultException("error", e.getLocalizedMessage()));
            }
        }
        return request;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

