/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.query;

import cirrus.hibernate.Hibernate;
import cirrus.hibernate.QueryException;
import cirrus.hibernate.query.Parser;
import cirrus.hibernate.query.ParserHelper;
import cirrus.hibernate.query.PathExpressionParser;
import cirrus.hibernate.query.QueryTranslator;
import cirrus.hibernate.query.SelectPathExpressionParser;
import java.util.HashSet;
import java.util.Set;

public class SelectParser
implements Parser {
    private static final Set aggregateFunctions = new HashSet();
    private static final Set countArguments = new HashSet();
    private boolean ready;
    private boolean aggregate;
    private boolean count;
    private boolean first;
    private SelectPathExpressionParser pathExpressionParser = new SelectPathExpressionParser();
    private PathExpressionParser aggregatePathExpressionParser = new PathExpressionParser();

    public void token(String token, QueryTranslator q) throws QueryException {
        String lctoken = token.toLowerCase();
        if (this.first) {
            this.first = false;
            if (lctoken.equals("distinct")) {
                q.setDistinct(true);
                return;
            }
            if (lctoken.equals("all")) {
                q.setDistinct(false);
                return;
            }
        }
        if (token.equals(",")) {
            if (this.ready) {
                throw new QueryException("alias or expression expected in SELECT");
            }
            q.appendScalarSelectToken(", ");
            this.ready = true;
        } else if ("(".equals(token)) {
            if (!this.aggregate) {
                throw new QueryException("aggregate function expected before ( in SELECT");
            }
            q.appendScalarSelectToken(token);
            this.ready = true;
        } else if (")".equals(token)) {
            if (!this.aggregate || !this.ready) {
                throw new QueryException("( expected before ) in select");
            }
            q.appendScalarSelectToken(token);
            this.count = false;
            this.aggregate = false;
            this.ready = false;
        } else if (countArguments.contains(lctoken)) {
            if (!this.ready || !this.aggregate) {
                throw new QueryException(token + " only allowed inside aggregate function in SELECT");
            }
            q.appendScalarSelectToken(token);
        } else if (aggregateFunctions.contains(lctoken)) {
            if (!this.ready) {
                throw new QueryException(", expected before aggregate function in SELECT: " + token);
            }
            if (lctoken.equals("count")) {
                q.addScalarType(Hibernate.INTEGER);
                this.count = true;
            }
            this.aggregate = true;
            this.ready = false;
            q.appendScalarSelectToken(token);
        } else if (this.aggregate) {
            if (!this.ready) {
                throw new QueryException("( expected after aggregate function in SELECT");
            }
            ParserHelper.parse(this.aggregatePathExpressionParser, token, ".", q);
            if (this.aggregatePathExpressionParser.isCollectionValued()) {
                q.addCollection(this.aggregatePathExpressionParser.getCollectionName(), this.aggregatePathExpressionParser.getCollectionRole());
            }
            q.appendScalarSelectToken(this.aggregatePathExpressionParser.getWhereColumn());
            if (!this.count) {
                q.addScalarType(this.aggregatePathExpressionParser.getWhereColumnType());
            }
            q.addJoin(this.aggregatePathExpressionParser.getWhereJoin());
        } else {
            if (!this.ready) {
                throw new QueryException(", expected in SELECT");
            }
            ParserHelper.parse(this.pathExpressionParser, token, ".", q);
            if (this.pathExpressionParser.isCollectionValued()) {
                q.addCollection(this.pathExpressionParser.getCollectionName(), this.pathExpressionParser.getCollectionRole());
            } else if (this.pathExpressionParser.getWhereColumnType().isEntityType()) {
                q.addReturnType(this.pathExpressionParser.getSelectName());
            }
            q.appendScalarSelectTokens(this.pathExpressionParser.getWhereColumns());
            q.addScalarType(this.pathExpressionParser.getWhereColumnType());
            q.addJoin(this.pathExpressionParser.getWhereJoin());
            this.ready = false;
        }
    }

    public void start(QueryTranslator q) {
        this.ready = true;
        this.first = true;
        this.aggregate = false;
        this.count = false;
    }

    public void end(QueryTranslator q) {
    }

    static {
        aggregateFunctions.add("count");
        aggregateFunctions.add("avg");
        aggregateFunctions.add("max");
        aggregateFunctions.add("min");
        aggregateFunctions.add("sum");
        countArguments.add("distinct");
        countArguments.add("all");
        countArguments.add("*");
    }
}

