/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.par;

import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.Import;
import org.jbpm.bpel.par.DefDescriptor;
import org.jbpm.bpel.xml.BpelReader;
import org.jbpm.bpel.xml.DefDescriptorReader;
import org.jbpm.bpel.xml.ProblemCollector;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.bpel.xml.ProcessArchiveWsdlLocator;
import org.jbpm.bpel.xml.ProcessWsdlLocator;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.par.ProcessArchiveParser;
import org.jbpm.jpdl.xml.Problem;
import org.xml.sax.InputSource;

public class DefDescriptorArchiveParser
implements ProcessArchiveParser {
    public static final String DEFINITION_DESC_NAME = "META-INF/bpel-definition.xml";
    private static final long serialVersionUID = 1L;

    public ProcessDefinition readFromArchive(ProcessArchive archive, ProcessDefinition processDefinition) {
        BpelProcessDefinition bpelProcessDefinition = new BpelProcessDefinition();
        byte[] descriptorEntry = archive.removeEntry(DEFINITION_DESC_NAME);
        if (descriptorEntry != null) {
            ProblemCollector collector = new ProblemCollector(DEFINITION_DESC_NAME);
            DefDescriptor defDescriptor = this.readDescriptor(descriptorEntry, collector);
            bpelProcessDefinition.setLocation(defDescriptor.getLocation());
            List imports = defDescriptor.getImports();
            if (!imports.isEmpty()) {
                this.readDocuments(imports, archive, collector);
                bpelProcessDefinition.getImportDefinition().setImports(imports);
            }
            archive.getProblems().addAll(collector.getProblems());
        } else {
            String bpelEntryName = this.findBpelEntryName(archive);
            if (bpelEntryName != null) {
                bpelProcessDefinition.setLocation(bpelEntryName);
            } else {
                archive.addProblem(new Problem(2, "definition descriptor not found"));
            }
        }
        return bpelProcessDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefDescriptor readDescriptor(byte[] entry, ProblemHandler problemHandler) {
        DefDescriptorReader reader = DefDescriptorReader.getInstance();
        reader.setProblemHandler(problemHandler);
        try {
            DefDescriptor defDescriptor = new DefDescriptor();
            reader.read(defDescriptor, new InputSource(new ByteArrayInputStream(entry)));
            DefDescriptor defDescriptor2 = defDescriptor;
            return defDescriptor2;
        }
        finally {
            reader.setProblemHandler(null);
        }
    }

    protected void readDocuments(List imports, ProcessArchive archive, ProblemHandler problemHandler) {
        BpelReader bpelReader = new BpelReader();
        bpelReader.setProblemHandler(problemHandler);
        ProcessArchiveWsdlLocator wsdlLocator = new ProcessArchiveWsdlLocator(ProcessWsdlLocator.EMPTY_URI, archive);
        wsdlLocator.setProblemHandler(problemHandler);
        int n = imports.size();
        for (int i = 0; i < n; ++i) {
            Import _import = (Import)imports.get(i);
            Import.Type importType = _import.getType();
            if (!Import.Type.WSDL.equals((Object)importType)) continue;
            bpelReader.readImportWsdlDefinition(_import, wsdlLocator);
            Definition def = (Definition)_import.getDocument();
            String namespace = _import.getNamespace();
            if (namespace == null) {
                _import.setNamespace(def.getTargetNamespace());
                continue;
            }
            if (namespace.equals(def.getTargetNamespace())) continue;
            problemHandler.add(new Problem(2, "import namespace does not match wsdl target namespace"));
        }
        bpelReader.setProblemHandler(null);
    }

    protected String findBpelEntryName(ProcessArchive archive) {
        Iterator entryNameIt = archive.getEntries().keySet().iterator();
        while (entryNameIt.hasNext()) {
            String entryName = (String)entryNameIt.next();
            if (!entryName.endsWith(".bpel")) continue;
            return entryName;
        }
        return null;
    }
}

