/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.persistence.db;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.persistence.db.DbPersistenceService;
import org.jbpm.persistence.PersistenceService;

public class BpelGraphSession {
    private Session session;

    public BpelGraphSession(Session session) {
        this.session = session;
    }

    public BpelProcessDefinition findProcessDefinition(String name, String targetNamespace, int version) {
        Criteria criteria = this.session.createCriteria(BpelProcessDefinition.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"version", (Object)new Integer(version)));
        if (targetNamespace != null) {
            criteria.add((Criterion)Restrictions.eq((String)"targetNamespace", (Object)targetNamespace));
        }
        return (BpelProcessDefinition)((Object)criteria.uniqueResult());
    }

    public BpelProcessDefinition findLatestProcessDefinition(String name, String targetNamespace) {
        Criteria criteria = this.session.createCriteria(BpelProcessDefinition.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).addOrder(Order.desc((String)"version")).setMaxResults(1);
        if (targetNamespace != null) {
            criteria.add((Criterion)Restrictions.eq((String)"targetNamespace", (Object)targetNamespace));
        }
        return (BpelProcessDefinition)((Object)criteria.uniqueResult());
    }

    public static BpelGraphSession getInstance(JbpmContext jbpmContext) {
        PersistenceService persistenceService = jbpmContext.getServices().getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            return ((DbPersistenceService)persistenceService).getBpelGraphSession();
        }
        return null;
    }
}

