/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.plugins.AbstractInstanceBeanInfo;
import org.jboss.beans.info.plugins.AbstractPropertyInfo;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.repository.spi.MetaDataContext;
import org.jboss.repository.spi.MetaDataContextFactory;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractBeanInfo
extends JBossObject
implements BeanInfo {
    protected String name;
    protected ClassAdapter classAdapter;
    protected Set properties;
    protected Set constructors;
    protected Set methods;
    protected Set events;
    protected BeanInfoFactory beanInfoFactory;

    public AbstractBeanInfo(BeanInfoFactory beanInfoFactory, ClassAdapter classAdapter, Set properties, Set constructors, Set methods, Set events) {
        this.beanInfoFactory = beanInfoFactory;
        this.name = classAdapter.getClassInfo().getName();
        this.classAdapter = classAdapter;
        this.properties = properties;
        if (properties != null && !properties.isEmpty()) {
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                AbstractPropertyInfo ainfo = (AbstractPropertyInfo)i.next();
                ainfo.beanInfo = this;
            }
        }
        this.constructors = constructors;
        this.methods = methods;
        this.events = events;
    }

    protected AbstractBeanInfo(AbstractBeanInfo template) {
        this.name = template.name;
        this.classAdapter = template.classAdapter.getInstanceAdapter(template.classAdapter.getClassInfo());
        this.properties = template.properties;
        this.constructors = template.constructors;
        this.methods = template.methods;
        this.events = template.events;
        this.beanInfoFactory = template.beanInfoFactory;
    }

    public String getName() {
        return this.name;
    }

    public Set getProperties() {
        return this.properties;
    }

    public void setProperties(Set properties) {
        this.properties = properties;
    }

    public ClassInfo getClassInfo() {
        return this.classAdapter.getClassInfo();
    }

    public List getDependencies() {
        return this.classAdapter.getDependencies();
    }

    public JoinpointFactory getJoinpointFactory() {
        return this.classAdapter.getJoinpointFactory();
    }

    public MetaDataContextFactory getMetaDataContextFactory() {
        return this.classAdapter.getMetaDataContextFactory();
    }

    public Set getConstructors() {
        return this.constructors;
    }

    public void setConstructors(Set constructors) {
        this.constructors = constructors;
    }

    public Set getEvents() {
        return this.events;
    }

    public void setEvents(Set events) {
        this.events = events;
    }

    public Set getMethods() {
        return this.methods;
    }

    public void setMethods(Set methods) {
        this.methods = methods;
    }

    public BeanInfoFactory getBeanInfoFactory() {
        return this.beanInfoFactory;
    }

    public MetaDataContext getMetaDataContext() {
        return this.classAdapter.getMetaDataContext();
    }

    public void setMetaDataContext(MetaDataContext metaCtx) {
        this.classAdapter.setMetaDataContext(metaCtx);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractBeanInfo)) {
            return false;
        }
        AbstractBeanInfo other = (AbstractBeanInfo)object;
        if (AbstractBeanInfo.notEqual(this.name, other.name)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.classAdapter, other.classAdapter)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.properties, other.properties)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.methods, other.methods)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.constructors, other.constructors)) {
            return false;
        }
        return !AbstractBeanInfo.notEqual(this.events, other.events);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" classInfo=");
        this.classAdapter.toShortString(buffer);
        buffer.append(" properties=");
        JBossObject.list(buffer, this.properties);
        buffer.append(" methods=");
        JBossObject.list(buffer, this.methods);
        buffer.append(" constructors=");
        JBossObject.list(buffer, this.constructors);
        buffer.append(" events=");
        JBossObject.list(buffer, this.events);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    public int getHashCode() {
        return this.name.hashCode();
    }

    public BeanInfo getInstanceInfo() {
        return new AbstractInstanceBeanInfo(this);
    }
}

