/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationReader;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;

public class Options {
    boolean errorDump = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$fop$configuration$ConfigurationReader;

    public Options() throws FOPException {
        this.loadStandardConfiguration();
        this.initOptions();
    }

    public Options(File userConfigFile) throws FOPException {
        this();
        this.loadUserconfiguration(userConfigFile);
    }

    public Options(InputStream userConfig) throws FOPException {
        this();
        this.loadUserconfiguration(userConfig);
    }

    public Options(CommandLineOptions clOptions) throws FOPException {
        this();
        this.setCommandLineOptions(clOptions);
    }

    public Options(InputSource userConfig) throws FOPException {
        this();
        this.loadUserconfiguration(userConfig);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void initOptions() {
        if (Configuration.getBooleanValue("quiet").booleanValue()) {
            MessageHandler.setQuiet(true);
        }
        if (Configuration.getBooleanValue("debugMode").booleanValue()) {
            this.errorDump = true;
        }
        if (Configuration.getBooleanValue("dumpConfiguration").booleanValue()) {
            Configuration.put("dumpConfiguration", "true");
            Configuration.dumpConfiguration();
        }
    }

    public void loadStandardConfiguration() throws FOPException {
        String file = "config.xml";
        InputStream configfile = null;
        try {
            Method getCCL = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = Options.class$("java.lang.Thread"))).getMethod("getContextClassLoader", new Class[0]);
            if (getCCL != null) {
                ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), new Object[0]);
                configfile = contextClassLoader.getResourceAsStream("conf/" + file);
            }
        }
        catch (Exception exception) {}
        if (configfile == null) {
            configfile = (class$org$apache$fop$configuration$ConfigurationReader != null ? class$org$apache$fop$configuration$ConfigurationReader : (class$org$apache$fop$configuration$ConfigurationReader = Options.class$("org.apache.fop.configuration.ConfigurationReader"))).getResourceAsStream("/conf/" + file);
        }
        if (configfile == null) {
            throw new FOPException("can't find default configuration file");
        }
        if (this.errorDump) {
            MessageHandler.logln("reading default configuration file");
        }
        ConfigurationReader reader = new ConfigurationReader(new InputSource(configfile));
        if (this.errorDump) {
            reader.setDumpError(true);
        }
        reader.start();
    }

    public void loadUserconfiguration(File userConfigFile) {
        if (userConfigFile != null) {
            this.loadUserconfiguration(InputHandler.fileInputSource(userConfigFile));
        }
    }

    public void loadUserconfiguration(InputStream userConfig) {
        this.loadUserconfiguration(new InputSource(userConfig));
    }

    public void loadUserconfiguration(String userConfigFile) {
        this.loadUserconfiguration(new File(userConfigFile));
    }

    public void loadUserconfiguration(InputSource userConfigSource) {
        block3: {
            ConfigurationReader reader = new ConfigurationReader(userConfigSource);
            if (this.errorDump) {
                reader.setDumpError(true);
            }
            try {
                reader.start();
            }
            catch (FOPException error) {
                MessageHandler.errorln("Could not load user configuration " + userConfigSource.getSystemId() + " - error: " + error.getMessage());
                MessageHandler.errorln("using default values");
                if (!this.errorDump) break block3;
                reader.dumpError(error);
            }
        }
    }

    void setCommandLineOptions(CommandLineOptions clOptions) {
        String baseDir;
        boolean dumpConfiguration;
        File userConfigFile = clOptions.getUserConfigFile();
        if (userConfigFile != null) {
            this.loadUserconfiguration(userConfigFile);
        }
        if (clOptions.isDebugMode() != null) {
            this.errorDump = clOptions.isDebugMode();
            Configuration.put("debugMode", new Boolean(this.errorDump));
        }
        if (dumpConfiguration = clOptions.dumpConfiguration() != null ? clOptions.dumpConfiguration().booleanValue() : Configuration.getBooleanValue("dumpConfiguration").booleanValue()) {
            Configuration.put("dumpConfiguration", "true");
            Configuration.dumpConfiguration();
            System.exit(0);
        }
        if (clOptions.isQuiet() != null) {
            MessageHandler.setQuiet(clOptions.isQuiet());
        }
        if ((baseDir = Configuration.getStringValue("baseDir")) == null) {
            try {
                baseDir = new File(clOptions.getInputFile().getAbsolutePath()).getParentFile().toURL().toExternalForm();
                Configuration.put("baseDir", baseDir);
            }
            catch (Exception exception) {}
        }
        if (this.errorDump) {
            MessageHandler.logln("base directory: " + baseDir);
        }
    }
}

