/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.IntervalRenderer;
import com.icesoft.faces.async.render.OnDemandRenderer;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelayRenderer
extends OnDemandRenderer
implements Runnable {
    private static Log log = LogFactory.getLog((Class)IntervalRenderer.class);
    private ScheduledFuture future;
    private long delay = 60000L;

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void requestRender() {
        ScheduledThreadPoolExecutor scheduleService = this.renderManager.getScheduledService();
        this.future = scheduleService.schedule((Runnable)this, this.delay, TimeUnit.MILLISECONDS);
        if (log.isDebugEnabled()) {
            log.debug((Object)("delay render started: delay is " + this.delay + " ms"));
        }
    }

    public void requestStop() {
        super.requestStop();
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(false);
        }
    }

    public void run() {
        super.requestRender();
    }

    public void dispose() {
        super.dispose();
        this.future = null;
    }
}

