/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.ApplicationBaseLocator;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.w3c.dom.Element;

public class TableRenderer
extends DomBasicRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element root;
        this.validateParameters(facesContext, uiComponent, null);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Debug.assertTrue(responseWriter != null, "ResponseWriter is null");
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            root = null;
            root = this.isScrollable(uiComponent) ? domContext.createElement("div") : domContext.createElement("table");
            domContext.setRootNode(root);
            TableRenderer.setRootElementId(facesContext, root, uiComponent);
            PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null);
        }
        root = (Element)domContext.getRootNode();
        DOMContext.removeChildren(root);
        String styleClass = this.getComponentStyleClass(uiComponent);
        if (styleClass != null && styleClass.length() > 0) {
            root.setAttribute("class", styleClass);
        }
        root.setAttribute("cellspacing", "0");
        if (this.isScrollable(uiComponent)) {
            Element headerDiv = domContext.createElement("div");
            Element headerTable = domContext.createElement("table");
            headerDiv.appendChild(headerTable);
            root.appendChild(headerDiv);
            Element bodyDiv = domContext.createElement("div");
            String height = (String)uiComponent.getAttributes().get("scrollHeight");
            bodyDiv.setAttribute("style", "overflow:auto;height:" + height + ";");
            Element bodytable = domContext.createElement("table");
            bodyDiv.appendChild(bodytable);
            root.appendChild(bodyDiv);
        }
        this.renderFacet(facesContext, uiComponent, domContext, true);
        this.renderFacet(facesContext, uiComponent, domContext, false);
    }

    public String getComponentStyleClass(UIComponent uiComponent) {
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        return styleClass;
    }

    protected void renderFacet(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext, boolean header) throws IOException {
        Element tr;
        String facetClass;
        String element;
        String tag;
        String facet;
        if (header) {
            facet = "header";
            tag = "thead";
            element = "th";
            facetClass = this.getHeaderClass(uiComponent);
        } else {
            facet = "footer";
            tag = "tfoot";
            element = "td";
            facetClass = this.getFooterClass(uiComponent);
        }
        UIData uiData = (UIData)uiComponent;
        uiData.setRowIndex(-1);
        Element root = (Element)domContext.getRootNode();
        if (this.isScrollable(uiComponent)) {
            if (header) {
                Element headerDiv = domContext.createElement("div");
                Element headerTable = domContext.createElement("table");
                headerDiv.appendChild(headerTable);
                root.appendChild(headerDiv);
                root = headerTable;
            } else {
                root = (Element)root.getChildNodes().item(1).getFirstChild();
            }
        }
        UIComponent headerFacet = TableRenderer.getFacetByName((UIComponent)uiData, facet);
        boolean childHeaderFacetExists = this.childColumnHasFacetWithName((UIComponent)uiData, facet);
        Element thead = null;
        if (headerFacet != null || childHeaderFacetExists) {
            thead = domContext.createElement(tag);
            root.appendChild(thead);
        }
        if (headerFacet != null && headerFacet.isRendered()) {
            this.resetFacetChildId(headerFacet);
            tr = domContext.createElement("tr");
            thead.appendChild(tr);
            Element th = domContext.createElement(element);
            tr.appendChild(th);
            if (facetClass != null) {
                th.setAttribute("class", facetClass);
            }
            th.setAttribute("colspan", String.valueOf(this.getNumberOfChildColumns((UIComponent)uiData)));
            th.setAttribute("scope", "colgroup");
            domContext.setCursorParent(th);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), th);
            TableRenderer.encodeParentAndChildren(facesContext, headerFacet);
        }
        if (childHeaderFacetExists) {
            tr = domContext.createElement("tr");
            thead.appendChild(tr);
            StringTokenizer columnWidths = this.getColumnWidths((UIComponent)uiData);
            Iterator childColumns = this.getRenderedChildColumnsIterator((UIComponent)uiData);
            while (childColumns.hasNext()) {
                UIColumn nextColumn = (UIColumn)childColumns.next();
                Element th = domContext.createElement(element);
                tr.appendChild(th);
                if (facetClass != null) {
                    th.setAttribute("class", facetClass);
                }
                if (columnWidths != null && columnWidths.hasMoreTokens()) {
                    String width = columnWidths.nextToken();
                    th.setAttribute("style", "width:" + width + ";overflow:hidden;");
                }
                th.setAttribute("colgroup", "col");
                UIComponent nextFacet = TableRenderer.getFacetByName((UIComponent)nextColumn, facet);
                if (nextFacet == null) continue;
                this.resetFacetChildId(nextFacet);
                domContext.setCursorParent(th);
                domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), th);
                TableRenderer.encodeParentAndChildren(facesContext, nextFacet);
            }
            tr.appendChild(this.scrollBarSpacer(domContext, facesContext));
        }
        domContext.setCursorParent(root);
    }

    protected void resetFacetChildId(UIComponent component) {
        component.setId(component.getId());
        Iterator facetChild = component.getChildren().iterator();
        while (facetChild.hasNext()) {
            UIComponent child = (UIComponent)facetChild.next();
            this.resetFacetChildId(child);
        }
    }

    public String getHeaderClass(UIComponent component) {
        return (String)component.getAttributes().get("headerClass");
    }

    public String getFooterClass(UIComponent component) {
        return (String)component.getAttributes().get("footerClass");
    }

    protected boolean childColumnHasFacetWithName(UIComponent component, String facetName) {
        Iterator childColumns = this.getRenderedChildColumnsIterator(component);
        while (childColumns.hasNext()) {
            UIColumn nextChildColumn = (UIColumn)childColumns.next();
            if (TableRenderer.getFacetByName((UIComponent)nextChildColumn, facetName) == null) continue;
            return true;
        }
        return false;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        Element root = (Element)domContext.getRootNode();
        Element tbody = domContext.createElement("tbody");
        root.appendChild(tbody);
        String[] columnStyles = this.getColumnStyleClasses(uiComponent);
        String[] rowStyles = this.getRowStyles(uiComponent);
        int columnStyleIndex = 0;
        int rowStyleIndex = 0;
        int columnStylesMaxIndex = columnStyles.length - 1;
        int rowStylesMaxIndex = rowStyles.length - 1;
        UIData uiData = (UIData)uiComponent;
        int rowIndex = uiData.getFirst();
        int numberOfRowsToDisplay = uiData.getRows();
        uiData.setRowIndex(rowIndex);
        for (int countOfRowsDisplayed = 0; uiData.isRowAvailable() && (numberOfRowsToDisplay <= 0 || countOfRowsDisplayed < numberOfRowsToDisplay); ++countOfRowsDisplayed) {
            Element tr = domContext.createElement("tr");
            tr.setAttribute("id", uiComponent.getClientId(facesContext));
            tbody.appendChild(tr);
            if (rowStylesMaxIndex >= 0) {
                tr.setAttribute("class", rowStyles[rowStyleIndex]);
                if (++rowStyleIndex > rowStylesMaxIndex) {
                    rowStyleIndex = 0;
                }
            }
            Iterator childColumns = this.getRenderedChildColumnsIterator((UIComponent)uiData);
            StringTokenizer columnWidths = this.getColumnWidths(uiComponent);
            int colNumber = 1;
            while (childColumns.hasNext()) {
                UIColumn nextColumn = (UIColumn)childColumns.next();
                Element td = domContext.createElement("td");
                if (columnWidths != null && columnWidths.hasMoreTokens()) {
                    td.setAttribute("style", "width:" + columnWidths.nextToken() + ";");
                }
                tr.appendChild(td);
                this.writeColStyles(columnStyles, columnStylesMaxIndex, columnStyleIndex, td, colNumber++);
                if (++columnStyleIndex > columnStylesMaxIndex) {
                    columnStyleIndex = 0;
                }
                Iterator childrenOfThisColumn = nextColumn.getChildren().iterator();
                domContext.setCursorParent(td);
                domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), td);
                while (childrenOfThisColumn.hasNext()) {
                    UIComponent nextChild = (UIComponent)childrenOfThisColumn.next();
                    if (!nextChild.isRendered()) continue;
                    TableRenderer.encodeParentAndChildren(facesContext, nextChild);
                }
            }
            uiData.setRowIndex(++rowIndex);
            columnStyleIndex = 0;
        }
        uiData.setRowIndex(-1);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    public void writeColStyles(String[] columnStyles, int columnStylesMaxIndex, int columnStyleIndex, Element td, int colNumber) {
        if (columnStyles.length > 0 && columnStylesMaxIndex >= 0) {
            td.setAttribute("class", columnStyles[columnStyleIndex]);
            if (++columnStyleIndex > columnStylesMaxIndex) {
                columnStyleIndex = 0;
            }
        }
    }

    public String[] getRowStyles(UIComponent uiComponent) {
        return this.getRowStyleClasses(uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        if (!uiComponent.isRendered()) {
            return;
        }
    }

    protected int getNumberOfChildColumns(UIComponent component) {
        return this.getRenderedChildColumnsList(component).size();
    }

    protected Iterator getRenderedChildColumnsIterator(UIComponent component) {
        return this.getRenderedChildColumnsList(component).iterator();
    }

    protected List getRenderedChildColumnsList(UIComponent component) {
        ArrayList<UIComponent> results = new ArrayList<UIComponent>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
            results.add(kid);
        }
        return results;
    }

    protected boolean isScrollable(UIComponent uiComponent) {
        Object o = uiComponent.getAttributes().get("scrollable");
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    protected Element scrollBarSpacer(DOMContext domContext, FacesContext facesContext) {
        Element spacer = domContext.createElement("th");
        String base = ApplicationBaseLocator.locate(facesContext);
        Element spacerImg = domContext.createElement("img");
        spacerImg.setAttribute("src", base + "xmlhttp/css/xp/css-images/selection_spacer.gif");
        spacerImg.setAttribute("border", "0");
        spacer.appendChild(spacerImg);
        return spacer;
    }

    protected StringTokenizer getColumnWidths(UIComponent uiComponent) {
        Object o = uiComponent.getAttributes().get("columnWidths");
        if (o != null && o instanceof String) {
            return new StringTokenizer(o.toString(), ",");
        }
        return null;
    }
}

