/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ResourceLoaderAdapter
implements UnifiedVirtualFile {
    private URL resourceURL;
    private ClassLoader loader;

    public ResourceLoaderAdapter() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ResourceLoaderAdapter(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    private ResourceLoaderAdapter(ClassLoader classLoader, URL uRL) {
        this.resourceURL = uRL;
        this.loader = classLoader;
    }

    public UnifiedVirtualFile findChild(String string) throws IOException {
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) {
                try {
                    File file = new File(string);
                    if (file.exists()) {
                        uRL = file.toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null) {
                try {
                    uRL = this.loader.getResource(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (uRL == null) {
            throw new IOException("Cannot get URL for: " + string);
        }
        return new ResourceLoaderAdapter(this.loader, uRL);
    }

    public URL toURL() {
        if (null == this.resourceURL) {
            throw new IllegalStateException("UnifiedVirtualFile not initialized");
        }
        return this.resourceURL;
    }
}

