/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.log;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.wsf.common.log.JBossLogHandler;
import org.jboss.wsf.common.log.NamespaceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLogRedirector {
    private List<String> namespaces = new LinkedList<String>();

    public void changeHandlers() {
        for (String string : this.namespaces) {
            this.changeHandler(string);
        }
    }

    public void changeHandler(String string) {
        if (string == null) {
            string = "";
        }
        org.jboss.logging.Logger.getLogger(this.getClass()).info((Object)("Changing current root logger's log handlers to hide logs with namespace " + string));
        Logger logger = Logger.getLogger("");
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            if (handler instanceof JBossLogHandler) continue;
            StringBuffer stringBuffer = new StringBuffer("Disableing handler ");
            stringBuffer.append(handler).append(" with level ").append(handler.getLevel());
            org.jboss.logging.Logger.getLogger(this.getClass()).debug((Object)stringBuffer);
            Filter filter = handler.getFilter();
            if (filter != null && filter instanceof NamespaceFilter) {
                ((NamespaceFilter)filter).addNamespace(string);
                continue;
            }
            NamespaceFilter namespaceFilter = new NamespaceFilter(false);
            namespaceFilter.addNamespace(string);
            handler.setFilter(namespaceFilter);
        }
        JBossLogHandler jBossLogHandler = new JBossLogHandler();
        jBossLogHandler.setLevel(Level.ALL);
        Logger.getLogger(string).addHandler(jBossLogHandler);
    }

    public void addNamespace(String string) {
        this.namespaces.add(string);
        this.changeHandler(string);
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> list) {
        this.namespaces = list;
        this.changeHandlers();
    }
}

