DragIndicator = {

    init: function(event) {
    },

    setContent: function(name, single, params) {
		Element.clearChildren(this);

		if (!params) {
			params = {};
		}

		if (!params['marker']) {
			if (params[name]) {
				params['marker'] = params[name];
			} else {
				params['marker'] = this.markers[name];
			}
		}

		if (single) {
			this.indicatorTemplates['single'](this, params);
		} else {
			this.indicatorTemplates['multi'](this, params);
		}
	},

	show: function() {
		Element.show(this);
		this.style.position = 'absolute';
	},

	hide: function() {
		Element.hide(this);
		this.style.position = '';
		this.offsets = undefined;
	},

	position: function(x, y) {
		if (!this.offsets) {
			Element.show(this);
			this.style.position = 'absolute';

			this.offsets = Position.cumulativeOffset(this);
			this.offsets[0] -= this.offsetLeft || 0;
			this.offsets[1] -= this.offsetTop || 0;
		}		

		Element.setStyle(this, {"left": - this.offsets[0] + x + "px", "top": - this.offsets[1] + y + "px"});
	},

	accept: function() {
		Element.removeClassName(this, 'drgind_default');
		Element.removeClassName(this, 'drgind_reject');
		Element.addClassName(this, 'drgind_accept');

		var acceptClass = this.getAcceptClass();
		if (acceptClass) {
			Element.addClassName(this, acceptClass);
		}
	},

	reject: function() {
		Element.removeClassName(this, 'drgind_default');
		Element.removeClassName(this, 'drgind_accept');
		Element.addClassName(this, 'drgind_reject');

		var rejectClass = this.getRejectClass();
		if (rejectClass) {
			Element.addClassName(this, rejectClass);
		}
	},

	leave: function() {
		Element.removeClassName(this, 'drgind_accept');
		Element.removeClassName(this, 'drgind_reject');
		Element.addClassName(this, 'drgind_default');

		var acceptClass = this.getAcceptClass();
		var rejectClass = this.getRejectClass();
		if (acceptClass) {
			Element.removeClassName(this, acceptClass);
		}
		if (rejectClass) {
			Element.removeClassName(this, rejectClass);
		}
	},

	getAcceptClass: function() {
		return this.ils_acceptClass;
	},

	getRejectClass: function() {
		return this.ils_rejectClass;
	}
};

function createDragIndicator(elt) {
    Object.extend(elt, DragIndicator);
}

