/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.JavaKeywords;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.XSDTypeToJava;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWriter {
    private String newline = "\n";
    protected WSDLUtils utils = WSDLUtils.getInstance();

    public void createJavaFileForEnumeratedValues(String fname, StringList lst, File loc, String pkgname, XSSimpleTypeDefinition type) throws IOException {
        String str;
        int i;
        ArrayList<String> importList = new ArrayList<String>();
        importList.add("java.util.Map");
        importList.add("java.util.HashMap");
        File sei = this.utils.createPhysicalFile(loc, fname);
        StringBuilder buf = this.utils.createClassBasicStructure(pkgname, fname, (XSTypeDefinition)type, importList, null);
        buf.append("private java.lang.String value;" + this.newline);
        buf.append("private static Map valueMap = new HashMap();" + this.newline);
        int lenOfArr = lst != null ? lst.getLength() : 0;
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            buf.append("public static final String _" + str + "String = \"" + str + "\";" + this.newline);
        }
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            buf.append("public static final java.lang.String _" + str + " = new java.lang.String(_" + str + "String);");
            buf.append(this.newline);
        }
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            buf.append("public static final " + fname + " " + str + " = new " + fname + "(_" + str + ");");
            buf.append(this.newline);
        }
        buf.append(this.newline + this.newline + "protected " + fname + "(java.lang.String value) { " + this.newline);
        buf.append("this.value = value;valueMap.put(this.toString(), this); " + this.newline + "}");
        buf.append(this.newline + this.newline);
        buf.append(this.newline + " public java.lang.String getValue() {" + this.newline + "  return value;" + this.newline + "}");
        buf.append(this.newline + this.newline);
        buf.append(this.newline + "public static " + fname + "  fromValue(java.lang.String value)" + this.newline);
        buf.append(" throws java.lang.IllegalStateException {" + this.newline);
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            if (i > 0) {
                buf.append("else ");
            }
            buf.append("if (" + str + ".value.equals(value)) {" + this.newline);
            buf.append("return " + str + ";" + this.newline);
            buf.append("}" + this.newline);
        }
        buf.append(" throw new IllegalArgumentException();" + this.newline + "}" + this.newline + this.newline);
        buf.append(this.newline + "public static " + fname + "  fromString(String value)" + this.newline);
        buf.append(" throws java.lang.IllegalStateException {" + this.newline);
        buf.append(fname + " ret = (" + fname + ")valueMap.get(value);" + this.newline);
        buf.append("if (ret != null) {" + this.newline + " return ret;" + this.newline + " }" + this.newline + this.newline);
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            if (i > 0) {
                buf.append("else ");
            }
            buf.append("if (value.equals(_" + str + "String)) {" + this.newline);
            buf.append("return " + str + ";" + this.newline + "}");
        }
        buf.append(this.newline + " throw new IllegalArgumentException();" + this.newline + "}" + this.newline + this.newline);
        buf.append(this.newline + " public String toString() {" + this.newline + " return value.toString();" + this.newline + "}" + this.newline);
        buf.append(this.newline + "private Object readResolve()" + this.newline + "        throws java.io.ObjectStreamException {" + this.newline + "        return fromValue(getValue());" + this.newline + "    } " + this.newline);
        buf.append(this.newline + "private boolean equals(Object obj){" + this.newline + "         if (!(obj instanceof " + fname + ")) {" + this.newline + "         return false;" + this.newline + "    } " + this.newline);
        buf.append("return ((" + fname + ")obj).value.equals(value);" + this.newline + "}" + this.newline);
        buf.append(this.newline + " public int hashCode() { " + this.newline + "        return value.hashCode(); " + this.newline + "    }" + this.newline);
        buf.append("}" + this.newline);
        FileWriter writer = new FileWriter(sei);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
    }

    public void createJavaFile(File location, String filename, String packageName, List<XSDTypeToJava.VAR> vars, List<String> importList, String baseTypeName, boolean isExceptionType, boolean isSerializable, Map<String, List> typeNameToBaseVARList) throws IOException {
        File newLoc = null;
        newLoc = this.needToCreatePackageStructure(location, packageName) ? this.utils.createPackage(location.getPath(), packageName) : location;
        String classname = this.utils.chop(filename, ".java");
        File sei = this.utils.createPhysicalFile(newLoc, classname);
        StringBuilder buffer = new StringBuilder();
        this.utils.writeJbossHeader(buffer);
        buffer.append(this.newline).append("package ").append(packageName).append(";");
        if (importList != null) {
            for (String imp : importList) {
                buffer.append(this.newline).append("import ").append(imp).append(";");
            }
        }
        buffer.append(this.newline).append(this.newline);
        buffer.append(this.newline).append("public class  ").append(classname).append(this.newline);
        if (baseTypeName != null && baseTypeName.length() > 0) {
            buffer.append(" extends ").append(baseTypeName);
        }
        if (isSerializable) {
            buffer.append(" implements java.io.Serializable");
        }
        buffer.append("{").append(this.newline);
        this.createVariables(buffer, vars, isExceptionType);
        this.createCTR(buffer, classname, vars, isExceptionType, typeNameToBaseVARList);
        buffer.append(this.newline);
        this.createAccessors(buffer, vars, isExceptionType);
        buffer.append("}").append(this.newline);
        FileWriter writer = new FileWriter(sei);
        writer.write(buffer.toString());
        writer.flush();
        writer.close();
    }

    private void createCTR(StringBuilder buf, String cname, List vars, boolean isExceptionType, Map<String, List> typeNameToBaseVARList) {
        if (vars.size() > 0 && !isExceptionType) {
            buf.append("public " + cname + "(){}");
            buf.append(this.newline);
            buf.append(this.newline);
        }
        StringBuilder ctrvarbuf = new StringBuilder();
        StringBuilder ctrintbuf = new StringBuilder();
        boolean calledSuper = false;
        if (isExceptionType) {
            List baseList = typeNameToBaseVARList.get(cname);
            int baseLen = baseList != null ? baseList.size() : 0;
            String arrStr = "[]";
            if (baseLen > 0) {
                calledSuper = true;
                ctrintbuf.append("super(");
                for (int i = 0; i < baseLen; ++i) {
                    if (i > 0) {
                        ctrvarbuf.append(", ");
                        ctrintbuf.append(", ");
                    }
                    XSDTypeToJava.VAR v = (XSDTypeToJava.VAR)baseList.get(i);
                    ctrvarbuf.append(v.getVartype());
                    if (v.isArrayType) {
                        ctrvarbuf.append(arrStr);
                    }
                    ctrvarbuf.append(" ").append(v.getVarname());
                    ctrintbuf.append(v.getVarname());
                }
                ctrintbuf.append(");").append(this.newline);
            }
        }
        Iterator iter = vars.iterator();
        int index = 0;
        while (iter.hasNext()) {
            XSDTypeToJava.VAR v;
            String name;
            if (index++ > 0 || calledSuper) {
                ctrvarbuf.append(", ");
            }
            if (JavaKeywords.isJavaKeyword(name = (v = (XSDTypeToJava.VAR)iter.next()).getVarname())) {
                name = "_" + name;
            }
            String type = v.getVartype();
            boolean isArr = v.isArrayType();
            ctrvarbuf.append(type);
            if (isArr) {
                ctrvarbuf.append("[]");
            }
            ctrvarbuf.append(" " + name);
            if (isExceptionType && !calledSuper && index == 1 && v.getVartype().equals("java.lang.String")) {
                ctrintbuf.append("super(").append(v.getVarname()).append(");").append(this.newline);
                calledSuper = true;
            }
            ctrintbuf.append("this." + name + "=" + name + ";");
            ctrintbuf.append(this.newline);
        }
        buf.append("public " + cname + "(" + ctrvarbuf.toString() + "){");
        buf.append(this.newline);
        buf.append(ctrintbuf.toString());
        buf.append("}");
    }

    private void createAccessors(StringBuilder buf, List vars, boolean isExceptionType) {
        for (XSDTypeToJava.VAR v : vars) {
            String name = v.getVarname();
            String internalName = name;
            if (JavaKeywords.isJavaKeyword(internalName)) {
                internalName = "_" + internalName;
            }
            String type = v.getVartype();
            boolean isArr = v.isArrayType();
            buf.append("public " + type);
            if (isArr) {
                buf.append("[] ");
            }
            String str = " get";
            if (type.equals("boolean")) {
                str = " is";
            }
            buf.append(str + this.utils.getMixedCase(name) + "() { return " + internalName + " ;}");
            buf.append(this.newline);
            buf.append(this.newline);
            if (!isExceptionType) {
                this.writeSetter(buf, name, internalName, type, isArr);
            }
            buf.append(this.newline);
            buf.append(this.newline);
        }
    }

    private List createVariables(StringBuilder buf, List vars, boolean isExceptionType) {
        if (vars == null) {
            return vars;
        }
        for (XSDTypeToJava.VAR v : vars) {
            String name = v.getVarname();
            if (JavaKeywords.isJavaKeyword(name = ToolsUtils.convertInvalidCharacters(name))) {
                name = "_" + name;
            }
            String type = v.getVartype();
            boolean isArr = v.isArrayType();
            buf.append(this.newline);
            if (isExceptionType) {
                buf.append("private " + type);
            } else {
                buf.append("protected " + type);
            }
            if (isArr) {
                buf.append("[] ");
            }
            buf.append(" " + name).append(";").append(this.newline);
        }
        return vars;
    }

    private boolean needToCreatePackageStructure(File location, String packageName) {
        packageName = packageName.replace('.', '/');
        try {
            String externalForm = location.toURL().toExternalForm();
            return externalForm.indexOf(packageName) < 0;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private void writeSetter(StringBuilder buf, String name, String internalName, String type, boolean isArr) {
        buf.append("public void ");
        buf.append("set" + this.utils.getMixedCase(name) + "(" + type);
        if (isArr) {
            buf.append("[]");
        }
        buf.append(" " + internalName + "){ this." + internalName + "=" + internalName + "; }");
    }
}

