/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.taskdefs.XSLTLoggerAware;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TraXLiaison
implements XSLTLiaison,
ErrorListener,
XSLTLoggerAware {
    private TransformerFactory tfactory = TransformerFactory.newInstance();
    private FileInputStream xslStream = null;
    private Templates templates = null;
    private Transformer transformer = null;
    private XSLTLogger logger;
    private EntityResolver resolver;

    public TraXLiaison() throws Exception {
        this.tfactory.setErrorListener(this);
    }

    public void setStylesheet(File stylesheet) throws Exception {
        this.xslStream = new FileInputStream(stylesheet);
        StreamSource src = new StreamSource(this.xslStream);
        src.setSystemId(this.getSystemId(stylesheet));
        this.templates = this.tfactory.newTemplates(src);
        this.transformer = this.templates.newTransformer();
        this.transformer.setErrorListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(File infile, File outfile) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            void var5_8;
            fis = new FileInputStream(infile);
            fos = new FileOutputStream(outfile);
            Object var5_5 = null;
            if (this.resolver != null) {
                if (!this.tfactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) throw new IllegalStateException("xcatalog specified, but parser doesn't support SAX");
                SAXParserFactory spFactory = SAXParserFactory.newInstance();
                spFactory.setNamespaceAware(true);
                XMLReader reader = spFactory.newSAXParser().getXMLReader();
                reader.setEntityResolver(this.resolver);
                SAXSource sAXSource = new SAXSource(reader, new InputSource(fis));
            } else {
                StreamSource streamSource = new StreamSource(fis);
            }
            var5_8.setSystemId(this.getSystemId(infile));
            StreamResult res = new StreamResult(fos);
            res.setSystemId(this.getSystemId(outfile));
            this.transformer.transform((Source)var5_8, res);
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (this.xslStream != null) {
                    this.xslStream.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (this.xslStream != null) {
                this.xslStream.close();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            if (fos == null) return;
            fos.close();
            return;
        }
        catch (IOException ignored) {}
    }

    protected String getSystemId(File file) {
        String path = file.getAbsolutePath();
        path = path.replace('\\', '/');
        if (File.separatorChar == '\\') {
            return "file:///" + path;
        }
        return "file://" + path;
    }

    public void addParam(String name, String value) {
        this.transformer.setParameter(name, value);
    }

    public void setOutputtype(String type) throws Exception {
        this.transformer.setOutputProperty("method", type);
    }

    public void setLogger(XSLTLogger l) {
        this.logger = l;
    }

    public void error(TransformerException e) {
        this.logError(e, "Error");
    }

    public void fatalError(TransformerException e) {
        this.logError(e, "Fatal Error");
        throw new BuildException("Fatal error during transformation", (Throwable)e);
    }

    public void warning(TransformerException e) {
        this.logError(e, "Warning");
    }

    private void logError(TransformerException e, String type) {
        if (this.logger == null) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        if (e.getLocator() != null) {
            if (e.getLocator().getSystemId() != null) {
                String url = e.getLocator().getSystemId();
                if (url.startsWith("file:///")) {
                    url = url.substring(8);
                }
                msg.append(url);
            } else {
                msg.append("Unknown file");
            }
            if (e.getLocator().getLineNumber() != -1) {
                msg.append(":" + e.getLocator().getLineNumber());
                if (e.getLocator().getColumnNumber() != -1) {
                    msg.append(":" + e.getLocator().getColumnNumber());
                }
            }
        }
        msg.append(": " + type + "! ");
        msg.append(e.getMessage());
        if (e.getCause() != null) {
            msg.append(" Cause: " + e.getCause());
        }
        this.logger.log(msg.toString());
    }

    public void setEntityResolver(EntityResolver aResolver) throws Exception {
        this.resolver = aResolver;
    }
}

