/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.group.ValueList;
import org.jboss.xb.binding.group.ValueListHandler;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;

public class ValueListInitializer {
    private int initializedState;
    private Map attrIndex = Collections.EMPTY_MAP;
    private Map elemIndex = Collections.EMPTY_MAP;
    private List requiredBindings = Collections.EMPTY_LIST;

    public void addRequiredAttribute(QName qName, AttributeBinding binding) {
        Integer index = new Integer(this.requiredBindings.size());
        switch (this.attrIndex.size()) {
            case 0: {
                this.attrIndex = Collections.singletonMap(qName, index);
                break;
            }
            case 1: {
                this.attrIndex = new HashMap(this.attrIndex);
            }
            default: {
                this.attrIndex.put(qName, index);
            }
        }
        this.addBinding(binding);
        this.initializedState += Math.abs(qName.hashCode());
    }

    public void addRequiredElement(QName qName, ElementBinding binding) {
        Integer index = new Integer(this.requiredBindings.size());
        switch (this.elemIndex.size()) {
            case 0: {
                this.elemIndex = Collections.singletonMap(qName, index);
                break;
            }
            case 1: {
                this.elemIndex = new HashMap(this.elemIndex);
            }
            default: {
                this.elemIndex.put(qName, index);
            }
        }
        this.addBinding(binding);
        this.initializedState += Math.abs(qName.hashCode());
    }

    public ValueList newValueList(ValueListHandler handler, Class targetClass) {
        return new ValueList(this, handler, targetClass);
    }

    public void addAttributeValue(QName qName, AttributeBinding binding, ValueList valueList, Object value) {
        Integer index = (Integer)this.attrIndex.get(qName);
        if (index == null) {
            valueList.setNonRequiredValue(qName, binding, value);
        } else {
            if (this.isInitialized(valueList)) {
                throw new JBossXBRuntimeException("The value list has already been initialized!");
            }
            valueList.setRequiredValue(index, qName.hashCode(), value);
        }
    }

    public void addElementValue(QName qName, ElementBinding binding, ValueList valueList, Object value) {
        Integer index = (Integer)this.elemIndex.get(qName);
        if (index == null) {
            valueList.setNonRequiredValue(qName, binding, value);
        } else {
            if (this.isInitialized(valueList)) {
                throw new JBossXBRuntimeException("The value list has already been initialized!");
            }
            valueList.setRequiredValue(index, qName.hashCode(), value);
        }
    }

    public boolean isInitialized(ValueList valueList) {
        return this.requiredBindings.size() == 0 || this.initializedState == valueList.getState();
    }

    public Object getAttributeValue(QName qName, ValueList valueList) {
        Integer index = (Integer)this.attrIndex.get(qName);
        Object value = index == null ? valueList.getNonRequiredValue(qName) : valueList.getRequiredValue(index);
        return value;
    }

    public Object getElementValue(QName qName, ValueList valueList) {
        Integer index = (Integer)this.elemIndex.get(qName);
        Object value = index == null ? valueList.getNonRequiredValue(qName) : valueList.getRequiredValue(index);
        return value;
    }

    public List getRequiredBindings() {
        return this.requiredBindings;
    }

    private void addBinding(Object binding) {
        if (this.requiredBindings == Collections.EMPTY_LIST) {
            this.requiredBindings = new ArrayList();
        }
        this.requiredBindings.add(binding);
    }
}

