/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.transaction.xa.XAException;
import org.jboss.util.NestedException;
import org.jboss.util.NestedThrowable;

public class SpyXAException
extends XAException
implements NestedThrowable {
    static final long serialVersionUID = 7814140228056884098L;
    protected Throwable nested;

    public static XAException rethrowAsXAException(String message, Throwable t) throws XAException {
        throw SpyXAException.getAsXAException(message, t);
    }

    public static XAException getAsXAException(String message, Throwable t) {
        if (t instanceof XAException) {
            return (XAException)t;
        }
        SpyXAException e = new SpyXAException(message, t);
        e.errorCode = -3;
        return e;
    }

    public SpyXAException() {
        this.nested = null;
    }

    public SpyXAException(String msg) {
        super(msg);
        this.nested = null;
    }

    public SpyXAException(int code) {
        super(code);
        this.nested = null;
    }

    public SpyXAException(Throwable t) {
        this.nested = t;
    }

    public SpyXAException(String msg, Throwable t) {
        super(msg);
        this.nested = t;
    }

    public SpyXAException(int code, Throwable t) {
        super(code);
        this.nested = t;
    }

    public Throwable getNested() {
        return this.nested;
    }

    public Throwable getCause() {
        return this.nested;
    }

    public void setLinkedException(Exception e) {
        this.nested = e;
    }

    public Exception getLinkedException() {
        if (this.nested == null) {
            return this;
        }
        if (this.nested instanceof Exception) {
            return (Exception)this.nested;
        }
        return new NestedException(this.nested);
    }

    public String getMessage() {
        return NestedThrowable.Util.getMessage(super.getMessage(), this.nested);
    }

    public void printStackTrace(PrintStream stream) {
        if (this.nested == null || NestedThrowable.PARENT_TRACE_ENABLED) {
            super.printStackTrace(stream);
        }
        NestedThrowable.Util.print(this.nested, stream);
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.nested == null || NestedThrowable.PARENT_TRACE_ENABLED) {
            super.printStackTrace(writer);
        }
        NestedThrowable.Util.print(this.nested, writer);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }
}

