/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.xa.Xid;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.jms.server.ConnectionFactoryManager;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.jms.server.ConnectorManager;
import org.jboss.jms.server.DestinationJNDIMapper;
import org.jboss.jms.server.DestinationManager;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.MessagingTimeoutFactory;
import org.jboss.jms.server.SecurityStore;
import org.jboss.jms.server.connectionfactory.ConnectionFactoryJNDIMapper;
import org.jboss.jms.server.connectionmanager.SimpleConnectionManager;
import org.jboss.jms.server.connectormanager.SimpleConnectorManager;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.jms.server.destination.ManagedQueue;
import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.server.messagecounter.MessageCounterManager;
import org.jboss.jms.server.plugin.contract.JMSUserManager;
import org.jboss.jms.server.remoting.JMSServerInvocationHandler;
import org.jboss.jms.server.security.SecurityMetadataStore;
import org.jboss.jms.wireformat.JMSWireFormat;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.ClusterNotifier;
import org.jboss.messaging.core.contract.MemoryManager;
import org.jboss.messaging.core.contract.MessageStore;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.core.impl.DefaultClusterNotifier;
import org.jboss.messaging.core.impl.FailoverWaiter;
import org.jboss.messaging.core.impl.IDManager;
import org.jboss.messaging.core.impl.JDBCPersistenceManager;
import org.jboss.messaging.core.impl.RotatingID;
import org.jboss.messaging.core.impl.clusterconnection.ClusterConnectionManager;
import org.jboss.messaging.core.impl.memory.SimpleMemoryManager;
import org.jboss.messaging.core.impl.message.SimpleMessageStore;
import org.jboss.messaging.core.impl.postoffice.MessagingPostOffice;
import org.jboss.messaging.core.impl.tx.TransactionRepository;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.messaging.util.JMXAccessor;
import org.jboss.messaging.util.Util;
import org.jboss.messaging.util.Version;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.system.ServiceCreator;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.JBossStringBuilder;
import org.w3c.dom.Element;

public class ServerPeer
extends ServiceMBeanSupport {
    private static final Logger log = Logger.getLogger(ServerPeer.class);
    public static final String REMOTING_JMS_SUBSYSTEM = "JMS";
    private int serverPeerID = -1;
    private byte[] clientAOPStack;
    private Version version;
    private String defaultQueueJNDIContext = "";
    private String defaultTopicJNDIContext = "";
    private boolean started = false;
    private boolean supportsFailover = true;
    private int defaultMaxDeliveryAttempts = 10;
    private long failoverStartTimeout = 60000L;
    private long failoverCompleteTimeout = 300000L;
    private Map sessions;
    private long defaultRedeliveryDelay;
    private long messageCounterSamplePeriod = 10000L;
    private boolean enableMessageCounters;
    private int defaultMessageCounterHistoryDayLimit;
    private String clusterPullConnectionFactoryName;
    private boolean useXAForMessagePull;
    private boolean defaultPreserveOrdering;
    private long recoverDeliveriesTimeout = 300000L;
    private String suckerPassword;
    private boolean strictTck;
    private boolean strictTckProperty;
    private DestinationJNDIMapper destinationJNDIMapper;
    private SecurityMetadataStore securityStore = new SecurityMetadataStore();
    private ConnectionFactoryJNDIMapper connFactoryJNDIMapper;
    private TransactionRepository txRepository;
    private SimpleConnectionManager connectionManager;
    private ConnectorManager connectorManager;
    private IDManager messageIDManager;
    private IDManager channelIDManager;
    private MemoryManager memoryManager;
    private MessageStore messageStore;
    private MessageCounterManager messageCounterManager;
    private ClusterConnectionManager clusterConnectionManager;
    private ClusterNotifier clusterNotifier;
    private FailoverWaiter failoverWaiter;
    private RotatingID messageIDMgr;
    protected ObjectName persistenceManagerObjectName;
    protected PersistenceManager persistenceManager;
    protected ObjectName postOfficeObjectName;
    protected PostOffice postOffice;
    protected ObjectName jmsUserManagerObjectName;
    protected JMSUserManager jmsUserManager;
    protected ObjectName defaultDLQObjectName;
    protected Queue defaultDLQ;
    protected ObjectName defaultExpiryQueueObjectName;
    protected Queue defaultExpiryQueue;

    public ServerPeer() throws Exception {
        this.version = Version.instance();
        this.sessions = new ConcurrentReaderHashMap();
    }

    public synchronized void startService() throws Exception {
        try {
            log.debug((Object)"starting ServerPeer");
            if (this.started) {
                return;
            }
            if (this.serverPeerID < 0) {
                throw new IllegalStateException("ServerPeerID not set");
            }
            log.debug((Object)((Object)((Object)this) + " starting"));
            this.loadClientAOPConfig();
            this.loadServerAOPConfig();
            MBeanServer mbeanServer = this.getServer();
            this.persistenceManager = (PersistenceManager)JMXAccessor.getJMXAttributeOverSecurity(mbeanServer, this.persistenceManagerObjectName, "Instance");
            if (this.persistenceManager instanceof JDBCPersistenceManager) {
                ((JDBCPersistenceManager)this.persistenceManager).injectNodeID(this.serverPeerID);
            }
            this.jmsUserManager = (JMSUserManager)JMXAccessor.getJMXAttributeOverSecurity(mbeanServer, this.jmsUserManagerObjectName, "Instance");
            this.strictTckProperty = "true".equalsIgnoreCase(System.getProperty("jboss.messaging.stricttck"));
            this.messageIDManager = new IDManager("MESSAGE_ID", 4096, this.persistenceManager);
            this.channelIDManager = new IDManager("CHANNEL_ID", 10, this.persistenceManager);
            this.destinationJNDIMapper = new DestinationJNDIMapper(this);
            this.connFactoryJNDIMapper = new ConnectionFactoryJNDIMapper(this);
            this.connectionManager = new SimpleConnectionManager();
            this.connectorManager = new SimpleConnectorManager();
            this.memoryManager = new SimpleMemoryManager();
            this.messageStore = new SimpleMessageStore();
            this.messageIDMgr = new RotatingID(this.serverPeerID);
            this.txRepository = new TransactionRepository(this.persistenceManager, this.messageStore, this.serverPeerID);
            this.messageCounterManager = new MessageCounterManager(this.messageCounterSamplePeriod);
            this.clusterNotifier = new DefaultClusterNotifier();
            this.clusterNotifier.registerListener(this.connectionManager);
            this.clusterNotifier.registerListener(this.connFactoryJNDIMapper);
            this.failoverWaiter = new FailoverWaiter(this.serverPeerID, this.failoverStartTimeout, this.failoverCompleteTimeout, this.txRepository);
            this.clusterNotifier.registerListener(this.failoverWaiter);
            if (this.suckerPassword == null) {
                this.suckerPassword = "CHANGE ME!!";
            }
            if (this.clusterPullConnectionFactoryName != null) {
                this.clusterConnectionManager = new ClusterConnectionManager(this.serverPeerID, this.clusterPullConnectionFactoryName, this.defaultPreserveOrdering, "JBM.SUCKER", this.suckerPassword);
                this.clusterNotifier.registerListener(this.clusterConnectionManager);
            }
            this.messageIDManager.start();
            this.channelIDManager.start();
            this.destinationJNDIMapper.start();
            this.connFactoryJNDIMapper.start();
            this.connectionManager.start();
            this.connectorManager.start();
            this.memoryManager.start();
            this.messageStore.start();
            this.securityStore.setSuckerPassword(this.suckerPassword);
            this.securityStore.start();
            this.txRepository.start();
            if (this.clusterConnectionManager != null) {
                this.clusterConnectionManager.start();
            }
            this.txRepository.loadPreparedTransactions();
            JMSWireFormat wf = new JMSWireFormat();
            MarshalFactory.addMarshaller((String)"jms", (Marshaller)wf, (UnMarshaller)wf);
            JMSServerInvocationHandler.setClosed(false);
            if (this.enableMessageCounters) {
                this.startMessageCounters();
            }
            this.started = true;
            log.info((Object)("JBoss Messaging " + this.getVersion().getProviderVersion() + " server [" + this.getServerPeerID() + "] started"));
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " startService");
        }
    }

    public synchronized void stopService() throws Exception {
        try {
            if (!this.started) {
                return;
            }
            this.started = false;
            JMSServerInvocationHandler.setClosed(true);
            this.messageIDManager.stop();
            this.messageIDManager = null;
            this.channelIDManager.stop();
            this.channelIDManager = null;
            this.destinationJNDIMapper.stop();
            this.destinationJNDIMapper = null;
            this.connFactoryJNDIMapper.stop();
            this.connFactoryJNDIMapper = null;
            this.connectionManager.stop();
            this.connectionManager = null;
            this.connectorManager.start();
            this.connectorManager = null;
            this.memoryManager.stop();
            this.memoryManager = null;
            this.messageStore.stop();
            this.messageStore = null;
            this.securityStore.stop();
            this.txRepository.stop();
            this.txRepository = null;
            this.messageCounterManager.stop();
            this.messageCounterManager = null;
            if (this.clusterConnectionManager != null) {
                this.clusterConnectionManager.stop();
            }
            this.clusterConnectionManager = null;
            this.postOffice = null;
            this.unloadServerAOPConfig();
            MessagingTimeoutFactory.instance.reset();
            log.info((Object)("JMS " + (Object)((Object)this) + " stopped"));
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " stopService");
        }
    }

    public synchronized ObjectName getPersistenceManager() {
        return this.persistenceManagerObjectName;
    }

    public synchronized void setPersistenceManager(ObjectName on) {
        if (this.started) {
            log.warn((Object)"Cannot set persistence manager on server peer when server peer is started");
            return;
        }
        this.persistenceManagerObjectName = on;
    }

    public synchronized ObjectName getPostOffice() {
        return this.postOfficeObjectName;
    }

    public synchronized void setPostOffice(ObjectName on) {
        if (this.started) {
            log.warn((Object)"Cannot set post office on server peer when server peer is started");
            return;
        }
        this.postOfficeObjectName = on;
    }

    public synchronized ObjectName getJmsUserManager() {
        return this.jmsUserManagerObjectName;
    }

    public synchronized void setJMSUserManager(ObjectName on) {
        if (this.started) {
            log.warn((Object)"Cannot set jms user manager on server peer when server peer is started");
            return;
        }
        this.jmsUserManagerObjectName = on;
    }

    public synchronized ObjectName getDefaultDLQ() {
        return this.defaultDLQObjectName;
    }

    public synchronized void setDefaultDLQ(ObjectName on) {
        this.defaultDLQObjectName = on;
    }

    public synchronized ObjectName getDefaultExpiryQueue() {
        return this.defaultExpiryQueueObjectName;
    }

    public synchronized void setDefaultExpiryQueue(ObjectName on) {
        this.defaultExpiryQueueObjectName = on;
    }

    public Object getInstance() {
        return this;
    }

    public String getJMSVersion() {
        return this.version.getJMSVersion();
    }

    public int getJMSMajorVersion() {
        return this.version.getJMSMajorVersion();
    }

    public int getJMSMinorVersion() {
        return this.version.getJMSMinorVersion();
    }

    public String getJMSProviderName() {
        return this.version.getJMSProviderName();
    }

    public String getProviderVersion() {
        return this.version.getProviderVersion();
    }

    public int getProviderMajorVersion() {
        return this.version.getProviderMajorVersion();
    }

    public int getProviderMinorVersion() {
        return this.version.getProviderMinorVersion();
    }

    public synchronized void setSecurityDomain(String securityDomain) throws Exception {
        try {
            this.securityStore.setSecurityDomain(securityDomain);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " setSecurityDomain");
        }
    }

    public synchronized String getSecurityDomain() {
        return this.securityStore.getSecurityDomain();
    }

    public synchronized void setDefaultSecurityConfig(Element conf) throws Exception {
        this.securityStore.setDefaultSecurityConfig(conf);
    }

    public synchronized Element getDefaultSecurityConfig() {
        return this.securityStore.getDefaultSecurityConfig();
    }

    public synchronized long getFailoverStartTimeout() {
        return this.failoverStartTimeout;
    }

    public synchronized void setFailoverStartTimeout(long timeout) {
        this.failoverStartTimeout = timeout;
    }

    public synchronized long getFailoverCompleteTimeout() {
        return this.failoverCompleteTimeout;
    }

    public synchronized void setFailoverCompleteTimeout(long timeout) {
        this.failoverCompleteTimeout = timeout;
    }

    public synchronized int getDefaultMaxDeliveryAttempts() {
        return this.defaultMaxDeliveryAttempts;
    }

    public synchronized void setDefaultMaxDeliveryAttempts(int attempts) {
        this.defaultMaxDeliveryAttempts = attempts;
    }

    public synchronized long getMessageCounterSamplePeriod() {
        return this.messageCounterSamplePeriod;
    }

    public synchronized void setMessageCounterSamplePeriod(long newPeriod) {
        if (newPeriod < 1000L) {
            throw new IllegalArgumentException("Cannot set MessageCounterSamplePeriod < 1000 ms");
        }
        if (this.messageCounterManager != null && newPeriod != this.messageCounterSamplePeriod) {
            this.messageCounterManager.reschedule(newPeriod);
        }
        this.messageCounterSamplePeriod = newPeriod;
    }

    public synchronized long getDefaultRedeliveryDelay() {
        return this.defaultRedeliveryDelay;
    }

    public synchronized void setDefaultRedeliveryDelay(long delay) {
        this.defaultRedeliveryDelay = delay;
    }

    public synchronized int getDefaultMessageCounterHistoryDayLimit() {
        return this.defaultMessageCounterHistoryDayLimit;
    }

    public void setDefaultMessageCounterHistoryDayLimit(int limit) {
        if (limit < -1) {
            limit = -1;
        }
        this.defaultMessageCounterHistoryDayLimit = limit;
    }

    public String getClusterPullConnectionFactoryName() {
        return this.clusterPullConnectionFactoryName;
    }

    public void setClusterPullConnectionFactoryName(String name) {
        if (this.started) {
            throw new IllegalStateException("Cannot set ClusterPullConnectionFactoryName while the service is running");
        }
        this.clusterPullConnectionFactoryName = name;
    }

    public boolean isUseXAForMessagePull() {
        return this.useXAForMessagePull;
    }

    public void setUseXAForMessagePull(boolean useXA) throws Exception {
        if (this.started) {
            throw new IllegalStateException("Cannot set UseXAForMessagePull while the service is running");
        }
        this.useXAForMessagePull = useXA;
    }

    public boolean isDefaultPreserveOrdering() {
        return this.defaultPreserveOrdering;
    }

    public void setDefaultPreserveOrdering(boolean preserve) throws Exception {
        if (this.started) {
            throw new IllegalStateException("Cannot set DefaultPreserveOrdering while the service is running");
        }
        this.defaultPreserveOrdering = preserve;
    }

    public long getRecoverDeliveriesTimeout() {
        return this.recoverDeliveriesTimeout;
    }

    public void setRecoverDeliveriesTimeout(long timeout) {
        this.recoverDeliveriesTimeout = timeout;
    }

    public synchronized void setServerPeerID(int serverPeerID) {
        if (this.started) {
            throw new IllegalStateException("Cannot set ServerPeerID while the service is running");
        }
        if (serverPeerID < 0) {
            throw new IllegalArgumentException("Attempt to set negative ServerPeerID: " + serverPeerID);
        }
        this.serverPeerID = serverPeerID;
    }

    public int getServerPeerID() {
        return this.serverPeerID;
    }

    public String getDefaultQueueJNDIContext() {
        return this.defaultQueueJNDIContext;
    }

    public synchronized void setDefaultQueueJNDIContext(String defaultQueueJNDIContext) {
        if (this.started) {
            throw new IllegalStateException("Cannot set DefaultQueueJNDIContext while the service is running");
        }
        this.defaultQueueJNDIContext = defaultQueueJNDIContext;
    }

    public String getDefaultTopicJNDIContext() {
        return this.defaultTopicJNDIContext;
    }

    public synchronized void setDefaultTopicJNDIContext(String defaultTopicJNDIContext) {
        if (this.started) {
            throw new IllegalStateException("Cannot set DefaultTopicJNDIContext while the service is running");
        }
        this.defaultTopicJNDIContext = defaultTopicJNDIContext;
    }

    public synchronized void setSuckerPassword(String password) {
        if (this.started) {
            throw new IllegalStateException("Cannot set SuckerPassword while the service is running");
        }
        if (password == null) {
            throw new IllegalArgumentException("SuckerPassword cannot be null");
        }
        this.suckerPassword = password;
    }

    public void setStrictTck(boolean strictTck) {
        this.strictTck = strictTck || this.strictTckProperty;
    }

    public boolean isStrictTck() {
        return this.strictTck || this.strictTckProperty;
    }

    public RotatingID getMessageIDMgr() {
        return this.messageIDMgr;
    }

    public synchronized void setEnableMessageCounters(boolean enable) {
        if (this.started) {
            if (this.enableMessageCounters && !enable) {
                this.stopMessageCounters();
            } else if (!this.enableMessageCounters && enable) {
                this.startMessageCounters();
            }
        }
        this.enableMessageCounters = enable;
    }

    public boolean isEnableMessageCounters() {
        return this.enableMessageCounters;
    }

    public void enableMessageCounters() {
        this.setEnableMessageCounters(true);
    }

    public void disableMessageCounters() {
        this.setEnableMessageCounters(false);
    }

    public String deployQueue(String name, String jndiName) throws Exception {
        try {
            return this.deployDestinationDefault(true, name, jndiName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " createQueue");
        }
    }

    public String deployQueue(String name, String jndiName, int fullSize, int pageSize, int downCacheSize) throws Exception {
        try {
            return this.deployDestination(true, name, jndiName, fullSize, pageSize, downCacheSize);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " createQueue(2)");
        }
    }

    public boolean destroyQueue(String name) throws Exception {
        try {
            return this.destroyDestination(true, name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " destroyQueue");
        }
    }

    public boolean undeployQueue(String name) throws Exception {
        try {
            return this.undeployDestination(true, name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " destroyQueue");
        }
    }

    public String deployTopic(String name, String jndiName) throws Exception {
        try {
            return this.deployDestinationDefault(false, name, jndiName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " createTopic");
        }
    }

    public String deployTopic(String name, String jndiName, int fullSize, int pageSize, int downCacheSize) throws Exception {
        try {
            return this.deployDestination(false, name, jndiName, fullSize, pageSize, downCacheSize);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " createTopic(2)");
        }
    }

    public boolean destroyTopic(String name) throws Exception {
        try {
            return this.destroyDestination(false, name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " destroyTopic");
        }
    }

    public boolean undeployTopic(String name) throws Exception {
        try {
            return this.undeployDestination(false, name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " destroyTopic");
        }
    }

    public Set getDestinations() throws Exception {
        try {
            return this.destinationJNDIMapper.getDestinations();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " getDestinations");
        }
    }

    public List getMessageCounters() throws Exception {
        Set counters = this.messageCounterManager.getMessageCounters();
        return new ArrayList(counters);
    }

    public List getMessageStatistics() throws Exception {
        return MessageCounter.getMessageStatistics(this.getMessageCounters());
    }

    public String listMessageCountersAsHTML() throws Exception {
        List counters = this.getMessageCounters();
        Collections.sort(counters, new Comparator(){

            public int compare(Object o1, Object o2) {
                MessageCounter m1 = (MessageCounter)o1;
                MessageCounter m2 = (MessageCounter)o2;
                return m1.getDestinationName().compareTo(m2.getDestinationName());
            }
        });
        String ret = "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th></tr>";
        String strNameLast = null;
        String strTypeLast = null;
        String strDestLast = null;
        String destData = "";
        int destCount = 0;
        int countTotal = 0;
        int countDeltaTotal = 0;
        int depthTotal = 0;
        int depthDeltaTotal = 0;
        int i = 0;
        for (MessageCounter counter : counters) {
            StringTokenizer tokens = new StringTokenizer(counter.getCounterAsString(), ",");
            String strType = tokens.nextToken();
            String strName = tokens.nextToken();
            String strSub = tokens.nextToken();
            String strDurable = tokens.nextToken();
            String strDest = strType + "-" + strName;
            String strCount = tokens.nextToken();
            String strCountDelta = tokens.nextToken();
            String strDepth = tokens.nextToken();
            String strDepthDelta = tokens.nextToken();
            String strDate = tokens.nextToken();
            countTotal += Integer.parseInt(strCount);
            depthTotal += Integer.parseInt(strDepth);
            countDeltaTotal += Integer.parseInt(strCountDelta);
            depthDeltaTotal += Integer.parseInt(strDepthDelta);
            if (strCountDelta.equalsIgnoreCase("0")) {
                strCountDelta = "-";
            }
            if (strDepthDelta.equalsIgnoreCase("0")) {
                strDepthDelta = "-";
            }
            if (strDestLast != null && strDestLast.equals(strDest)) {
                destData = destData + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
                ++destCount;
            } else {
                if (strDestLast != null) {
                    ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\"><td rowspan=\"" + destCount + "\">" + strTypeLast + "</td><td rowspan=\"" + destCount + "\">" + strNameLast + "</td>" + destData;
                    destData = "";
                }
                destCount = 1;
            }
            destData = destData + "<td>" + strSub + "</td>" + "<td>" + strDurable + "</td>" + "<td>" + strCount + "</td>" + "<td>" + strCountDelta + "</td>" + "<td>" + strDepth + "</td>" + "<td>" + strDepthDelta + "</td>" + "<td>" + strDate + "</td>";
            strTypeLast = strType;
            strNameLast = strName;
            strDestLast = strDest;
        }
        if (strDestLast != null) {
            ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\"><td rowspan=\"" + destCount + "\">" + strTypeLast + "</td><td rowspan=\"" + destCount + "\">" + strNameLast + "</td>" + destData;
        }
        ret = ret + "<tr><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td>" + countTotal + "</td><td>" + (countDeltaTotal == 0 ? "-" : Integer.toString(countDeltaTotal)) + "</td><td>" + depthTotal + "</td><td>" + (depthDeltaTotal == 0 ? "-" : Integer.toString(depthDeltaTotal)) + "</td><td>Total</td></tr></table>";
        return ret;
    }

    public void resetAllMessageCounters() {
        this.messageCounterManager.resetAllCounters();
    }

    public void resetAllMessageCounterHistories() {
        this.messageCounterManager.resetAllCounterHistories();
    }

    public List retrievePreparedTransactions() {
        return this.txRepository.getPreparedTransactions();
    }

    public String showPreparedTransactionsAsHTML() {
        List txs = this.txRepository.getPreparedTransactions();
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\">");
        buffer.append("<tr><th>Xid</th></tr>");
        for (Xid xid : txs) {
            if (xid == null) continue;
            buffer.append("<tr><td>");
            buffer.append((Object)xid);
            buffer.append("</td></tr>");
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    public String showActiveClientsAsHTML() throws Exception {
        CharArrayWriter charArray = new CharArrayWriter();
        PrintWriter out = new PrintWriter(charArray);
        List endpoints = this.connectionManager.getActiveConnections();
        out.println("<table><tr><td>ID</td><td>Host</td><td>User</td><td>#Sessions</td></tr>");
        for (ServerConnectionEndpoint endpoint : endpoints) {
            out.println("<tr>");
            out.println("<td>" + endpoint.toString() + "</td>");
            out.println("<td>" + endpoint.getCallbackHandler().getCallbackClient().getInvoker().getLocator().getHost() + "</td>");
            out.println("<td>" + endpoint.getUsername() + "</td>");
            out.println("<td>" + endpoint.getSessions().size() + "</td>");
            out.println("</tr>");
        }
        out.println("</table>");
        return charArray.toString();
    }

    public void resetAllSuckers() {
        if (this.clusterConnectionManager != null) {
            this.clusterConnectionManager.resetAllSuckers();
        }
    }

    public byte[] getClientAOPStack() {
        return this.clientAOPStack;
    }

    public MessageCounterManager getMessageCounterManager() {
        return this.messageCounterManager;
    }

    public IDManager getMessageIDManager() {
        return this.messageIDManager;
    }

    public IDManager getChannelIDManager() {
        return this.channelIDManager;
    }

    public ServerSessionEndpoint getSession(String sessionID) {
        return (ServerSessionEndpoint)this.sessions.get(sessionID);
    }

    public Collection getSessions() {
        return this.sessions.values();
    }

    public void addSession(String id, ServerSessionEndpoint session) {
        this.sessions.put(id, session);
    }

    public void removeSession(String id) {
        if (this.sessions.remove(id) == null) {
            throw new IllegalStateException("Cannot find session with id " + id + " to remove");
        }
    }

    public synchronized Queue getDefaultDLQInstance() throws Exception {
        Queue dlq = null;
        if (this.defaultDLQObjectName != null) {
            ManagedQueue dest = null;
            dest = (ManagedQueue)JMXAccessor.getJMXAttributeOverSecurity(this.getServer(), this.defaultDLQObjectName, "Instance");
            if (dest != null && dest.getName() != null) {
                Binding binding = this.postOffice.getBindingForQueueName(dest.getName());
                if (binding == null) {
                    throw new IllegalStateException("Cannot find binding for queue " + dest.getName());
                }
                Queue queue = binding.queue;
                if (queue.isActive()) {
                    dlq = queue;
                }
            }
        }
        return dlq;
    }

    public synchronized Queue getDefaultExpiryQueueInstance() throws Exception {
        Queue expiryQueue = null;
        if (this.defaultExpiryQueueObjectName != null) {
            ManagedDestination dest = null;
            try {
                dest = (ManagedQueue)JMXAccessor.getJMXAttributeOverSecurity(this.getServer(), this.defaultExpiryQueueObjectName, "Instance");
            }
            catch (InstanceNotFoundException e) {
                // empty catch block
            }
            if (dest != null && dest.getName() != null) {
                Binding binding = this.postOffice.getBindingForQueueName(dest.getName());
                if (binding == null) {
                    throw new IllegalStateException("Cannot find binding for queue " + dest.getName());
                }
                Queue queue = binding.queue;
                if (queue.isActive()) {
                    expiryQueue = queue;
                }
            }
        }
        return expiryQueue;
    }

    public TransactionRepository getTxRepository() {
        return this.txRepository;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public Version getVersion() {
        return this.version;
    }

    public SecurityStore getSecurityManager() {
        return this.securityStore;
    }

    public DestinationManager getDestinationManager() {
        return this.destinationJNDIMapper;
    }

    public ConnectionFactoryManager getConnectionFactoryManager() {
        return this.connFactoryJNDIMapper;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ConnectorManager getConnectorManager() {
        return this.connectorManager;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public PersistenceManager getPersistenceManagerInstance() {
        return this.persistenceManager;
    }

    public JMSUserManager getJmsUserManagerInstance() {
        return this.jmsUserManager;
    }

    public PostOffice getPostOfficeInstance() throws Exception {
        if (this.postOffice == null) {
            this.postOffice = (PostOffice)JMXAccessor.getJMXAttributeOverSecurity(this.getServer(), this.postOfficeObjectName, "Instance");
            if (this.postOffice.isClustered()) {
                Replicator rep = (Replicator)((Object)this.postOffice);
                this.connFactoryJNDIMapper.injectReplicator(rep);
                if (this.clusterConnectionManager != null) {
                    this.clusterConnectionManager.injectPostOffice(this.postOffice);
                    this.clusterConnectionManager.injectReplicator((Replicator)((Object)this.postOffice));
                }
                this.connectionManager.injectReplicator((Replicator)((Object)this.postOffice));
                ((MessagingPostOffice)this.postOffice).injectServerPeer(this);
            }
            this.txRepository.injectPostOffice(this.postOffice);
        }
        return this.postOffice;
    }

    public ClusterNotifier getClusterNotifier() {
        return this.clusterNotifier;
    }

    public FailoverWaiter getFailoverWaiter() {
        return this.failoverWaiter;
    }

    public boolean isSupportsFailover() {
        return this.supportsFailover;
    }

    public void setSupportsFailover(boolean supportsFailover) throws Exception {
        if (this.started) {
            throw new IllegalAccessException("supportsFailover can only be changed when server peer is stopped");
        }
        this.supportsFailover = supportsFailover;
    }

    public String toString() {
        return "ServerPeer[" + this.getServerPeerID() + "]";
    }

    private void startMessageCounters() {
        this.messageCounterManager.start();
    }

    private void stopMessageCounters() {
        this.messageCounterManager.stop();
        this.messageCounterManager.resetAllCounters();
        this.messageCounterManager.resetAllCounterHistories();
    }

    private void loadServerAOPConfig() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("aop-messaging-server.xml");
        AspectXmlLoader.deployXML((URL)url, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    private void unloadServerAOPConfig() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("aop-messaging-server.xml");
        AspectXmlLoader.undeployXML((URL)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClientAOPConfig() throws Exception {
        ByteArrayOutputStream os;
        block6: {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("aop-messaging-client.xml");
            InputStream is = null;
            os = new ByteArrayOutputStream();
            try {
                int b;
                is = url.openStream();
                while ((b = is.read()) != -1) {
                    os.write(b);
                }
                os.flush();
                this.clientAOPStack = os.toByteArray();
                Object var6_5 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
    }

    private String deployDestinationDefault(boolean isQueue, String name, String jndiName) throws Exception {
        String destType = isQueue ? "Queue" : "Topic";
        String className = "org.jboss.jms.server.destination." + destType + "Service";
        String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
        ObjectName on = new ObjectName(ons);
        String destinationMBeanConfig = "<mbean code=\"" + className + "\" " + "       name=\"" + ons + "\" " + "       xmbean-dd=\"xmdesc/" + destType + "-xmbean.xml\">\n" + "    <constructor>" + "        <arg type=\"boolean\" value=\"true\"/>" + "    </constructor>" + "</mbean>";
        return this.deployDestinationInternal(destinationMBeanConfig, on, jndiName, false, -1, -1, -1);
    }

    private String deployDestination(boolean isQueue, String name, String jndiName, int fullSize, int pageSize, int downCacheSize) throws Exception {
        String destType = isQueue ? "Queue" : "Topic";
        String className = "org.jboss.jms.server.destination." + destType + "Service";
        String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
        ObjectName on = new ObjectName(ons);
        String destinationMBeanConfig = "<mbean code=\"" + className + "\" " + "       name=\"" + ons + "\" " + "       xmbean-dd=\"xmdesc/" + destType + "-xmbean.xml\">\n" + "    <constructor>" + "        <arg type=\"boolean\" value=\"true\"/>" + "    </constructor>" + "    <attribute name=\"FullSize\">" + fullSize + "</attribute>" + "    <attribute name=\"PageSize\">" + pageSize + "</attribute>" + "    <attribute name=\"DownCacheSize\">" + downCacheSize + "</attribute>" + "</mbean>";
        return this.deployDestinationInternal(destinationMBeanConfig, on, jndiName, true, fullSize, pageSize, downCacheSize);
    }

    private String deployDestinationInternal(String destinationMBeanConfig, ObjectName on, String jndiName, boolean params, int fullSize, int pageSize, int downCacheSize) throws Exception {
        log.trace((Object)("Deploying destination" + destinationMBeanConfig + " jndiName: " + jndiName + "fullSize: " + fullSize + " pageSize: " + pageSize + " downCacheSize: " + downCacheSize));
        MBeanServer mbeanServer = this.getServer();
        Element element = Util.stringToElement(destinationMBeanConfig);
        ServiceCreator sc = new ServiceCreator(mbeanServer);
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ObjectName loaderObjectName = null;
        if (cl instanceof UnifiedClassLoader3) {
            loaderObjectName = ((UnifiedClassLoader3)cl).getObjectName();
        }
        sc.install(on, loaderObjectName, element);
        mbeanServer.setAttribute(on, new Attribute("ServerPeer", this.getServiceName()));
        mbeanServer.setAttribute(on, new Attribute("JNDIName", jndiName));
        if (params) {
            mbeanServer.setAttribute(on, new Attribute("FullSize", new Integer(fullSize)));
            mbeanServer.setAttribute(on, new Attribute("PageSize", new Integer(pageSize)));
            mbeanServer.setAttribute(on, new Attribute("DownCacheSize", new Integer(downCacheSize)));
        }
        mbeanServer.invoke(on, "create", new Object[0], new String[0]);
        mbeanServer.invoke(on, "start", new Object[0], new String[0]);
        return (String)JMXAccessor.getJMXAttributeOverSecurity(mbeanServer, on, "JNDIName");
    }

    private boolean undeployDestination(boolean isQueue, String name) throws Exception {
        String destType = isQueue ? "Queue" : "Topic";
        String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
        ObjectName on = new ObjectName(ons);
        MBeanServer mbeanServer = this.getServer();
        if (!mbeanServer.isRegistered(on)) {
            return false;
        }
        Boolean b = (Boolean)JMXAccessor.getJMXAttributeOverSecurity(mbeanServer, on, "CreatedProgrammatically");
        if (!b.booleanValue()) {
            log.warn((Object)"Cannot undeploy a destination that has not been created programatically");
            return false;
        }
        mbeanServer.invoke(on, "stop", new Object[0], new String[0]);
        mbeanServer.invoke(on, "destroy", new Object[0], new String[0]);
        mbeanServer.unregisterMBean(on);
        return true;
    }

    private boolean destroyDestination(boolean isQueue, String name) throws Throwable {
        Queue queue;
        String destType = isQueue ? "Queue" : "Topic";
        String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
        ObjectName on = new ObjectName(ons);
        MBeanServer mbeanServer = this.getServer();
        if (!mbeanServer.isRegistered(on)) {
            return false;
        }
        JMSCondition condition = new JMSCondition(isQueue, name);
        Collection queues = this.postOffice.getQueuesForCondition(condition, true);
        Iterator iter = queues.iterator();
        while (iter.hasNext()) {
            queue = (Queue)iter.next();
            queue.removeAllReferences();
        }
        if (!this.undeployDestination(isQueue, name)) {
            return false;
        }
        while (iter.hasNext()) {
            queue = (Queue)iter.next();
            queue.removeAllReferences();
            boolean all = !isQueue && queue.isRecoverable();
            this.postOffice.removeBinding(queue.getName(), all);
        }
        return true;
    }
}

