/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.StringTokenizer;
import org.jboss.wsf.framework.deployment.ContextRootDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;

public class BackwardCompatibleContextRootDeploymentAspect
extends ContextRootDeploymentAspect {
    protected String getExplicitContextRoot(Deployment deployment) {
        String string = super.getExplicitContextRoot(deployment);
        if (string == null) {
            for (Endpoint endpoint : deployment.getService().getEndpoints()) {
                StringTokenizer stringTokenizer;
                String string2 = this.getUrlPattern(deployment, endpoint);
                if (string2 == null || (stringTokenizer = new StringTokenizer(string2, "/")).countTokens() <= 1) continue;
                String string3 = stringTokenizer.nextToken();
                if (string != null && !string.equals(string3)) {
                    throw new IllegalStateException("All endpoints must share the same <context-root>: " + string + "!=" + string3);
                }
                string = string3;
            }
        }
        return string;
    }

    private String getUrlPattern(Deployment deployment, Endpoint endpoint) {
        String string = null;
        EJBArchiveMetaData eJBArchiveMetaData = (EJBArchiveMetaData)deployment.getAttachment(EJBArchiveMetaData.class);
        if (eJBArchiveMetaData != null && eJBArchiveMetaData.getBeanByEjbName(endpoint.getShortName()) != null) {
            EJBMetaData eJBMetaData = eJBArchiveMetaData.getBeanByEjbName(endpoint.getShortName());
            string = eJBMetaData.getPortComponentURI();
        }
        return string;
    }
}

