/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.PutMethodMetaData;
import org.jboss.xb.binding.metadata.SchemaMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.metadata.XsdAnnotation;
import org.jboss.xb.binding.metadata.XsdAppInfo;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtAttributeHandler;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;

public class XsdBinder {
    public static boolean MODELGROUPS = true;
    private static final Logger log = Logger.getLogger(XsdBinder.class);
    private static final ThreadLocal xsdBinding = new ThreadLocal();

    private static XsdBinding getXsdBinding() {
        XsdBinding local = (XsdBinding)xsdBinding.get();
        if (local == null) {
            local = new XsdBinding();
            xsdBinding.set(local);
        }
        return local;
    }

    private XsdBinder() {
    }

    public static SchemaBinding bind(String xsdUrl) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(xsdUrl);
        return XsdBinder.bind(xsdUrl, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(String xsdUrl, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdUrl, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding) {
        return XsdBinder.bind(xsdStream, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(baseURI);
        return XsdBinder.bind(xsdStream, encoding, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdStream, encoding, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding) {
        return XsdBinder.bind(xsdReader, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding, String baseURI) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(baseURI);
        return XsdBinder.bind(xsdReader, encoding, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdReader, encoding, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(String xsd, String encoding) {
        return XsdBinder.bind(xsd, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(String xsd, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsd, encoding);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver) {
        SchemaBinding schema = XsdBinder.getXsdBinding().schemaBinding;
        schema.setSchemaResolver(resolver);
        XSObjectList annotations = model.getAnnotations();
        for (int i = 0; i < annotations.getLength(); ++i) {
            SchemaMetaData schemaBindings;
            XSAnnotation annotation = (XSAnnotation)annotations.item(i);
            XsdAnnotation an = XsdAnnotation.unmarshal(annotation.getAnnotationString());
            XsdAppInfo appinfo = an.getAppInfo();
            if (appinfo == null || (schemaBindings = appinfo.getSchemaMetaData()) == null) continue;
            schema.setIgnoreUnresolvedFieldOrClass(schemaBindings.isIgnoreUnresolvedFieldOrClass());
            schema.setReplacePropertyRefs(schemaBindings.isReplacePropertyRefs());
            PackageMetaData packageMetaData = schemaBindings.getPackage();
            if (packageMetaData == null) continue;
            if (log.isTraceEnabled()) {
                log.trace("schema default package: " + packageMetaData.getName());
            }
            schema.setPackageMetaData(packageMetaData);
        }
        SharedElements sharedElements = new SharedElements();
        XSNamedMap groups = model.getComponents((short)6);
        for (int i = 0; i < groups.getLength(); ++i) {
            XSModelGroupDefinition groupDef = (XSModelGroupDefinition)groups.item(i);
            XSModelGroup group = groupDef.getModelGroup();
            XSObjectList particles = group.getParticles();
            block6: for (int j = 0; j < particles.getLength(); ++j) {
                XSParticle particle = (XSParticle)particles.item(j);
                XSTerm term = particle.getTerm();
                switch (term.getType()) {
                    case 2: {
                        XSElementDeclaration element = (XSElementDeclaration)term;
                        sharedElements.add(element);
                        continue block6;
                    }
                    case 9: {
                        continue block6;
                    }
                    default: {
                        throw new JBossXBRuntimeException("For now we don't support anything but elements in global model groups");
                    }
                }
            }
        }
        XSNamedMap types = model.getComponents((short)3);
        for (int i = 0; i < types.getLength(); ++i) {
            XSTypeDefinition type = (XSTypeDefinition)types.item(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) continue;
            XsdBinder.bindType(schema, type, sharedElements);
        }
        XSNamedMap elements = model.getComponents((short)2);
        for (int i = 0; i < elements.getLength(); ++i) {
            XSElementDeclaration element = (XSElementDeclaration)elements.item(i);
            XsdBinder.bindElement(schema, element, sharedElements, 1, 0, false);
        }
        xsdBinding.set(null);
        return schema;
    }

    public static void bindType(SchemaBinding schema, XSTypeDefinition type) {
        TypeBinding typeBinding = XsdBinder.bindType(schema, type, new SharedElements());
        schema.addType(typeBinding);
    }

    public static void bindElement(SchemaBinding schema, XSElementDeclaration element, int minOccurs, int maxOccurs, boolean maxOccursUnbounded) {
        ElementBinding binding = XsdBinder.bindElement(schema, element, new SharedElements(), minOccurs, maxOccurs, maxOccursUnbounded);
        schema.addElement(binding);
    }

    private static TypeBinding bindType(SchemaBinding doc, XSTypeDefinition type, SharedElements sharedElements) {
        TypeBinding binding;
        switch (type.getTypeCategory()) {
            case 16: {
                binding = XsdBinder.bindSimpleType(doc, (XSSimpleTypeDefinition)type);
                break;
            }
            case 15: {
                binding = XsdBinder.bindComplexType(doc, (XSComplexTypeDefinition)type, sharedElements);
                break;
            }
            default: {
                throw new JBossXBRuntimeException("Unexpected type category: " + type.getTypeCategory());
            }
        }
        return binding;
    }

    private static TypeBinding bindSimpleType(SchemaBinding doc, XSSimpleTypeDefinition type) {
        TypeBinding binding;
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : doc.getType(typeName);
        if (binding == null) {
            XSObjectList annotations;
            XSTypeDefinition baseTypeDef = type.getBaseType();
            TypeBinding baseType = baseTypeDef == null ? null : XsdBinder.bindType(doc, baseTypeDef, null);
            TypeBinding typeBinding2 = binding = baseType == null ? new TypeBinding(typeName) : new TypeBinding(typeName, baseType);
            if (typeName != null) {
                doc.addType(binding);
            }
            if (log.isTraceEnabled()) {
                String msg;
                String string = msg = typeName == null ? "simple anonymous type" : "simple type " + typeName;
                if (baseType != null) {
                    msg = msg + " inherited binding metadata from " + baseType.getQName();
                }
                log.trace(msg);
            }
            if ((annotations = type.getAnnotations()) != null) {
                for (int i = 0; i < annotations.getLength(); ++i) {
                    ValueMetaData valueMetaData;
                    XSAnnotation an = (XSAnnotation)annotations.item(i);
                    XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                    XsdAppInfo appInfo = xsdAn.getAppInfo();
                    if (appInfo == null) continue;
                    ClassMetaData classMetaData = appInfo.getClassMetaData();
                    if (classMetaData != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("simple type " + type.getName() + ": impl=" + classMetaData.getImpl());
                        }
                        binding.setClassMetaData(classMetaData);
                    }
                    if ((valueMetaData = appInfo.getValueMetaData()) == null) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("simple type " + type.getName() + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod());
                    }
                    binding.setValueMetaData(valueMetaData);
                }
            }
            binding.setSchemaBinding(doc);
        }
        return binding;
    }

    private static TypeBinding bindComplexType(SchemaBinding doc, XSComplexTypeDefinition type, SharedElements sharedElements) {
        XSParticle particle;
        TypeBinding binding;
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : doc.getType(typeName);
        if (binding != null) {
            return binding;
        }
        TypeBinding baseType = null;
        binding = baseType == null ? new TypeBinding(typeName) : new TypeBinding(typeName, baseType);
        binding.setStartElementCreatesObject(true);
        if (typeName != null) {
            doc.addType(binding);
        }
        if (log.isTraceEnabled()) {
            String msg;
            String string = msg = typeName == null ? "complex anonymous type" : "complex type " + typeName;
            if (baseType != null) {
                msg = msg + " inherited binding metadata from " + baseType.getQName();
            }
            log.trace(msg);
        }
        binding.setSchemaBinding(doc);
        XSObjectList attrs = type.getAttributeUses();
        for (int i = 0; i < attrs.getLength(); ++i) {
            XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
            XsdBinder.bindAttributes(doc, binding, attr);
        }
        XSObjectList annotations = type.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.getLength(); ++i) {
                AddMethodMetaData addMethodMetaData;
                PropertyMetaData propertyMetaData;
                boolean skip;
                MapEntryMetaData mapEntryMetaData;
                CharactersMetaData charactersMetaData;
                XSAnnotation an = (XSAnnotation)annotations.item(i);
                XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                XsdAppInfo appInfo = xsdAn.getAppInfo();
                if (appInfo == null) continue;
                ClassMetaData classMetaData = appInfo.getClassMetaData();
                if (classMetaData != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("complex type " + type.getName() + ": impl=" + classMetaData.getImpl());
                    }
                    binding.setClassMetaData(classMetaData);
                }
                if ((charactersMetaData = appInfo.getCharactersMetaData()) != null) {
                    if (log.isTraceEnabled()) {
                        boolean mapEntryValue;
                        boolean mapEntryKey;
                        ValueMetaData valueMetaData;
                        PropertyMetaData propertyMetaData2 = charactersMetaData.getProperty();
                        if (propertyMetaData2 != null) {
                            log.trace("complex type " + type.getName() + ": characters bound to " + propertyMetaData2.getName());
                        }
                        if ((valueMetaData = charactersMetaData.getValue()) != null) {
                            log.trace("complex type " + type.getName() + ": characters unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod());
                        }
                        if (mapEntryKey = appInfo.isMapEntryKey()) {
                            log.trace("complex type " + type.getName() + ": characters are bound as a key in a map entry");
                        }
                        if (mapEntryValue = appInfo.isMapEntryValue()) {
                            log.trace("complex type " + type.getName() + ": characters are bound as a value in a map entry");
                        }
                    }
                    binding.setCharactersMetaData(charactersMetaData);
                }
                if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("complex type " + type.getName() + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue());
                    }
                    if (classMetaData != null) {
                        throw new JBossXBRuntimeException("Illegal binding: both jbxb:class and jbxb:mapEntry are specified for complex type " + type.getName());
                    }
                    binding.setMapEntryMetaData(mapEntryMetaData);
                }
                if (skip = appInfo.isSkip()) {
                    if (log.isTraceEnabled()) {
                        log.trace("complex type " + type.getName() + ": elements of this type will be skipped; their attrs, character content " + "and elements will be set the parent.");
                    }
                    binding.setSkip(skip);
                }
                if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("complex type " + type.getName() + ": the content of elements of this type is bound to property " + propertyMetaData.getName());
                    }
                    binding.setPropertyMetaData(propertyMetaData);
                }
                if ((addMethodMetaData = appInfo.getAddMethodMetaData()) == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace("complex type " + type.getName() + ": elements of this type will be added to parent objects with addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType());
                }
                binding.setAddMethodMetaData(addMethodMetaData);
            }
        }
        if ((particle = type.getParticle()) != null) {
            XsdBinder.pushType(binding);
            XsdBinder.bindParticle(doc, particle, sharedElements);
            XsdBinder.popType();
        }
        return binding;
    }

    private static void bindAttributes(SchemaBinding doc, TypeBinding type, XSAttributeUse attrUse) {
        XsdAnnotation xsdAn;
        XsdAppInfo appInfo;
        XSAnnotation an;
        XSAttributeDeclaration attr = attrUse.getAttrDeclaration();
        XSSimpleTypeDefinition attrType = attr.getTypeDefinition();
        TypeBinding typeBinding = XsdBinder.bindSimpleType(doc, attrType);
        QName attrName = new QName(attr.getNamespace(), attr.getName());
        AttributeBinding binding = type.addAttribute(attrName, typeBinding, RtAttributeHandler.INSTANCE);
        if (attrUse.getConstraintType() == 1) {
            binding.setDefaultConstraint(attrUse.getConstraintValue());
        }
        if ((an = attr.getAnnotation()) != null && (appInfo = (xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString())).getAppInfo()) != null) {
            boolean mapEntryValue;
            boolean mapEntryKey;
            PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
            if (propertyMetaData != null) {
                binding.setPropertyMetaData(propertyMetaData);
            }
            if (mapEntryKey = appInfo.isMapEntryKey()) {
                binding.setMapEntryKey(mapEntryKey);
            }
            if (mapEntryValue = appInfo.isMapEntryValue()) {
                binding.setMapEntryValue(mapEntryValue);
            }
        }
        if (log.isTraceEnabled()) {
            String msg = "attribute " + new QName(attr.getNamespace(), attr.getName()) + ": ";
            msg = binding.getPropertyMetaData() != null ? msg + " property=" + binding.getPropertyMetaData().getName() + ", collectionType=" + binding.getPropertyMetaData().getCollectionType() : (binding.isMapEntryKey() ? msg + "bound as a key in a map entry" : (binding.isMapEntryValue() ? msg + "bound as a value in a map entry" : msg + " type=" + attrType.getName() + ", owner type=" + type.getQName()));
            if (binding.getDefaultConstraint() != null) {
                msg = msg + ", default=" + binding.getDefaultConstraint();
            }
            log.trace(msg);
        }
    }

    private static void bindParticle(SchemaBinding schema, XSParticle particle, SharedElements sharedElements) {
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                XSModelGroup modelGroup = (XSModelGroup)term;
                if (MODELGROUPS) {
                    Object o;
                    ModelGroupBinding binding;
                    switch (modelGroup.getCompositor()) {
                        case 3: {
                            binding = new AllBinding();
                            break;
                        }
                        case 2: {
                            binding = new ChoiceBinding();
                            break;
                        }
                        case 1: {
                            binding = new SequenceBinding();
                            break;
                        }
                        default: {
                            throw new JBossXBRuntimeException("Unexpected model group: " + modelGroup.getCompositor());
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("created model group " + binding);
                    }
                    if ((o = XsdBinder.peekTypeOrGroup()) instanceof ModelGroupBinding) {
                        ModelGroupBinding parentGroup = (ModelGroupBinding)o;
                        parentGroup.addModelGroup(binding);
                        if (log.isTraceEnabled()) {
                            log.trace("added " + binding + " to type group " + parentGroup);
                        }
                    } else if (o instanceof TypeBinding) {
                        TypeBinding typeBinding = (TypeBinding)o;
                        typeBinding.setModelGroup(binding);
                        if (log.isTraceEnabled()) {
                            log.trace("added " + binding + " to type " + typeBinding.getQName());
                        }
                    }
                    XsdBinder.pushModelGroup(binding);
                }
                XsdBinder.bindModelGroup(schema, modelGroup, sharedElements);
                if (!MODELGROUPS) break;
                XsdBinder.popModelGroup();
                break;
            }
            case 9: {
                XsdBinder.bindWildcard(schema, (XSWildcard)term);
                break;
            }
            case 2: {
                XsdBinder.bindElement(schema, (XSElementDeclaration)term, sharedElements, particle.getMinOccurs(), particle.getMaxOccurs(), particle.getMaxOccursUnbounded());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
    }

    private static void bindWildcard(SchemaBinding schema, XSWildcard wildcard) {
        XsdAnnotation xsdAn;
        XsdAppInfo appInfo;
        XSAnnotation annotation;
        WildcardBinding binding = new WildcardBinding();
        binding.setSchema(schema);
        Object o = XsdBinder.peekTypeOrGroup();
        TypeBinding type = null;
        ModelGroupBinding group = null;
        if (o instanceof ModelGroupBinding) {
            group = (ModelGroupBinding)o;
            group.setWildcard(binding);
            if (log.isTraceEnabled()) {
                log.trace("added wildcard to " + group);
            }
            type = XsdBinder.peekType();
        } else {
            type = (TypeBinding)o;
        }
        type.setWildcard(binding);
        if (log.isTraceEnabled()) {
            log.trace("added wildcard to type " + type.getQName().toString());
        }
        if ((annotation = wildcard.getAnnotation()) != null && (appInfo = (xsdAn = XsdAnnotation.unmarshal(annotation.getAnnotationString())).getAppInfo()) != null) {
            PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
            if (propertyMetaData != null && log.isTraceEnabled()) {
                log.trace("wildcard is bound to property: " + propertyMetaData.getName() + ", collectionType=" + propertyMetaData.getCollectionType());
            }
            type.setWildcardPropertyMetaData(propertyMetaData);
        }
    }

    private static ElementBinding bindElement(SchemaBinding schema, XSElementDeclaration element, SharedElements sharedElements, int minOccurs, int maxOccurs, boolean maxOccursUnbounded) {
        XsdAnnotation xsdAn;
        XsdAppInfo appInfo;
        XSAnnotation an;
        QName qName = new QName(element.getNamespace(), element.getName());
        Object o = XsdBinder.peekTypeOrGroup();
        TypeBinding parentType = null;
        ModelGroupBinding parentGroup = null;
        if (o instanceof TypeBinding) {
            parentType = (TypeBinding)o;
        } else {
            parentGroup = (ModelGroupBinding)o;
        }
        boolean global = element.getScope() == 1;
        ElementBinding binding = schema.getElement(qName);
        if (global && binding != null) {
            if (parentType != null) {
                parentType.addElement(binding);
            } else if (parentGroup != null) {
                parentGroup.addElement(binding);
            }
            if (maxOccursUnbounded) {
                binding.setMaxOccursUnbounded(maxOccursUnbounded);
            }
            return binding;
        }
        TypeBinding type = null;
        boolean shared = sharedElements.isShared(element);
        if (shared) {
            type = sharedElements.getTypeBinding(element);
        }
        if (type == null) {
            type = XsdBinder.bindType(schema, element.getTypeDefinition(), sharedElements);
            if (shared) {
                sharedElements.setTypeBinding(element, type);
            }
        }
        binding = new ElementBinding(schema, qName, type);
        binding.setNillable(element.getNillable());
        binding.setMinOccurs(minOccurs);
        binding.setMaxOccurs(maxOccurs);
        binding.setMaxOccursUnbounded(maxOccursUnbounded);
        if (global) {
            schema.addElement(binding);
        }
        if (parentType != null) {
            parentType.addElement(binding);
        } else if (parentGroup != null) {
            if (!MODELGROUPS) {
                throw new JBossXBRuntimeException("NO GROUPS!");
            }
            parentGroup.addElement(binding);
            if (log.isTraceEnabled()) {
                log.trace("Element " + binding.getQName() + " added to " + parentGroup);
            }
        }
        if (log.isTraceEnabled()) {
            if (parentType == null) {
                parentType = XsdBinder.peekType();
            }
            log.trace("element: name=" + qName + ", type=" + type.getQName() + ", multiOccurs=" + binding.isMultiOccurs() + ", nillable=" + binding.isNillable() + ", " + (global ? "global scope" : " owner type=" + parentType.getQName()));
        }
        if ((an = element.getAnnotation()) != null && (appInfo = (xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString())).getAppInfo()) != null) {
            boolean skip;
            boolean mapEntryValue;
            boolean mapEntryKey;
            ValueMetaData valueMetaData;
            AddMethodMetaData addMethodMetaData;
            PutMethodMetaData putMethodMetaData;
            MapEntryMetaData mapEntryMetaData;
            PropertyMetaData propertyMetaData;
            ClassMetaData classMetaData = appInfo.getClassMetaData();
            if (classMetaData != null) {
                log.trace("element: name=" + new QName(element.getNamespace(), element.getName()) + ", class=" + classMetaData.getImpl());
                binding.setClassMetaData(classMetaData);
            }
            if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                if (log.isTraceEnabled()) {
                    log.trace("element: name=" + new QName(element.getNamespace(), element.getName()) + ", property=" + propertyMetaData.getName() + ", collectionType=" + propertyMetaData.getCollectionType());
                }
                binding.setPropertyMetaData(propertyMetaData);
            }
            if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                if (propertyMetaData != null) {
                    throw new JBossXBRuntimeException("An element can be bound either as a property or as a map entry but not both: " + new QName(element.getNamespace(), element.getName()));
                }
                if (log.isTraceEnabled()) {
                    log.trace("element name=" + new QName(element.getNamespace(), element.getName()) + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue());
                }
                if (classMetaData != null) {
                    throw new JBossXBRuntimeException("Invalid binding: both jbxb:class and jbxb:mapEntry are specified for element " + new QName(element.getNamespace(), element.getName()));
                }
                binding.setMapEntryMetaData(mapEntryMetaData);
            }
            if ((putMethodMetaData = appInfo.getPutMethodMetaData()) != null) {
                if (log.isTraceEnabled()) {
                    log.trace("element: name=" + new QName(element.getNamespace(), element.getName()) + ", putMethod=" + putMethodMetaData.getName() + ", keyType=" + putMethodMetaData.getKeyType() + ", valueType=" + putMethodMetaData.getValueType());
                }
                binding.setPutMethodMetaData(putMethodMetaData);
            }
            if ((addMethodMetaData = appInfo.getAddMethodMetaData()) != null) {
                if (log.isTraceEnabled()) {
                    log.trace("element: name=" + new QName(element.getNamespace(), element.getName()) + ", addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ", isChildType=" + addMethodMetaData.isChildType());
                }
                binding.setAddMethodMetaData(addMethodMetaData);
            }
            if ((valueMetaData = appInfo.getValueMetaData()) != null) {
                if (log.isTraceEnabled()) {
                    log.trace("element " + new QName(element.getNamespace(), element.getName()) + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod());
                }
                binding.setValueMetaData(valueMetaData);
            }
            if (mapEntryKey = appInfo.isMapEntryKey()) {
                if (log.isTraceEnabled()) {
                    log.trace("element name=" + new QName(element.getNamespace(), element.getName()) + ": is bound to a key in a map entry");
                }
                binding.setMapEntryKey(mapEntryKey);
            }
            if (mapEntryValue = appInfo.isMapEntryValue()) {
                if (log.isTraceEnabled()) {
                    log.trace("element name=" + new QName(element.getNamespace(), element.getName()) + ": is bound to a value in a map entry");
                }
                binding.setMapEntryValue(mapEntryValue);
            }
            if (skip = appInfo.isSkip()) {
                if (log.isTraceEnabled()) {
                    log.trace("element name=" + new QName(element.getNamespace(), element.getName()) + ": will be skipped, it's attributes, character content and children will be set on the parent");
                }
                binding.setSkip(skip);
            }
        }
        return binding;
    }

    private static void bindModelGroup(SchemaBinding doc, XSModelGroup modelGroup, SharedElements sharedElements) {
        XSObjectList particles = modelGroup.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XsdBinder.bindParticle(doc, particle, sharedElements);
        }
    }

    private static void popType() {
        Object o = XsdBinder.getXsdBinding().typeGroupStack.removeLast();
        if (!(o instanceof TypeBinding)) {
            throw new JBossXBRuntimeException("Should have poped type binding but got " + o);
        }
    }

    private static void pushType(TypeBinding binding) {
        XsdBinder.getXsdBinding().typeGroupStack.addLast(binding);
    }

    private static Object peekTypeOrGroup() {
        LinkedList stack = XsdBinder.getXsdBinding().typeGroupStack;
        return stack.isEmpty() ? null : stack.getLast();
    }

    private static TypeBinding peekType() {
        LinkedList stack = XsdBinder.getXsdBinding().typeGroupStack;
        TypeBinding binding = null;
        for (int i = stack.size() - 1; i >= 0; --i) {
            Object o = stack.get(i);
            if (!(o instanceof TypeBinding)) continue;
            binding = (TypeBinding)o;
            break;
        }
        return binding;
    }

    private static void popModelGroup() {
        Object o = XsdBinder.getXsdBinding().typeGroupStack.removeLast();
        if (!(o instanceof ModelGroupBinding)) {
            throw new JBossXBRuntimeException("Should have poped model group binding but got " + o);
        }
    }

    private static void pushModelGroup(ModelGroupBinding binding) {
        XsdBinder.getXsdBinding().typeGroupStack.addLast(binding);
    }

    private static final class XsdBinding {
        public final LinkedList typeGroupStack = new LinkedList();
        public final SchemaBinding schemaBinding = new SchemaBinding();

        private XsdBinding() {
        }
    }

    public static class XsdBinderErrorHandler
    implements DOMErrorHandler {
        public static final XsdBinderErrorHandler INSTANCE = new XsdBinderErrorHandler();

        private XsdBinderErrorHandler() {
        }

        public boolean handleError(DOMError error) {
            switch (error.getSeverity()) {
                case 2: {
                    throw new JBossXBRuntimeException(this.formatMessage(error));
                }
                case 3: {
                    throw new JBossXBRuntimeException(this.formatMessage(error));
                }
                case 1: {
                    log.warn(this.formatMessage(error));
                }
            }
            return false;
        }

        private String formatMessage(DOMError error) {
            StringBuffer buf = new StringBuffer();
            DOMLocator location = error.getLocation();
            if (location != null) {
                buf.append(location.getColumnNumber()).append(':').append(location.getLineNumber());
            } else {
                buf.append("[location unavailable]");
            }
            buf.append(' ').append(error.getMessage());
            return buf.toString();
        }
    }

    private static final class SharedElements {
        private Map elements = Collections.EMPTY_MAP;

        private SharedElements() {
        }

        public void add(XSElementDeclaration element) {
            switch (this.elements.size()) {
                case 0: {
                    this.elements = Collections.singletonMap(element, null);
                    break;
                }
                case 1: {
                    this.elements = new HashMap(this.elements);
                }
                default: {
                    this.elements.put(element, null);
                }
            }
        }

        public boolean isShared(XSElementDeclaration element) {
            return this.elements.containsKey(element);
        }

        public TypeBinding getTypeBinding(XSElementDeclaration element) {
            return (TypeBinding)this.elements.get(element);
        }

        public void setTypeBinding(XSElementDeclaration element, TypeBinding type) {
            this.elements.put(element, type);
        }
    }
}

