/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.portlet.ActionResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.ServerConversationContext;
import org.jboss.seam.contexts.Session;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Pages;
import org.jboss.seam.jbpm.Page;
import org.jboss.seam.util.Id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.EVENT)
@Name(value="org.jboss.seam.core.manager")
@Intercept(value=InterceptionType.NEVER)
public class Manager {
    private static final Log log = LogFactory.getLog(Manager.class);
    private static final String NAME = Seam.getComponentName(Manager.class);
    public static final String CONVERSATION_ID_MAP = NAME + ".conversationIdEntryMap";
    public static final String CONVERSATION_ID = NAME + ".conversationId";
    public static final String PAGEFLOW_COUNTER = NAME + ".pageflowCounter";
    public static final String PAGEFLOW_NODE_NAME = NAME + ".pageflowNodeName";
    private Map<String, ConversationEntry> conversationIdEntryMap;
    private boolean dirty = false;
    private String currentConversationId;
    private LinkedList<String> currentConversationIdStack;
    private boolean isLongRunningConversation;
    private int conversationTimeout = 600000;

    public String getCurrentConversationId() {
        return this.currentConversationId;
    }

    public void setCurrentConversationId(String id) {
        this.currentConversationId = id;
    }

    public Set<String> getSessionConversationIds() {
        return this.getConversationIdEntryMap().keySet();
    }

    public Map<String, ConversationEntry> getConversationIdEntryMap() {
        if (this.conversationIdEntryMap == null) {
            this.conversationIdEntryMap = (Map)Contexts.getSessionContext().get(CONVERSATION_ID_MAP);
            if (this.conversationIdEntryMap == null) {
                this.conversationIdEntryMap = Collections.synchronizedMap(new HashMap());
            }
        }
        return this.conversationIdEntryMap;
    }

    private void dirty() {
        this.dirty = true;
    }

    private ConversationEntry removeConversationEntry(String conversationId) {
        Map<String, ConversationEntry> entryMap = this.getConversationIdEntryMap();
        if (entryMap.containsKey(conversationId)) {
            this.dirty();
            return entryMap.remove(conversationId);
        }
        return null;
    }

    private void touchConversationStack() {
        LinkedList<String> stack = this.getCurrentConversationIdStack();
        if (stack != null) {
            for (String conversationId : stack) {
                ConversationEntry conversationEntry = this.getConversationEntry(conversationId);
                if (conversationEntry == null) continue;
                conversationEntry.touch();
                this.dirty();
            }
        }
        if (this.isLongRunningConversation()) {
            this.getCurrentConversationEntry().touch();
        }
    }

    private ConversationEntry getConversationEntry(String conversationId) {
        return this.getConversationIdEntryMap().get(conversationId);
    }

    public Object getCurrentConversationInitiator() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce != null) {
            return ce.getInitiatorComponentName();
        }
        return null;
    }

    public LinkedList<String> getCurrentConversationIdStack() {
        return this.currentConversationIdStack;
    }

    private void setCurrentConversationIdStack(LinkedList<String> stack) {
        this.currentConversationIdStack = stack;
    }

    private void setCurrentConversationIdStack(String id) {
        this.currentConversationIdStack = new LinkedList();
        this.currentConversationIdStack.add(id);
    }

    public void setCurrentConversationDescription(String description) {
        this.getCurrentConversationEntry().setDescription(description);
        this.dirty();
    }

    public void setCurrentConversationViewId(String viewId) {
        this.getCurrentConversationEntry().setViewId(viewId);
        this.dirty();
    }

    public void setCurrentConversationTimeout(int timeout) {
        this.getCurrentConversationEntry().setTimeout(timeout);
        this.dirty();
    }

    public String getCurrentConversationDescription() {
        if (this.conversationIdEntryMap == null) {
            return null;
        }
        ConversationEntry ce = this.conversationIdEntryMap.get(this.currentConversationId);
        if (ce == null) {
            return null;
        }
        return ce.getDescription();
    }

    public String getCurrentConversationViewId() {
        if (this.conversationIdEntryMap == null) {
            return null;
        }
        ConversationEntry ce = this.conversationIdEntryMap.get(this.currentConversationId);
        if (ce == null) {
            return null;
        }
        return ce.getViewId();
    }

    @Destroy
    public void flushConversationIdMapToSession() {
        if (Contexts.isSessionContextActive() && this.dirty) {
            Contexts.getSessionContext().set(CONVERSATION_ID_MAP, this.conversationIdEntryMap);
        }
    }

    public boolean isLongRunningConversation() {
        return this.isLongRunningConversation;
    }

    public void setLongRunningConversation(boolean isLongRunningConversation) {
        this.isLongRunningConversation = isLongRunningConversation;
    }

    public static Manager instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("No active event context");
        }
        Manager instance = (Manager)Component.getInstance(Manager.class, ScopeType.EVENT, true);
        if (instance == null) {
            throw new IllegalStateException("No Manager could be created, make sure the Component exists in application scope");
        }
        return instance;
    }

    public void conversationTimeout(ExternalContext externalContext) {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, ConversationEntry>> entries = this.getConversationIdEntryMap().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, ConversationEntry> entry = entries.next();
            ConversationEntry conversationEntry = entry.getValue();
            long delta = currentTime - conversationEntry.getLastRequestTime();
            if (delta <= (long)conversationEntry.getTimeout()) continue;
            String conversationId = entry.getKey();
            log.debug((Object)("conversation timeout for conversation: " + conversationId));
            Session session = Session.getSession(externalContext, true);
            this.destroyConversation(conversationId, session, entries);
        }
    }

    private void destroyConversation(String conversationId, Session session, Iterator iter) {
        ServerConversationContext conversationContext = new ServerConversationContext(session, conversationId);
        Contexts.destroy(conversationContext);
        conversationContext.clear();
        conversationContext.flush();
        iter.remove();
        this.dirty();
    }

    public void storeConversation(Session session, Object response) {
        if (this.isLongRunningConversation()) {
            this.touchConversationStack();
            if (!Seam.isSessionInvalid()) {
                Pageflow pageflow;
                log.debug((Object)("Storing conversation state: " + this.currentConversationId));
                Conversation.instance().flush();
                if (Contexts.isPageContextActive()) {
                    Contexts.getPageContext().set(CONVERSATION_ID, this.currentConversationId);
                }
                this.writeConversationIdToResponse(response, this.currentConversationId);
                if (Contexts.isPageContextActive() && Init.instance().isJbpmInstalled() && (pageflow = Pageflow.instance()).isInProcess()) {
                    Contexts.getPageContext().set(PAGEFLOW_COUNTER, pageflow.getPageflowCounter());
                    Contexts.getPageContext().set(PAGEFLOW_NODE_NAME, pageflow.getNode().getName());
                }
            }
        } else {
            log.debug((Object)("Discarding conversation state: " + this.currentConversationId));
            LinkedList<String> stack = this.getCurrentConversationIdStack();
            if (stack.size() > 1) {
                String outerConversationId = stack.get(1);
                if (Contexts.isPageContextActive()) {
                    Contexts.getPageContext().set(CONVERSATION_ID, outerConversationId);
                }
                this.writeConversationIdToResponse(response, outerConversationId);
            } else if (Contexts.isPageContextActive()) {
                Contexts.getPageContext().remove(CONVERSATION_ID);
            }
            this.removeCurrentConversationAndDestroyNestedContexts(session);
        }
    }

    private void writeConversationIdToResponse(Object response, String conversationId) {
        if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).setHeader("conversationId", conversationId);
        } else if (response instanceof ActionResponse) {
            ((ActionResponse)response).setRenderParameter("conversationId", conversationId);
        }
    }

    private void removeCurrentConversationAndDestroyNestedContexts(Session session) {
        this.removeConversationEntry(this.currentConversationId);
        this.destroyNestedContexts(session, this.currentConversationId);
    }

    private void destroyNestedContexts(Session session, String conversationId) {
        Iterator<ConversationEntry> entries = this.getConversationIdEntryMap().values().iterator();
        while (entries.hasNext()) {
            ConversationEntry ce = entries.next();
            if (!ce.getConversationIdStack().contains(conversationId)) continue;
            String entryConversationId = ce.getId();
            log.debug((Object)("destroying nested conversation: " + entryConversationId));
            this.destroyConversation(entryConversationId, session, entries);
        }
    }

    private String getPropagationFromRequestParameter(Map parameters) {
        Object type = parameters.get("conversationPropagation");
        if (type == null) {
            return null;
        }
        if (type instanceof String) {
            return (String)type;
        }
        return ((String[])type)[0];
    }

    public void restoreConversation(Map parameters) {
        String propagation;
        String storedConversationId = this.getConversationIdFromRequestParameter(parameters);
        if (this.isMissing(storedConversationId) && Contexts.isPageContextActive()) {
            storedConversationId = (String)Contexts.getPageContext().get(CONVERSATION_ID);
        } else if (storedConversationId != null) {
            log.debug((Object)("Found conversation id in request parameter: " + storedConversationId));
        }
        if ("new".equals(storedConversationId)) {
            storedConversationId = null;
        }
        if ("none".equals(propagation = this.getPropagationFromRequestParameter(parameters))) {
            storedConversationId = null;
        }
        this.restoreConversation(storedConversationId);
    }

    public void handleConversationPropagation(Map parameters) {
        String propagation = this.getPropagationFromRequestParameter(parameters);
        if (propagation != null && propagation.startsWith("begin")) {
            if (this.isLongRunningConversation) {
                throw new IllegalStateException("long-running conversation already active");
            }
            this.beginConversation(null);
            if (propagation.length() > 6) {
                Pageflow.instance().begin(propagation.substring(6));
            }
        } else if (propagation != null && propagation.startsWith("join")) {
            if (!this.isLongRunningConversation) {
                this.beginConversation(null);
                if (propagation.length() > 5) {
                    Pageflow.instance().begin(propagation.substring(5));
                }
            }
        } else if (propagation != null && propagation.startsWith("nest")) {
            this.beginNestedConversation(null);
            if (propagation.length() > 5) {
                Pageflow.instance().begin(propagation.substring(5));
            }
        } else if ("end".equals(propagation)) {
            this.endConversation();
        }
    }

    public void restoreConversation(String storedConversationId) {
        boolean isStoredConversation;
        boolean bl = isStoredConversation = storedConversationId != null && this.getSessionConversationIds().contains(storedConversationId);
        if (isStoredConversation) {
            log.debug((Object)("Restoring conversation with id: " + storedConversationId));
            this.setLongRunningConversation(true);
            this.setCurrentConversationId(storedConversationId);
            ConversationEntry ce = this.getCurrentConversationEntry();
            this.setCurrentConversationIdStack(ce.getConversationIdStack());
            if (ce.isRemoveAfterRedirect()) {
                this.setLongRunningConversation(false);
            }
        } else {
            log.debug((Object)"No stored conversation");
            this.initializeTemporaryConversation();
        }
    }

    private String getConversationIdFromRequestParameter(Map parameters) {
        Object object = parameters.get("conversationId");
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        String[] values = (String[])object;
        if (values.length != 1) {
            throw new IllegalArgumentException("expected exactly one value for conversationId request parameter");
        }
        return values[0];
    }

    private boolean isMissing(String storedConversationId) {
        return storedConversationId == null || "".equals(storedConversationId);
    }

    public void initializeTemporaryConversation() {
        String id = Id.nextId();
        this.setCurrentConversationId(id);
        this.setCurrentConversationIdStack(id);
        this.setLongRunningConversation(false);
    }

    private ConversationEntry createConversationEntry() {
        ConversationEntry ce = new ConversationEntry(this.getCurrentConversationId(), this.getCurrentConversationIdStack());
        this.getConversationIdEntryMap().put(this.getCurrentConversationId(), ce);
        this.dirty();
        return ce;
    }

    public void beginConversation(String initiator) {
        this.setLongRunningConversation(true);
        this.createConversationEntry().setInitiatorComponentName(initiator);
        Conversation.instance();
    }

    public void endConversation() {
        this.setLongRunningConversation(false);
    }

    public void beginNestedConversation(String ownerName) {
        LinkedList<String> stack = this.getCurrentConversationIdStack();
        String id = Id.nextId();
        this.setCurrentConversationId(id);
        this.setCurrentConversationIdStack(id);
        this.getCurrentConversationIdStack().addAll(stack);
        ConversationEntry conversationEntry = this.createConversationEntry();
        conversationEntry.setInitiatorComponentName(ownerName);
    }

    public ConversationEntry getCurrentConversationEntry() {
        return this.getConversationEntry(this.getCurrentConversationId());
    }

    public void leaveConversation() {
        this.initializeTemporaryConversation();
    }

    public boolean swapConversation(String id) {
        ConversationEntry ce = this.getConversationEntry(id);
        if (ce != null) {
            this.setCurrentConversationId(id);
            this.setCurrentConversationIdStack(ce.getConversationIdStack());
            this.setLongRunningConversation(true);
            return true;
        }
        return false;
    }

    public int getConversationTimeout() {
        return this.conversationTimeout;
    }

    public void setConversationTimeout(int conversationTimeout) {
        this.conversationTimeout = conversationTimeout;
    }

    public void beforeRedirect() {
        ConversationEntry ce = this.getConversationEntry(this.currentConversationId);
        if (ce == null) {
            ce = this.createConversationEntry();
        }
        ce.setRemoveAfterRedirect(!this.isLongRunningConversation());
        this.setLongRunningConversation(true);
    }

    public String encodeConversationId(String url) {
        this.beforeRedirect();
        char sep = url.contains("?") ? (char)'&' : '?';
        return url + sep + "conversationId=" + this.getCurrentConversationId();
    }

    public void redirect(String viewId) {
        this.redirect(viewId, null, true);
    }

    public String encodeParameters(String url, Map<String, Object> parameters) {
        StringBuilder builder = new StringBuilder(url);
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            builder.append('&').append(param.getKey()).append('=').append(param.getValue());
        }
        builder.setCharAt(url.length(), '?');
        return builder.toString();
    }

    public void redirect(String viewId, Map<String, Object> parameters, boolean includeConversationId) {
        FacesContext context = FacesContext.getCurrentInstance();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        if (parameters != null) {
            url = this.encodeParameters(url, parameters);
        }
        if (includeConversationId) {
            url = this.encodeConversationId(url);
        }
        ExternalContext externalContext = context.getExternalContext();
        try {
            externalContext.redirect(externalContext.encodeActionURL(url));
        }
        catch (IOException ioe) {
            throw new RuntimeException("could not redirect to: " + url, ioe);
        }
        context.responseComplete();
    }

    public void prepareBackswitch(PhaseEvent event) {
        if (this.isLongRunningConversation()) {
            Page page;
            Conversation conversation = Conversation.instance();
            Page page2 = page = Init.instance().isJbpmInstalled() ? Pageflow.instance().getPage() : null;
            if (page != null) {
                if (page.hasDescription()) {
                    conversation.setDescription(page.getDescription());
                    conversation.setViewId(page.getViewId());
                }
                conversation.setTimeout(page.getTimeout());
            } else {
                String viewId = event.getFacesContext().getViewRoot().getViewId();
                Pages pages = Pages.instance();
                if (pages != null) {
                    if (pages.hasDescription(viewId)) {
                        conversation.setDescription(pages.getDescription(viewId));
                        conversation.setViewId(viewId);
                    }
                    conversation.setTimeout(pages.getTimeout(viewId));
                }
            }
        }
    }
}

