/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.jboss.logging.Logger;

public class JBossLogHandler
extends Handler {
    public JBossLogHandler() {
        super.setFormatter(new SimpleFormatter());
    }

    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            string = this.getFormatter().formatMessage(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        if (logRecord.getLevel() == Level.INFO) {
            Logger.getLogger((String)logRecord.getSourceClassName()).info((Object)string);
        } else if (logRecord.getLevel() == Level.SEVERE) {
            Logger.getLogger((String)logRecord.getSourceClassName()).error((Object)string);
        } else if (logRecord.getLevel() == Level.WARNING) {
            Logger.getLogger((String)logRecord.getSourceClassName()).warn((Object)string);
        } else if (logRecord.getLevel() == Level.FINE) {
            Logger.getLogger((String)logRecord.getSourceClassName()).debug((Object)string);
        } else if (logRecord.getLevel() == Level.FINER || logRecord.getLevel() == Level.FINEST) {
            Logger.getLogger((String)logRecord.getSourceClassName()).trace((Object)string);
        } else {
            Logger.getLogger((String)logRecord.getSourceClassName()).debug((Object)string);
        }
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (logRecord == null) {
            return false;
        }
        return super.isLoggable(logRecord);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

