/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.id;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.connection.ConnectionProviderFactory;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.id.PersistentIdentifierGenerator;
import cirrus.hibernate.sql.Dialect;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HiLoGenerator
implements PersistentIdentifierGenerator {
    private long hi;
    private short lo = Short.MAX_VALUE;
    private final String tableName;
    private final String columnName;
    private final String query;
    private final String update;
    private ConnectionProvider connections;
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$id$HiLoGenerator == null ? (class$cirrus$hibernate$id$HiLoGenerator = HiLoGenerator.class$("cirrus.hibernate.id.HiLoGenerator")) : class$cirrus$hibernate$id$HiLoGenerator));
    static /* synthetic */ Class class$cirrus$hibernate$id$HiLoGenerator;

    public HiLoGenerator(String tableName, String columnName) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.query = "select " + columnName + " from " + tableName;
        this.update = "update " + tableName + " set " + columnName + " = ? where " + columnName + " = ?";
    }

    public HiLoGenerator() {
        this("hibernate_unique_key", "next_hi");
    }

    public HiLoGenerator(String driverclass, String url, String username, String password) throws HibernateException {
        this();
        this.connections = this.getConnectionProvider(driverclass, url, username, password);
    }

    public HiLoGenerator(String driverclass, String url, String username, String password, String tablename, String columnname) throws HibernateException {
        this(tablename, columnname);
        this.connections = this.getConnectionProvider(driverclass, url, username, password);
    }

    protected ConnectionProvider getConnectionProvider(String driverclass, String url, String username, String password) throws HibernateException {
        Properties props = new Properties();
        props.put("hibernate.connection.driver_class", driverclass);
        props.put("hibernate.connection.url", url);
        props.put("hibernate.connection.username", username);
        props.put("hibernate.connection.password", password);
        return ConnectionProviderFactory.newConnectionProvider(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Serializable generate(SessionImplementor session, Object obj) throws SQLException {
        if (this.lo == Short.MAX_VALUE) {
            Connection conn = this.connections == null ? session.getFactory().openConnection() : this.connections.getConnection();
            try {
                int hiInt;
                int rows;
                do {
                    Object var11_10;
                    Object var9_9;
                    PreparedStatement qps = conn.prepareStatement(this.query);
                    try {
                        try {
                            ResultSet rs = qps.executeQuery();
                            rs.next();
                            hiInt = rs.getInt(this.columnName);
                            rs.close();
                        }
                        catch (SQLException sqle) {
                            log.error((Object)("could not read a hi value - may need to populate the table: " + this.tableName), (Throwable)sqle);
                            throw sqle;
                        }
                        var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        qps.close();
                        throw throwable;
                    }
                    qps.close();
                    PreparedStatement ups = conn.prepareStatement(this.update);
                    try {
                        try {
                            ups.setInt(1, hiInt + 1);
                            ups.setInt(2, hiInt);
                            rows = ups.executeUpdate();
                        }
                        catch (SQLException sqle) {
                            log.error((Object)("could not update hi value in: " + this.tableName), (Throwable)sqle);
                            throw sqle;
                        }
                        var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        var11_10 = null;
                        ups.close();
                        throw throwable;
                    }
                    ups.close();
                } while (rows == 0);
                conn.commit();
                this.lo = 0;
                this.hi = hiInt;
            }
            finally {
                if (this.connections == null) {
                    session.getFactory().closeConnection(conn);
                } else {
                    this.connections.closeConnection(conn);
                }
            }
            log.debug((Object)("New hi value: " + this.hi));
        }
        short s = this.lo;
        this.lo = (short)(s + 1);
        return new Long((this.hi << 16) + (long)s);
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{"create table " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(4) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String sqlDropString(Dialect dialect) {
        return "drop table " + this.tableName;
    }

    public Object generatorKey() {
        return this.tableName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

