/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.serviceref;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.ServiceRefMetaDataParser;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.xb.QNameBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultServiceRefMetaDataParser
implements ServiceRefMetaDataParser {
    private static final Logger log = Logger.getLogger(DefaultServiceRefMetaDataParser.class);

    public void importStandardXml(Element element, UnifiedServiceRefMetaData unifiedServiceRefMetaData) {
        UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData;
        Element element2;
        unifiedServiceRefMetaData.setServiceRefName(this.getElementContent(element, "service-ref-name"));
        unifiedServiceRefMetaData.setServiceInterface(this.getOptionalElementContent(element, "service-interface"));
        unifiedServiceRefMetaData.setWsdlFile(this.getOptionalElementContent(element, "wsdl-file"));
        unifiedServiceRefMetaData.setMappingFile(this.getOptionalElementContent(element, "jaxrpc-mapping-file"));
        Element element3 = DOMUtils.getFirstChildElement((Node)element, (String)"service-qname");
        if (element3 != null) {
            unifiedServiceRefMetaData.setServiceQName(QNameBuilder.buildQName((Element)element3, (String)this.getTextContent(element3)));
        }
        Iterator iterator = DOMUtils.getChildElements((Node)element, (String)"port-component-ref");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            unifiedPortComponentRefMetaData = new UnifiedPortComponentRefMetaData(unifiedServiceRefMetaData);
            unifiedPortComponentRefMetaData.importStandardXml(element2);
            unifiedServiceRefMetaData.addPortComponentRef(unifiedPortComponentRefMetaData);
        }
        iterator = DOMUtils.getChildElements((Node)element, (String)"handler");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            unifiedPortComponentRefMetaData = new UnifiedHandlerMetaData();
            unifiedPortComponentRefMetaData.importStandardXml(element2);
            unifiedServiceRefMetaData.addHandler((UnifiedHandlerMetaData)unifiedPortComponentRefMetaData);
        }
    }

    public void importJBossXml(Element element, UnifiedServiceRefMetaData unifiedServiceRefMetaData) {
        Object object;
        String string;
        Element element2;
        unifiedServiceRefMetaData.setConfigName(this.getOptionalElementContent(element, "config-name"));
        unifiedServiceRefMetaData.setConfigFile(this.getOptionalElementContent(element, "config-file"));
        unifiedServiceRefMetaData.setWsdlOverride(this.getOptionalElementContent(element, "wsdl-override"));
        Iterator iterator = DOMUtils.getChildElements((Node)element, (String)"port-component-ref");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            string = this.getOptionalElementContent(element2, "service-endpoint-interface");
            UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData = unifiedServiceRefMetaData.getPortComponentRef(string, (QName)(object = this.getOptionalElementContentAsQName(element2, "port-qname")));
            if (unifiedPortComponentRefMetaData == null && string != null) {
                unifiedPortComponentRefMetaData = new UnifiedPortComponentRefMetaData(unifiedServiceRefMetaData);
                unifiedPortComponentRefMetaData.importStandardXml(element2);
                unifiedServiceRefMetaData.addPortComponentRef(unifiedPortComponentRefMetaData);
            }
            if (unifiedPortComponentRefMetaData == null) continue;
            unifiedPortComponentRefMetaData.importJBossXml(element2);
        }
        iterator = DOMUtils.getChildElements((Node)element, (String)"call-property");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            string = this.getElementContent(element2, "prop-name");
            object = this.getElementContent(element2, "prop-value");
            unifiedServiceRefMetaData.addCallProperty(new UnifiedCallPropertyMetaData(string, (String)object));
        }
    }

    public void importStandardXml(Element element, UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData) {
        unifiedPortComponentRefMetaData.setServiceEndpointInterface(this.getOptionalElementContent(element, "service-endpoint-interface"));
        unifiedPortComponentRefMetaData.setPortComponentLink(this.getOptionalElementContent(element, "port-component-link"));
    }

    public void importJBossXml(Element element, UnifiedPortComponentRefMetaData unifiedPortComponentRefMetaData) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator = DOMUtils.getChildElements((Node)element, (String)"call-property");
        while (iterator.hasNext()) {
            object4 = (Element)iterator.next();
            object3 = this.getElementContent((Element)object4, "prop-name");
            object2 = this.getElementContent((Element)object4, "prop-value");
            unifiedPortComponentRefMetaData.addCallProperty(new UnifiedCallPropertyMetaData((String)object3, (String)object2));
        }
        iterator = DOMUtils.getChildElements((Node)element, (String)"stub-property");
        while (iterator.hasNext()) {
            object4 = (Element)iterator.next();
            object3 = this.getElementContent((Element)object4, "prop-name");
            object2 = this.getElementContent((Element)object4, "prop-value");
            object = new UnifiedStubPropertyMetaData();
            object.setPropName((String)object3);
            object.setPropValue((String)object2);
            unifiedPortComponentRefMetaData.addStubProperty(object);
        }
        object4 = this.getOptionalElementContentAsQName(element, "port-qname");
        if (object4 != null) {
            unifiedPortComponentRefMetaData.setPortQName((QName)object4);
        }
        if ((object3 = DOMUtils.getFirstChildElement((Node)element, (String)"config-name")) != null) {
            unifiedPortComponentRefMetaData.setConfigName(this.getTextContent((Element)object3));
        }
        if ((object2 = DOMUtils.getFirstChildElement((Node)element, (String)"config-file")) != null) {
            unifiedPortComponentRefMetaData.setConfigFile(this.getTextContent((Element)object2));
        }
        if ((object = DOMUtils.getFirstChildElement((Node)element, (String)"service-endpoint-interface")) != null) {
            unifiedPortComponentRefMetaData.setServiceEndpointInterface(this.getTextContent((Element)object));
        }
    }

    public void importStandardXml(Element element, UnifiedHandlerMetaData unifiedHandlerMetaData) {
        Object object;
        Element element2;
        unifiedHandlerMetaData.setHandlerName(this.getElementContent(element, "handler-name"));
        unifiedHandlerMetaData.setHandlerClass(this.getElementContent(element, "handler-class"));
        Iterator iterator = DOMUtils.getChildElements((Node)element, (String)"init-param");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            object = new UnifiedInitParamMetaData();
            object.setParamName(this.getElementContent(element2, "param-name"));
            object.setParamValue(this.getElementContent(element2, "param-value"));
            unifiedHandlerMetaData.addInitParam(object);
        }
        iterator = DOMUtils.getChildElements((Node)element, (String)"soap-header");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            object = this.getTextContent(element2);
            QName qName = DOMUtils.resolveQName((Element)element2, (String)object);
            unifiedHandlerMetaData.addSoapHeader(qName);
        }
        iterator = DOMUtils.getChildElements((Node)element, (String)"soap-role");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            object = this.getTextContent(element2);
            unifiedHandlerMetaData.addSoapRole((String)object);
        }
        iterator = DOMUtils.getChildElements((Node)element, (String)"port-name");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            object = this.getTextContent(element2);
            unifiedHandlerMetaData.addPortName((String)object);
        }
    }

    private String getElementContent(Element element, String string) {
        String string2 = this.getOptionalElementContent(element, string);
        if (string2 == null || string2.length() == 0) {
            throw new IllegalStateException("Invalid null element content: " + string);
        }
        return string2;
    }

    private String getOptionalElementContent(Element element, String string) {
        return this.getTextContent(DOMUtils.getFirstChildElement((Node)element, (String)string));
    }

    private QName getOptionalElementContentAsQName(Element element, String string) {
        QName qName = null;
        String string2 = this.getOptionalElementContent(element, string);
        if (string2 != null) {
            qName = string2.startsWith("{") ? QName.valueOf(string2) : DOMUtils.resolveQName((Element)element, (String)string2);
        }
        return qName;
    }

    private String getTextContent(Element element) {
        String string = null;
        if (element != null && (string = DOMUtils.getTextContent((Node)element)) != null) {
            string = string.trim();
        }
        return string;
    }
}

