/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class LabelStatementPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new LabelStatementPrinter();

    protected LabelStatementPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        boolean indentLabel = settings.getBoolean(ConventionKeys.INDENT_LABEL, false);
        boolean lineWrapLabel = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LABEL, true);
        AST identifier = node.getFirstChild();
        AST body = identifier.getNextSibling();
        boolean newlineAfter = false;
        boolean commentAfter = false;
        if (lineWrapLabel && body.getType() != 11) {
            newlineAfter = true;
        }
        if (indentLabel) {
            this.printCommentsBefore(node, out);
            this.logIssues(node, out);
            PrinterFactory.create(identifier).print(identifier, out);
            out.print(": ", 26);
            commentAfter = this.printCommentsAfter(node, false, newlineAfter, out);
        } else {
            int oldLevel = out.getIndentLevel();
            out.setIndentLevel(0);
            this.printCommentsBefore(node, out);
            this.logIssues(node, out);
            PrinterFactory.create(identifier).print(identifier, out);
            out.print(": ", 26);
            if (!this.printCommentsAfter(node, false, newlineAfter, out)) {
                int diff = out.getIndentLength() - identifier.getText().length() - 2;
                if (diff > 1) {
                    out.print(out.getString(diff), 153);
                }
            } else {
                commentAfter = true;
            }
            out.setIndentLevel(oldLevel);
        }
        if (newlineAfter && !commentAfter) {
            out.printNewline();
        }
        PrinterFactory.create(body).print(body, out);
    }
}

