/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.jfree.io.IOUtils;
import org.jfree.xml.generator.ModelBuilder;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.Comments;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.IgnoredPropertyInfo;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.util.AbstractModelReader;
import org.jfree.xml.util.ObjectDescriptionException;

public class DefaultModelReader
extends AbstractModelReader {
    private DescriptionModel model;
    private ClassDescription currentClassDescription;
    private BeanInfo currentBeanInfo;
    private URL baseURL;
    private String source;
    private MultiplexMappingInfo multiplexInfo;
    private ArrayList multiplexTypeInfos;
    private ArrayList propertyList;
    private ArrayList constructorList;
    static /* synthetic */ Class class$java$lang$Object;

    public synchronized DescriptionModel load(String string) throws IOException, ObjectDescriptionException {
        this.model = new DescriptionModel();
        this.baseURL = new File(string).toURL();
        this.parseXml(this.baseURL);
        this.fillSuperClasses();
        return this.model;
    }

    protected void fillSuperClasses() {
        for (int i = 0; i < this.model.size(); ++i) {
            ClassDescription classDescription;
            ClassDescription classDescription2 = this.model.get(i);
            Class clazz = classDescription2.getObjectClass().getSuperclass();
            if (clazz == null || (classDescription = this.model.get(clazz)) == null) continue;
            classDescription2.setSuperClass(classDescription.getObjectClass());
        }
    }

    protected boolean startObjectDefinition(String string, String string2, boolean bl) {
        Class clazz = this.loadClass(string);
        if (clazz == null) {
            return false;
        }
        this.currentClassDescription = new ClassDescription(clazz);
        this.currentClassDescription.setPreserve(bl);
        this.currentClassDescription.setRegisterKey(string2);
        try {
            this.currentBeanInfo = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = DefaultModelReader.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
        this.propertyList = new ArrayList();
        this.constructorList = new ArrayList();
        return true;
    }

    protected void endObjectDefinition() throws ObjectDescriptionException {
        PropertyInfo[] propertyInfoArray = this.propertyList.toArray(new PropertyInfo[this.propertyList.size()]);
        this.currentClassDescription.setProperties(propertyInfoArray);
        TypeInfo[] typeInfoArray = this.constructorList.toArray(new TypeInfo[this.constructorList.size()]);
        this.currentClassDescription.setConstructorDescription(typeInfoArray);
        this.currentClassDescription.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.currentClassDescription.setSource(this.source);
        this.model.addClassDescription(this.currentClassDescription);
        this.propertyList = null;
        this.currentBeanInfo = null;
        this.currentClassDescription = null;
    }

    protected void handleAttributeDefinition(String string, String string2, String string3) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(string));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + string);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.ATTRIBUTE);
        propertyInfo.setXmlName(string2);
        propertyInfo.setXmlHandler(string3);
        this.propertyList.add(propertyInfo);
    }

    protected void handleConstructorDefinition(String string, String string2) throws ObjectDescriptionException {
        Class clazz = this.loadClass(string2);
        if (clazz == null) {
            throw new ObjectDescriptionException("Failed to load class " + string2);
        }
        TypeInfo typeInfo = new TypeInfo(string, clazz);
        typeInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.constructorList.add(typeInfo);
    }

    protected void handleElementDefinition(String string, String string2) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(string));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + string);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.ELEMENT);
        propertyInfo.setXmlName(string2);
        propertyInfo.setXmlHandler(null);
        this.propertyList.add(propertyInfo);
    }

    protected void handleLookupDefinition(String string, String string2) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(string));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + string);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.LOOKUP);
        propertyInfo.setXmlName(string2);
        propertyInfo.setXmlHandler(null);
        this.propertyList.add(propertyInfo);
    }

    protected PropertyDescriptor getPropertyDescriptor(String string) {
        PropertyDescriptor[] propertyDescriptorArray = this.currentBeanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!propertyDescriptorArray[i].getName().equals(string)) continue;
            return propertyDescriptorArray[i];
        }
        return null;
    }

    protected void handleIgnoredProperty(String string) {
        IgnoredPropertyInfo ignoredPropertyInfo = new IgnoredPropertyInfo(string);
        ignoredPropertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.propertyList.add(ignoredPropertyInfo);
    }

    protected boolean handleManualMapping(String string, String string2, String string3) throws ObjectDescriptionException {
        ManualMappingInfo manualMappingInfo = new ManualMappingInfo(this.loadClass(string), this.loadClass(string2), this.loadClass(string3));
        manualMappingInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        manualMappingInfo.setSource(this.source);
        this.model.getMappingModel().addManualMapping(manualMappingInfo);
        return true;
    }

    protected void startMultiplexMapping(String string, String string2) {
        this.multiplexInfo = new MultiplexMappingInfo(this.loadClass(string), string2);
        this.multiplexInfo.setSource(this.source);
        this.multiplexTypeInfos = new ArrayList();
    }

    protected void handleMultiplexMapping(String string, String string2) throws ObjectDescriptionException {
        TypeInfo typeInfo = new TypeInfo(string, this.loadClass(string2));
        typeInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.multiplexTypeInfos.add(typeInfo);
    }

    protected void endMultiplexMapping() throws ObjectDescriptionException {
        TypeInfo[] typeInfoArray = this.multiplexTypeInfos.toArray(new TypeInfo[this.multiplexTypeInfos.size()]);
        this.multiplexInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.multiplexInfo.setChildClasses(typeInfoArray);
        this.model.getMappingModel().addMultiplexMapping(this.multiplexInfo);
        this.multiplexInfo = null;
    }

    protected void startIncludeHandling(URL uRL) {
        this.source = IOUtils.getInstance().createRelativeURL(uRL, this.baseURL);
        this.model.addSource(this.source);
        this.model.addIncludeComment(this.source, new Comments(this.getOpenComment(), this.getCloseComment()));
    }

    protected void endIncludeHandling() {
        this.source = "";
    }

    protected void startRootDocument() {
        this.source = "";
    }

    protected void endRootDocument() {
        this.model.setModelComments(new Comments(this.getOpenComment(), this.getCloseComment()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

