/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.AbstractMarshaller;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.xml.sax.SAXException;

public class XercesXsMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(XercesXsMarshaller.class);
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private GenericObjectModelProvider provider;
    private Content content = new Content();
    private final Map prefixByUri = new HashMap();
    private Object root;
    private boolean supportNil;
    private QName rootTypeQName;
    private SchemaBindingResolver schemaResolver;

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public QName getRootTypeQName() {
        return this.rootTypeQName;
    }

    public void setRootTypeQName(QName rootTypeQName) {
        this.rootTypeQName = rootTypeQName;
    }

    public boolean isSupportNil() {
        return this.supportNil;
    }

    public void setSupportNil(boolean supportNil) {
        this.supportNil = supportNil;
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            return;
        }
        this.prefixByUri.put(uri, prefix);
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
    }

    public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        XSModel model = Util.loadSchema(xsdReader, null, this.schemaResolver);
        this.marshallInternal(provider, root, model, writer);
    }

    public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        XSModel model = Util.loadSchema(xsdURL, this.schemaResolver);
        this.marshallInternal(provider, root, model, writer);
    }

    public void marshal(XSModel model, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        this.marshallInternal(provider, root, model, writer);
    }

    private void marshallInternal(ObjectModelProvider provider, Object root, XSModel model, Writer writer) throws IOException, SAXException {
        if (model == null) {
            throw new JBossXBRuntimeException("XSModel is not available!");
        }
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        this.root = root;
        this.content.startDocument();
        if (this.rootTypeQName != null) {
            if (this.rootQNames.isEmpty()) {
                throw new JBossXBRuntimeException("If type name (" + this.rootTypeQName + ") for the root element is specified then the name for the root element is required!");
            }
            QName rootQName = (QName)this.rootQNames.get(0);
            XSTypeDefinition type = model.getTypeDefinition(this.rootTypeQName.getLocalPart(), this.rootTypeQName.getNamespaceURI());
            if (type == null) {
                throw new JBossXBRuntimeException("Global type definition is not found: " + this.rootTypeQName);
            }
            if (XercesXsMarshaller.isArrayWrapper(type)) {
                this.stack.push(root);
                this.marshalComplexType(rootQName.getNamespaceURI(), rootQName.getLocalPart(), (XSComplexTypeDefinition)type, true);
                this.stack.pop();
            } else {
                this.marshalElement(rootQName.getNamespaceURI(), rootQName.getLocalPart(), type, true, 1, 1, true);
            }
        } else if (this.rootQNames.isEmpty()) {
            XSNamedMap components = model.getComponents((short)2);
            if (components.getLength() == 0) {
                throw new JBossXBRuntimeException("The schema doesn't contain global element declarations.");
            }
            for (int i = 0; i < components.getLength(); ++i) {
                XSElementDeclaration element = (XSElementDeclaration)components.item(i);
                this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), 1, 1, true);
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                QName qName = (QName)this.rootQNames.get(i);
                XSElementDeclaration element = model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI());
                if (element == null) {
                    XSNamedMap components = model.getComponents((short)2);
                    String roots = "";
                    for (int j = 0; j < components.getLength(); ++j) {
                        XSObject xsObject = components.item(j);
                        if (j > 0) {
                            roots = roots + ", ";
                        }
                        roots = roots + "{" + xsObject.getNamespace() + "}" + xsObject.getName();
                    }
                    throw new IllegalStateException("Root element not found: " + qName + " among " + roots);
                }
                this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), 1, 1, true);
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
        if (log.isTraceEnabled()) {
            StringWriter traceWriter = new StringWriter();
            contentWriter = new ContentWriter(traceWriter, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
            this.content.handleContent(contentWriter);
            log.trace("marshalled:\n" + traceWriter.getBuffer().toString());
        }
    }

    private boolean marshalElement(String elementNs, String elementLocal, XSTypeDefinition type, boolean nillable, int minOccurs, int maxOccurs, boolean declareNs) {
        boolean trace;
        Object value;
        if (this.stack.isEmpty()) {
            value = this.provider.getRoot(this.root, null, elementNs, elementLocal);
            if (value == null) {
                return false;
            }
        } else {
            Object peeked = this.stack.peek();
            if (peeked instanceof Collection || peeked.getClass().isArray()) {
                value = peeked;
            } else {
                value = this.provider.getChildren(peeked, null, elementNs, elementLocal);
                if (value == null) {
                    value = this.provider.getElementValue(peeked, null, elementNs, elementLocal);
                }
            }
        }
        boolean result = minOccurs == 0 || value != null;
        boolean bl = trace = log.isTraceEnabled() && result;
        if (trace) {
            String prefix = (String)this.prefixByUri.get(elementNs);
            log.trace("started element ns=" + elementNs + ", local=" + elementLocal + ", prefix=" + prefix);
        }
        if (value != null) {
            this.stack.push(value);
            if (maxOccurs != 1) {
                Iterator i = null;
                if (value instanceof Collection) {
                    i = ((Collection)value).iterator();
                } else if (value.getClass().isArray()) {
                    final Object arr = value;
                    i = new Iterator(){
                        private int curInd = 0;
                        private int length = Array.getLength(arr);

                        public boolean hasNext() {
                            return this.curInd < this.length;
                        }

                        public Object next() {
                            return Array.get(arr, this.curInd++);
                        }

                        public void remove() {
                            throw new UnsupportedOperationException("remove is not implemented.");
                        }
                    };
                } else if (value instanceof Iterator) {
                    i = (Iterator)value;
                }
                if (i == null) {
                    this.marshalElementType(elementNs, elementLocal, type, declareNs);
                } else {
                    while (i.hasNext()) {
                        Object item = i.next();
                        this.stack.push(item);
                        this.marshalElementType(elementNs, elementLocal, type, declareNs);
                        this.stack.pop();
                    }
                }
            } else {
                this.marshalElementType(elementNs, elementLocal, type, declareNs);
            }
            this.stack.pop();
        } else if (this.supportNil && nillable) {
            AttributesImpl attrs;
            String prefix = (String)this.prefixByUri.get(elementNs);
            if (prefix == null && elementNs != null && elementNs.length() > 0) {
                prefix = "ns_" + elementLocal;
                attrs = new AttributesImpl(2);
                attrs.add(null, prefix, "xmlns:" + prefix, null, elementNs);
            } else {
                attrs = new AttributesImpl(1);
            }
            String nilQName = (String)this.prefixByUri.get("http://www.w3.org/2001/XMLSchema-instance") + ":nil";
            attrs.add("http://www.w3.org/2001/XMLSchema-instance", "nil", nilQName, null, "1");
            String qName = XercesXsMarshaller.createQName(prefix, elementLocal);
            this.content.startElement(elementNs, elementLocal, qName, attrs);
            this.content.endElement(elementNs, elementLocal, qName);
        }
        if (trace) {
            log.trace("finished element ns=" + elementNs + ", local=" + elementLocal);
        }
        return result;
    }

    private void marshalElementType(String elementNs, String elementLocal, XSTypeDefinition type, boolean declareNs) {
        switch (type.getTypeCategory()) {
            case 16: {
                this.marshalSimpleType(elementNs, elementLocal, (XSSimpleTypeDefinition)type, declareNs);
                break;
            }
            case 15: {
                this.marshalComplexType(elementNs, elementLocal, (XSComplexTypeDefinition)type, declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type category: " + type.getTypeCategory());
            }
        }
    }

    private void marshalSimpleType(String elementUri, String elementLocal, XSSimpleTypeDefinition type, boolean declareNs) {
        String marshalled;
        boolean genPrefix;
        AttributesImpl attrs = null;
        String prefix = (String)this.prefixByUri.get(elementUri);
        boolean bl = genPrefix = prefix == null && elementUri != null && elementUri.length() > 0;
        if (genPrefix) {
            prefix = "ns_" + elementLocal;
        }
        Object value = this.stack.peek();
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) {
            String typeName = type.getName();
            if ("QName".equals(typeName) || "NOTATION".equals(typeName)) {
                QName qNameValue = (QName)value;
                String prefixValue = qNameValue.getPrefix();
                if ((elementUri != null && !qNameValue.getNamespaceURI().equals(elementUri) || elementUri == null && qNameValue.getNamespaceURI().length() > 0) && (prefixValue.equals(prefix) || prefixValue.length() == 0 && prefix == null)) {
                    prefixValue = prefixValue + 'x';
                    value = new QName(qNameValue.getNamespaceURI(), qNameValue.getLocalPart(), prefixValue);
                }
                attrs = new AttributesImpl(1);
                attrs.add(null, prefixValue, prefixValue.length() == 0 ? "xmlns" : "xmlns:" + prefixValue, null, qNameValue.getNamespaceURI());
            }
            marshalled = SimpleTypeBindings.marshal(typeName, value, null);
        } else {
            marshalled = value.toString();
        }
        if (declareNs && !this.prefixByUri.isEmpty()) {
            if (attrs == null) {
                attrs = new AttributesImpl(this.prefixByUri.size());
            }
            this.declareNs(attrs);
        }
        if (genPrefix) {
            if (attrs == null) {
                attrs = new AttributesImpl(1);
            }
            attrs.add(null, prefix, "xmlns:" + prefix, null, elementUri);
        }
        String qName = XercesXsMarshaller.createQName(prefix, elementLocal);
        this.content.startElement(elementUri, elementLocal, qName, attrs);
        this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
        this.content.endElement(elementUri, elementLocal, qName);
    }

    private void marshalComplexType(String elementNsUri, String elementLocalName, XSComplexTypeDefinition type, boolean declareNs) {
        boolean genPrefix;
        AttributesImpl attrs;
        XSParticle particle = type.getParticle();
        XSObjectList attributeUses = type.getAttributeUses();
        int attrsTotal = declareNs ? this.prefixByUri.size() + attributeUses.getLength() : attributeUses.getLength();
        AttributesImpl attributesImpl = attrs = attrsTotal > 0 ? new AttributesImpl(attrsTotal) : null;
        if (declareNs && !this.prefixByUri.isEmpty()) {
            this.declareNs(attrs);
        }
        for (int i = 0; i < attributeUses.getLength(); ++i) {
            XSAttributeUse attrUse = (XSAttributeUse)attributeUses.item(i);
            XSAttributeDeclaration attrDec = attrUse.getAttrDeclaration();
            Object attrValue = this.provider.getAttributeValue(this.stack.peek(), null, attrDec.getNamespace(), attrDec.getName());
            if (attrValue == null) continue;
            attrs.add(attrDec.getNamespace(), attrDec.getName(), attrDec.getName(), attrDec.getTypeDefinition().getName(), attrValue.toString());
        }
        String prefix = (String)this.prefixByUri.get(elementNsUri);
        boolean bl = genPrefix = prefix == null && elementNsUri != null && elementNsUri.length() > 0;
        if (genPrefix) {
            prefix = "ns_" + elementLocalName;
            this.prefixByUri.put(elementNsUri, prefix);
            if (attrs == null) {
                attrs = new AttributesImpl(1);
            }
            attrs.add(null, prefix, "xmlns:" + prefix, null, elementNsUri);
        }
        String qName = XercesXsMarshaller.createQName(prefix, elementLocalName);
        this.content.startElement(elementNsUri, elementLocalName, qName, attrs);
        if (particle != null) {
            this.marshalParticle(particle, false);
        }
        this.content.endElement(elementNsUri, elementLocalName, qName);
        if (genPrefix) {
            this.prefixByUri.remove(elementNsUri);
        }
    }

    private boolean marshalParticle(XSParticle particle, boolean declareNs) {
        boolean marshalled;
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                marshalled = this.marshalModelGroup((XSModelGroup)term, declareNs);
                break;
            }
            case 9: {
                marshalled = this.marshalWildcard((XSWildcard)term, declareNs);
                break;
            }
            case 2: {
                XSElementDeclaration element = (XSElementDeclaration)term;
                marshalled = this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), particle.getMinOccurs(), particle.getMaxOccurs(), declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
        return marshalled;
    }

    private boolean marshalWildcard(XSWildcard wildcard, boolean declareNs) {
        boolean marshalled;
        Object o = this.stack.peek();
        AbstractMarshaller.ClassMapping mapping = this.getClassMapping(o.getClass());
        if (mapping == null) {
            throw new IllegalStateException("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o);
        }
        GenericObjectModelProvider parentProvider = this.provider;
        Object parentRoot = this.root;
        AbstractMarshaller.Stack parentStack = this.stack;
        this.root = o;
        this.provider = mapping.provider;
        this.stack = new AbstractMarshaller.StackImpl();
        XSModel model = Util.loadSchema(mapping.schemaUrl, this.schemaResolver);
        if (mapping.elementName != null) {
            XSElementDeclaration elDec = model.getElementDeclaration(mapping.elementName.getLocalPart(), mapping.elementName.getNamespaceURI());
            marshalled = this.marshalElement(elDec.getNamespace(), elDec.getName(), elDec.getTypeDefinition(), elDec.getNillable(), 1, 1, declareNs);
        } else if (mapping.typeName != null) {
            XSTypeDefinition typeDef = model.getTypeDefinition(mapping.typeName.getLocalPart(), mapping.typeName.getNamespaceURI());
            this.marshalElement(wildcard.getNamespace(), wildcard.getName(), typeDef, false, 1, 1, declareNs);
            marshalled = true;
        } else {
            throw new JBossXBRuntimeException("Class mapping for " + mapping.cls + " is associated with neither global element name nor global type name.");
        }
        this.root = parentRoot;
        this.provider = parentProvider;
        this.stack = parentStack;
        return marshalled;
    }

    private boolean marshalModelGroup(XSModelGroup modelGroup, boolean declareNs) {
        boolean marshalled;
        switch (modelGroup.getCompositor()) {
            case 3: {
                marshalled = this.marshalModelGroupAll(modelGroup.getParticles(), declareNs);
                break;
            }
            case 2: {
                marshalled = this.marshalModelGroupChoice(modelGroup.getParticles(), declareNs);
                break;
            }
            case 1: {
                marshalled = this.marshalModelGroupSequence(modelGroup.getParticles(), declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected compsitor: " + modelGroup.getCompositor());
            }
        }
        return marshalled;
    }

    private boolean marshalModelGroupAll(XSObjectList particles, boolean declareNs) {
        boolean marshalled = false;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled |= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    private boolean marshalModelGroupChoice(XSObjectList particles, boolean declareNs) {
        boolean marshalled = false;
        Content mainContent = this.content;
        for (int i = 0; i < particles.getLength() && !marshalled; ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            this.content = new Content();
            marshalled = this.marshalParticle(particle, declareNs);
        }
        if (marshalled) {
            mainContent.append(this.content);
        }
        this.content = mainContent;
        return marshalled;
    }

    private boolean marshalModelGroupSequence(XSObjectList particles, boolean declareNs) {
        boolean marshalled = true;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled &= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    private void declareNs(AttributesImpl attrs) {
        Iterator i = this.prefixByUri.entrySet().iterator();
        while (i.hasNext()) {
            String localName;
            Map.Entry entry = i.next();
            attrs.add(null, localName, (localName = (String)entry.getValue()) == null || localName.length() == 0 ? "xmlns" : "xmlns:" + localName, null, (String)entry.getKey());
        }
    }

    private static String createQName(String prefix, String local) {
        return prefix == null || prefix.length() == 0 ? local : prefix + ':' + local;
    }

    private static boolean isArrayWrapper(XSTypeDefinition type) {
        XSComplexTypeDefinition cType;
        XSParticle particle;
        boolean is = false;
        if (15 == type.getTypeCategory() && (particle = (cType = (XSComplexTypeDefinition)type).getParticle()) != null) {
            is = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
        }
        return is;
    }
}

