/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.util.Arrays;
import java.util.List;
import javax.ejb.AroundInvoke;
import javax.ejb.InvocationContext;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.Around;
import org.jboss.seam.annotations.Rollback;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.util.Transactions;

@Around(value={OutcomeInterceptor.class})
public class RollbackInterceptor
extends AbstractInterceptor {
    @AroundInvoke
    public Object rollbackIfNecessary(InvocationContext invocation) throws Exception {
        try {
            Object result = invocation.proceed();
            if (invocation.getMethod().isAnnotationPresent(Rollback.class)) {
                boolean isRollback;
                String[] outcomes = invocation.getMethod().getAnnotation(Rollback.class).ifOutcome();
                List<String> outcomeList = Arrays.asList(outcomes);
                boolean bl = isRollback = outcomes.length == 0 || result == null && outcomeList.contains("org.jboss.seam.outcome.null") || outcomeList.contains(result);
                if (isRollback) {
                    if (this.component.getType() == ComponentType.JAVA_BEAN) {
                        Transactions.setUserTransactionRollbackOnly();
                    } else {
                        Transactions.getEJBContext().setRollbackOnly();
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            if (this.component.getType() == ComponentType.JAVA_BEAN) {
                try {
                    Transactions.setUserTransactionRollbackOnly();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }
}

