/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import javax.ejb.EJBContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.seam.util.Naming;

public class Transactions {
    public static final String EJBCONTEXT_NAME = "java:comp.ejb3/EJBContext";
    private static String userTransactionName = "UserTransaction";
    private static final String STANDARD_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private static String transactionManagerName = "java:/TransactionManager";

    public static boolean isTransactionActive() throws SystemException, NamingException {
        return Transactions.getUserTransaction().getStatus() == 0;
    }

    public static boolean isTransactionActiveOrMarkedRollback() throws SystemException, NamingException {
        int status = Transactions.getUserTransaction().getStatus();
        return status == 0 || status == 1;
    }

    public static TransactionManager getTransactionManager() throws NamingException {
        return (TransactionManager)Naming.getInitialContext().lookup(transactionManagerName);
    }

    public static UserTransaction getUserTransaction() throws NamingException {
        try {
            return (UserTransaction)Naming.getInitialContext().lookup(userTransactionName);
        }
        catch (NameNotFoundException nnfe) {
            return (UserTransaction)Naming.getInitialContext().lookup(STANDARD_USER_TRANSACTION_NAME);
        }
    }

    public static EJBContext getEJBContext() throws NamingException {
        return (EJBContext)Naming.getInitialContext().lookup(EJBCONTEXT_NAME);
    }

    public static void setUserTransactionRollbackOnly() throws SystemException, NamingException {
        UserTransaction userTransaction = Transactions.getUserTransaction();
        if (userTransaction.getStatus() != 6) {
            userTransaction.setRollbackOnly();
        }
    }

    public static void registerSynchronization(Synchronization sync) throws SystemException, RollbackException, NamingException {
        if (Transactions.isTransactionActive()) {
            Transactions.getTransactionManager().getTransaction().registerSynchronization(sync);
        }
        if (!Transactions.isTransactionActiveOrMarkedRollback()) {
            throw new IllegalStateException("No active transaction");
        }
    }

    private Transactions() {
    }

    public static void setUserTransactionName(String userTransactionName) {
        Transactions.userTransactionName = userTransactionName;
    }

    public static String getUserTransactionName() {
        return userTransactionName;
    }
}

