/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private static Logger log = Logger.getLogger(DOMUtils.class);
    private static ThreadLocal documentThreadLocal = new ThreadLocal();
    private static ThreadLocal builderThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                this.setEntityResolver(documentBuilder);
                return documentBuilder;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException("Failed to create DocumentBuilder", parserConfigurationException);
            }
        }

        private void setEntityResolver(DocumentBuilder documentBuilder) {
            String[] stringArray = new String[]{"org.jboss.ws.core.utils.JBossWSEntityResolver", "org.jboss.util.xml.JBossEntityResolver"};
            EntityResolver entityResolver = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String string : stringArray) {
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    entityResolver = (EntityResolver)clazz.newInstance();
                }
                catch (Exception exception) {
                    log.debug((Object)("Cannot load: " + string));
                }
            }
            if (entityResolver != null) {
                documentBuilder.setEntityResolver(entityResolver);
            }
        }
    };

    public static void clearThreadLocals() {
        documentThreadLocal.remove();
        builderThreadLocal.remove();
    }

    private DOMUtils() {
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = (DocumentBuilder)builderThreadLocal.get();
        return documentBuilder;
    }

    public static Element parse(String string) throws IOException {
        try {
            return DOMUtils.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
        }
        catch (IOException iOException) {
            log.error((Object)("Cannot parse: " + string));
            throw iOException;
        }
    }

    public static Element parse(InputStream inputStream) throws IOException {
        try {
            Document document = DOMUtils.getDocumentBuilder().parse(inputStream);
            Element element = document.getDocumentElement();
            return element;
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
    }

    public static Element parse(InputSource inputSource) throws IOException {
        try {
            Document document = DOMUtils.getDocumentBuilder().parse(inputSource);
            Element element = document.getDocumentElement();
            return element;
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
    }

    public static Element createElement(String string) {
        Document document = DOMUtils.getOwnerDocument();
        log.trace((Object)("createElement {}" + string));
        return document.createElement(string);
    }

    public static Element createElement(String string, String string2) {
        Document document = DOMUtils.getOwnerDocument();
        log.trace((Object)("createElement {}" + string2 + ":" + string));
        return document.createElement(string2 + ":" + string);
    }

    public static Element createElement(String string, String string2, String string3) {
        Document document = DOMUtils.getOwnerDocument();
        if (string2 == null || string2.length() == 0) {
            log.trace((Object)("createElement {" + string3 + "}" + string));
            return document.createElementNS(string3, string);
        }
        log.trace((Object)("createElement {" + string3 + "}" + string2 + ":" + string));
        return document.createElementNS(string3, string2 + ":" + string);
    }

    public static Element createElement(QName qName) {
        return DOMUtils.createElement(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
    }

    public static Text createTextNode(String string) {
        Document document = DOMUtils.getOwnerDocument();
        return document.createTextNode(string);
    }

    public static QName getElementQName(Element element) {
        String string = element.getNodeName();
        return DOMUtils.resolveQName(element, string);
    }

    public static QName resolveQName(Element element, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = string;
        int n = string.indexOf(":");
        if (n > 0) {
            string2 = string.substring(0, n);
            string4 = string.substring(n + 1);
            if ("xmlns".equals(string2)) {
                string3 = "URI:XML_PREDEFINED_NAMESPACE";
            } else {
                Element element2 = element;
                while (string3.equals("") && element2 != null) {
                    string3 = element2.getAttribute("xmlns:" + string2);
                    if (!string3.equals("")) continue;
                    element2 = DOMUtils.getParentElement(element2);
                }
            }
            if (string3.equals("")) {
                throw new IllegalArgumentException("Cannot find namespace uri for: " + string);
            }
        } else {
            Element element3 = element;
            while (string3.equals("") && element3 != null) {
                string3 = element3.getAttribute("xmlns");
                if (!string3.equals("")) continue;
                element3 = DOMUtils.getParentElement(element3);
            }
        }
        QName qName = new QName(string3, string4, string2);
        return qName;
    }

    public static String getAttributeValue(Element element, String string) {
        return DOMUtils.getAttributeValue(element, new QName(string));
    }

    public static String getAttributeValue(Element element, QName qName) {
        String string = null;
        string = "".equals(qName.getNamespaceURI()) ? element.getAttribute(qName.getLocalPart()) : element.getAttributeNS(qName.getNamespaceURI(), qName.getLocalPart());
        if ("".equals(string)) {
            string = null;
        }
        return string;
    }

    public static QName getAttributeValueAsQName(Element element, String string) {
        return DOMUtils.getAttributeValueAsQName(element, new QName(string));
    }

    public static QName getAttributeValueAsQName(Element element, QName qName) {
        QName qName2 = null;
        String string = DOMUtils.getAttributeValue(element, qName);
        if (string != null) {
            qName2 = DOMUtils.resolveQName(element, string);
        }
        return qName2;
    }

    public static boolean getAttributeValueAsBoolean(Element element, String string) {
        return DOMUtils.getAttributeValueAsBoolean(element, new QName(string));
    }

    public static boolean getAttributeValueAsBoolean(Element element, QName qName) {
        String string = DOMUtils.getAttributeValue(element, qName);
        boolean bl = "true".equalsIgnoreCase(string) || "1".equalsIgnoreCase(string);
        return bl;
    }

    public static Integer getAttributeValueAsInteger(Element element, String string) {
        return DOMUtils.getAttributeValueAsInteger(element, new QName(string));
    }

    public static Integer getAttributeValueAsInteger(Element element, QName qName) {
        String string = DOMUtils.getAttributeValue(element, qName);
        return string != null ? new Integer(string) : null;
    }

    public static Map getAttributes(Element element) {
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getName();
            QName qName = DOMUtils.resolveQName(element, string);
            String string2 = attr.getNodeValue();
            hashMap.put(qName, string2);
        }
        return hashMap;
    }

    public static void copyAttributes(Element element, Element element2) {
        NamedNodeMap namedNodeMap = element2.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getNamespaceURI();
            String string2 = attr.getName();
            String string3 = attr.getNodeValue();
            if (string == null && string2.startsWith("xmlns")) {
                log.trace((Object)("Ignore attribute: [uri=" + string + ",qname=" + string2 + ",value=" + string3 + "]"));
                continue;
            }
            element.setAttributeNS(string, string2, string3);
        }
    }

    public static boolean hasChildElements(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Iterator getChildElements(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            arrayList.add(node2);
        }
        return arrayList.iterator();
    }

    public static String getTextContent(Node node) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            stringBuffer.append(node2.getNodeValue());
            bl = true;
        }
        return bl ? stringBuffer.toString() : null;
    }

    public static Element getFirstChildElement(Node node) {
        return DOMUtils.getFirstChildElementIntern(node, null);
    }

    public static Element getFirstChildElement(Node node, String string) {
        return DOMUtils.getFirstChildElementIntern(node, new QName(string));
    }

    public static Element getFirstChildElement(Node node, QName qName) {
        return DOMUtils.getFirstChildElementIntern(node, qName);
    }

    private static Element getFirstChildElementIntern(Node node, QName qName) {
        Element element = null;
        Iterator iterator = DOMUtils.getChildElementsIntern(node, qName);
        if (iterator.hasNext()) {
            element = (Element)iterator.next();
        }
        return element;
    }

    public static Iterator getChildElements(Node node, String string) {
        return DOMUtils.getChildElementsIntern(node, new QName(string));
    }

    public static Iterator getChildElements(Node node, QName qName) {
        return DOMUtils.getChildElementsIntern(node, qName);
    }

    private static Iterator getChildElementsIntern(Node node, QName qName) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (qName == null) {
                arrayList.add(node2);
                continue;
            }
            QName qName2 = qName.getNamespaceURI().length() > 0 ? new QName(node2.getNamespaceURI(), node2.getLocalName()) : new QName(node2.getLocalName());
            if (!qName2.equals(qName)) continue;
            arrayList.add(node2);
        }
        return arrayList.iterator();
    }

    public static Element getParentElement(Node node) {
        Node node2 = node.getParentNode();
        return node2 instanceof Element ? (Element)node2 : null;
    }

    public static Document getOwnerDocument() {
        Document document = (Document)documentThreadLocal.get();
        if (document == null) {
            document = DOMUtils.getDocumentBuilder().newDocument();
            documentThreadLocal.set(document);
        }
        return document;
    }

    public static Element sourceToElement(Source source) throws IOException {
        Element element;
        block9: {
            element = null;
            try {
                if (source instanceof StreamSource) {
                    StreamSource streamSource = (StreamSource)source;
                    InputStream inputStream = streamSource.getInputStream();
                    if (inputStream != null) {
                        element = DOMUtils.parse(inputStream);
                    } else {
                        Reader reader = streamSource.getReader();
                        element = DOMUtils.parse(new InputSource(reader));
                    }
                    break block9;
                }
                if (source instanceof DOMSource) {
                    DOMSource dOMSource = (DOMSource)source;
                    Node node = dOMSource.getNode();
                    if (node instanceof Element) {
                        element = (Element)node;
                        break block9;
                    }
                    if (node instanceof Document) {
                        element = ((Document)node).getDocumentElement();
                        break block9;
                    }
                    throw new RuntimeException("Unsupported Node type: " + node.getClass().getName());
                }
                if (source instanceof SAXSource) {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(source, new StreamResult(byteArrayOutputStream));
                    element = DOMUtils.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                    break block9;
                }
                throw new RuntimeException("Source type not implemented: " + source.getClass().getName());
            }
            catch (TransformerException transformerException) {
                IOException iOException = new IOException();
                iOException.initCause(transformerException);
                throw iOException;
            }
        }
        return element;
    }
}

