/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private PrintWriter out;
    private boolean canonical;
    private boolean prettyprint;
    private boolean writeXMLDeclaration;
    private String charsetName;
    private int prettyIndent;
    private boolean wroteXMLDeclaration;
    private Node rootNode;
    private boolean completeNamespaces = true;
    private String currentDefaultNamespace;

    public DOMWriter(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public DOMWriter(Writer writer, String string) {
        this.out = new PrintWriter(writer);
        this.charsetName = string;
        this.writeXMLDeclaration = true;
    }

    public DOMWriter(OutputStream outputStream) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public DOMWriter(OutputStream outputStream, String string) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(outputStream, string));
            this.charsetName = string;
            this.writeXMLDeclaration = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unsupported encoding: " + string);
        }
    }

    public static String printNode(Node node, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        new DOMWriter(stringWriter).setPrettyprint(bl).print(node);
        return stringWriter.toString();
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    public DOMWriter setCanonical(boolean bl) {
        this.canonical = bl;
        return this;
    }

    public DOMWriter setCompleteNamespaces(boolean bl) {
        this.completeNamespaces = bl;
        return this;
    }

    public boolean isPrettyprint() {
        return this.prettyprint;
    }

    public DOMWriter setPrettyprint(boolean bl) {
        this.prettyprint = bl;
        return this;
    }

    public boolean isWriteXMLDeclaration() {
        return this.writeXMLDeclaration;
    }

    public DOMWriter setWriteXMLDeclaration(boolean bl) {
        this.writeXMLDeclaration = bl;
        return this;
    }

    public void print(Node node) {
        this.rootNode = node;
        this.printInternal(node, false);
    }

    private void printInternal(Node node, boolean bl) {
        if (node == null) {
            return;
        }
        if (!this.wroteXMLDeclaration && this.writeXMLDeclaration && !this.canonical) {
            this.out.print("<?xml version='1.0'");
            if (this.charsetName != null) {
                this.out.print(" encoding='" + this.charsetName + "'");
            }
            this.out.print("?>");
            if (this.prettyprint) {
                this.out.println();
            }
            this.wroteXMLDeclaration = true;
        }
        short s = node.getNodeType();
        boolean bl2 = node.getChildNodes().getLength() > 0;
        String string = node.getNodeName();
        switch (s) {
            case 9: {
                Object object3 = node.getChildNodes();
                for (int i = 0; i < object3.getLength(); ++i) {
                    this.printInternal(object3.item(i), false);
                }
                this.out.flush();
                break;
            }
            case 1: {
                String string2;
                Object object;
                String string3;
                Object object2;
                Object object3 = (Element)node;
                if (this.prettyprint) {
                    for (int i = 0; i < this.prettyIndent; ++i) {
                        this.out.print(' ');
                    }
                    ++this.prettyIndent;
                }
                this.out.print('<');
                this.out.print(string);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                String string4 = node.getPrefix();
                String string5 = node.getNamespaceURI();
                if (string4 != null) {
                    object2 = this.getNamespaceURI(string4, (Element)object3, this.rootNode);
                    hashMap.put(string4, object2);
                }
                object2 = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < ((Attr[])object2).length; ++i) {
                    Object object4 = object2[i];
                    string3 = object4.getPrefix();
                    object = object4.getNodeName();
                    String string6 = DOMWriter.normalize(object4.getNodeValue(), this.canonical);
                    if (((String)object).equals("xmlns")) {
                        this.currentDefaultNamespace = string6;
                    }
                    if (string3 != null && !string3.equals("xmlns") && !string3.equals("xml")) {
                        String string7 = this.getNamespaceURI(string3, (Element)object3, this.rootNode);
                        hashMap.put(string3, string7);
                        if (((String)object).equals(string3 + ":type") && string6.indexOf(":") > 0) {
                            if (string7 == null) {
                                string7 = this.getNamespaceURI(string3, (Element)object3, null);
                            }
                            if ("http://www.w3.org/2001/XMLSchema-instance".equals(string7)) {
                                String string8 = string6.substring(0, string6.indexOf(":"));
                                String string9 = this.getNamespaceURI(string8, (Element)object3, this.rootNode);
                                hashMap.put(string8, string9);
                            }
                        }
                    }
                    this.out.print(" " + (String)object + "='" + string6 + "'");
                }
                if (this.completeNamespaces) {
                    for (Object object4 : hashMap.keySet()) {
                        string3 = (String)hashMap.get(object4);
                        if (string3 != null) continue;
                        string3 = this.getNamespaceURI((String)object4, (Element)object3, null);
                        this.out.print(" xmlns:" + (String)object4 + "='" + string3 + "'");
                    }
                }
                if (string4 == null && string5 != null && (string2 = object3.getAttribute("xmlns")).length() == 0 && !string5.equals(this.currentDefaultNamespace)) {
                    this.out.print(" xmlns='" + string5 + "'");
                    this.currentDefaultNamespace = string5;
                }
                if (bl2) {
                    this.out.print('>');
                }
                if (bl = this.isEndMarkerIndented(node)) {
                    this.out.print('\n');
                }
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    object = nodeList.item(i);
                    this.printInternal((Node)object, false);
                }
                break;
            }
            case 5: {
                Object object3;
                if (this.canonical) {
                    object3 = node.getChildNodes();
                    if (object3 == null) break;
                    int n = object3.getLength();
                    for (int i = 0; i < n; ++i) {
                        this.printInternal(object3.item(i), false);
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(string);
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(DOMWriter.normalize(node.getNodeValue(), this.canonical));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                Object object3 = DOMWriter.normalize(node.getNodeValue(), this.canonical);
                if (this.prettyprint && ((String)object3).trim().length() <= 0) break;
                this.out.print((String)object3);
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(string);
                Object object3 = node.getNodeValue();
                if (object3 != null && ((String)object3).length() > 0) {
                    this.out.print(' ');
                    this.out.print((String)object3);
                }
                this.out.print("?>");
                break;
            }
            case 8: {
                for (int i = 0; i < this.prettyIndent; ++i) {
                    this.out.print(' ');
                }
                this.out.print("<!--");
                Object object3 = node.getNodeValue();
                if (object3 != null) {
                    this.out.print((String)object3);
                }
                this.out.print("-->");
                if (!this.prettyprint) break;
                this.out.print('\n');
                break;
            }
        }
        if (s == 1) {
            if (this.prettyprint) {
                --this.prettyIndent;
            }
            if (!bl2) {
                this.out.print("/>");
            } else {
                if (bl) {
                    for (int i = 0; i < this.prettyIndent; ++i) {
                        this.out.print(' ');
                    }
                }
                this.out.print("</");
                this.out.print(string);
                this.out.print('>');
            }
            if (this.prettyIndent > 0) {
                this.out.print('\n');
            }
        }
        this.out.flush();
    }

    private String getNamespaceURI(String string, Element element, Node node) {
        Node node2 = element.getParentNode();
        String string2 = element.getAttribute("xmlns:" + string);
        if (string2.length() == 0 && element != node && node2 instanceof Element) {
            return this.getNamespaceURI(string, (Element)node2, node);
        }
        return string2.length() > 0 ? string2 : null;
    }

    private boolean isEndMarkerIndented(Node node) {
        if (this.prettyprint) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                return true;
            }
        }
        return false;
    }

    private Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    public static String normalize(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (bl) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block8;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

