/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public final class IOUtils {
    private IOUtils() {
    }

    public static Writer getCharsetFileWriter(File file, String string) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), string);
    }

    public static void copyStream(OutputStream outputStream, InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray);
            while (n > 0) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            inputStream.close();
        }
    }

    public static void copyReader(OutputStream outputStream, Reader reader) throws IOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            char[] cArray = new char[1024];
            int n = reader.read(cArray);
            while (n > 0) {
                outputStreamWriter.write(cArray, 0, n);
                n = reader.read(cArray);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            reader.close();
        }
    }

    public static byte[] convertToBytes(DataHandler dataHandler) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            dataHandler.writeTo((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new WebServiceException("Unable to convert DataHandler to byte[]: " + iOException.getMessage());
        }
    }

    public static InputStream transformReader(Reader reader) throws IOException {
        try {
            int n = 1024;
            char[] cArray = new char[n];
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = reader.read(cArray, 0, n);
            while (n2 > 0) {
                stringBuffer.append(cArray, 0, n2);
                n2 = reader.read(cArray, 0, n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
            return byteArrayInputStream;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            reader.close();
        }
    }

    public static File createTempDirectory() throws IOException {
        File file = null;
        try {
            SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
            ServerConfig serverConfig = ((ServerConfigFactory)sPIProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
            file = new File(serverConfig.getServerTempDir().getCanonicalPath() + "/jbossws");
            file.mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return file;
    }
}

