/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.panelstack;

import com.icesoft.faces.component.ext.taglib.Util;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;

public class PanelStack
extends HtmlPanelGroup {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.PanelStack";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.PanelStack";
    private String style = null;
    private String selectedPanel = null;
    private String styleClass = null;
    private String renderedOnUserRole = null;
    public static final String LAST_SELECTED_PANEL = "PanelStack-lastPanel";

    public PanelStack() {
        this.setRendererType("com.icesoft.faces.PanelStack");
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setSelectedPanel(String selectedPanel) {
        this.selectedPanel = selectedPanel;
    }

    public String getSelectedPanel() {
        if (this.selectedPanel != null) {
            return this.selectedPanel;
        }
        ValueBinding vb = this.getValueBinding("selectedPanel");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "icePnlStk", "styleClass");
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public String getRowClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Row");
    }

    public String getColumnClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Col");
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.selectedPanel, this.styleClass, this.style};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.selectedPanel = (String)values[1];
        this.styleClass = (String)values[2];
        this.style = (String)values[3];
    }

    public void applyPhase(FacesContext context, PhaseId phaseId) {
        if (context == null) {
            throw new NullPointerException("Null context in PanelTabSet");
        }
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            boolean changed;
            UIComponent childOrFacet = (UIComponent)it.next();
            String selectedPanel = this.getSelectedPanel();
            String lastSelectedPanel = (String)context.getExternalContext().getRequestMap().get(LAST_SELECTED_PANEL + this.getClientId(context));
            boolean bl = changed = lastSelectedPanel != null && !lastSelectedPanel.equals(selectedPanel);
            if (!childOrFacet.getId().equals(selectedPanel) || changed && phaseId == PhaseId.APPLY_REQUEST_VALUES) continue;
            this.applyPhase(context, childOrFacet, phaseId);
        }
    }

    public void applyPhase(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            component.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            component.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            component.processUpdates(context);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.decode(context);
        this.applyPhase(context, PhaseId.APPLY_REQUEST_VALUES);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.applyPhase(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.applyPhase(context, PhaseId.UPDATE_MODEL_VALUES);
    }
}

