/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromElementFactory;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.tree.IndexNode;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class DotNode
extends FromReferenceNode
implements DisplayableNode,
SelectExpression {
    public static boolean useThetaStyleImplicitJoins = false;
    public static boolean REGRESSION_STYLE_JOIN_SUPPRESSION = false;
    public static final IllegalCollectionDereferenceExceptionBuilder DEF_ILLEGAL_COLL_DEREF_EXCP_BUILDER;
    public static IllegalCollectionDereferenceExceptionBuilder ILLEGAL_COLL_DEREF_EXCP_BUILDER;
    private static final Log log;
    private static final int DEREF_UNKNOWN = 0;
    private static final int DEREF_ENTITY = 1;
    private static final int DEREF_COMPONENT = 2;
    private static final int DEREF_COLLECTION = 3;
    private static final int DEREF_PRIMITIVE = 4;
    private static final int DEREF_IDENTIFIER = 5;
    private static final int DEREF_JAVA_CONSTANT = 6;
    private String propertyName;
    private String path;
    private String propertyPath;
    private String[] columns;
    private int joinType = 0;
    private boolean fetch = false;
    private int dereferenceType = 0;
    private FromElement impliedJoin;

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    private String[] getColumns() throws QueryException {
        if (this.columns == null) {
            String tableAlias = this.getLhs().getFromElement().getTableAlias();
            this.columns = this.getFromElement().toColumns(tableAlias, this.propertyPath, false);
        }
        return this.columns;
    }

    public String getDisplayText() {
        StringBuffer buf = new StringBuffer();
        FromElement fromElement = this.getFromElement();
        buf.append("{propertyName=").append(this.propertyName);
        buf.append(",dereferenceType=").append(ASTPrinter.getConstantName(this.getClass(), this.dereferenceType));
        buf.append(",propertyPath=").append(this.propertyPath);
        buf.append(",path=").append(this.getPath());
        if (fromElement != null) {
            buf.append(",tableAlias=").append(fromElement.getTableAlias());
            buf.append(",className=").append(fromElement.getClassName());
            buf.append(",classAlias=").append(fromElement.getClassAlias());
        } else {
            buf.append(",no from element");
        }
        buf.append('}');
        return buf.toString();
    }

    public void resolveFirstChild() throws SemanticException {
        String propName;
        FromReferenceNode lhs = (FromReferenceNode)this.getFirstChild();
        SqlNode property = (SqlNode)lhs.getNextSibling();
        this.propertyName = propName = property.getText();
        if (this.propertyPath == null) {
            this.propertyPath = propName;
        }
        lhs.resolve(true, true, null, (AST)this);
        this.setFromElement(lhs.getFromElement());
        this.checkSubclassOrSuperclassPropertyReference(lhs, propName);
    }

    public void resolveInFunctionCall(boolean generateJoin, boolean implicitJoin) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type propertyType = this.prepareLhs();
        if (propertyType != null && propertyType.isCollectionType()) {
            this.resolveIndex(null);
        } else {
            this.resolveFirstChild();
            super.resolve(generateJoin, implicitJoin);
        }
    }

    public void resolveIndex(AST parent) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type propertyType = this.prepareLhs();
        this.dereferenceCollection((CollectionType)propertyType, true, true, null, parent);
    }

    public void resolve(boolean generateJoin, boolean implicitJoin, String classAlias, AST parent) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type propertyType = this.prepareLhs();
        if (propertyType == null) {
            if (parent == null) {
                this.getWalker().getLiteralProcessor().lookupConstant(this);
            }
            return;
        }
        if (propertyType.isComponentType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceComponent(parent);
            this.initText();
        } else if (propertyType.isEntityType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceEntity((EntityType)propertyType, implicitJoin, classAlias, generateJoin, parent);
            this.initText();
        } else if (propertyType.isCollectionType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceCollection((CollectionType)propertyType, implicitJoin, false, classAlias, parent);
        } else {
            if (!CollectionProperties.isAnyCollectionProperty(this.propertyName)) {
                this.checkLhsIsNotCollection();
            }
            this.dereferenceType = 4;
            this.initText();
        }
        this.setResolved();
    }

    private void initText() {
        String[] cols = this.getColumns();
        String text = StringHelper.join(", ", cols);
        if (cols.length > 1 && this.getWalker().isComparativeExpressionClause()) {
            text = "(" + text + ")";
        }
        this.setText(text);
    }

    private Type prepareLhs() throws SemanticException {
        FromReferenceNode lhs = this.getLhs();
        lhs.prepareForDot(this.propertyName);
        return this.getDataType();
    }

    private void dereferenceCollection(CollectionType collectionType, boolean implicitJoin, boolean indexed, String classAlias, AST parent) throws SemanticException {
        EntityPersister entityPersister;
        boolean isSizeProperty;
        this.dereferenceType = 3;
        String role = collectionType.getRole();
        boolean bl = isSizeProperty = this.getNextSibling() != null && CollectionProperties.isAnyCollectionProperty(this.getNextSibling().getText());
        if (isSizeProperty) {
            indexed = true;
        }
        QueryableCollection queryableCollection = this.getSessionFactoryHelper().requireQueryableCollection(role);
        String propName = this.getPath();
        FromClause currentFromClause = this.getWalker().getCurrentFromClause();
        if (this.getWalker().getStatementType() != 45 && indexed && classAlias == null) {
            String alias = this.getLhs().getFromElement().getQueryable().getTableName();
            this.columns = this.getFromElement().toColumns(alias, this.propertyPath, false, true);
        }
        FromElementFactory factory = new FromElementFactory(currentFromClause, this.getLhs().getFromElement(), propName, classAlias, this.getColumns(), implicitJoin);
        FromElement elem = factory.createCollection(queryableCollection, role, this.joinType, this.fetch, indexed);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceCollection() : Created new FROM element for " + propName + " : " + elem));
        }
        this.setImpliedJoin(elem);
        this.setFromElement(elem);
        if (isSizeProperty) {
            elem.setText("");
            elem.setUseWhereFragment(false);
        }
        if (!implicitJoin && (entityPersister = elem.getEntityPersister()) != null) {
            this.getWalker().addQuerySpaces(entityPersister.getQuerySpaces());
        }
        this.getWalker().addQuerySpaces(queryableCollection.getCollectionSpaces());
    }

    private void dereferenceEntity(EntityType entityType, boolean implicitJoin, String classAlias, boolean generateJoin, AST parent) throws SemanticException {
        boolean joinIsNeeded;
        this.checkForCorrelatedSubquery("dereferenceEntity");
        DotNode parentAsDotNode = null;
        String property = this.propertyName;
        if (this.isDotNode(parent)) {
            parentAsDotNode = (DotNode)parent;
            property = parentAsDotNode.propertyName;
            joinIsNeeded = generateJoin && !this.isReferenceToPrimaryKey(parentAsDotNode.propertyName, entityType);
        } else if (!this.getWalker().isSelectStatement()) {
            joinIsNeeded = false;
        } else if (REGRESSION_STYLE_JOIN_SUPPRESSION) {
            joinIsNeeded = generateJoin && (!this.getWalker().isInSelect() || !this.getWalker().isShallowQuery());
        } else {
            boolean bl = joinIsNeeded = generateJoin || this.getWalker().isInSelect() || this.getWalker().isInFrom();
        }
        if (joinIsNeeded) {
            this.dereferenceEntityJoin(classAlias, entityType, implicitJoin, parent);
        } else {
            this.dereferenceEntityIdentifier(property, parentAsDotNode);
        }
    }

    private boolean isDotNode(AST n) {
        return n != null && n.getType() == 15;
    }

    private void dereferenceEntityJoin(String classAlias, EntityType propertyType, boolean impliedJoin, AST parent) throws SemanticException {
        FromClause currentFromClause;
        FromElement elem;
        this.dereferenceType = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceEntityJoin() : generating join for " + this.propertyName + " in " + this.getFromElement().getClassName() + " " + (classAlias == null ? "{no alias}" : "(" + classAlias + ")") + " parent = " + ASTUtil.getDebugString(parent)));
        }
        String associatedEntityName = propertyType.getAssociatedEntityName();
        String tableAlias = this.getAliasGenerator().createName(associatedEntityName);
        String[] joinColumns = this.getColumns();
        String joinPath = this.getPath();
        if (impliedJoin && this.getWalker().isInFrom()) {
            this.joinType = this.getWalker().getImpliedJoinType();
        }
        if ((elem = (currentFromClause = this.getWalker().getCurrentFromClause()).findJoinByPath(joinPath)) == null) {
            JoinSequence joinSequence = this.getSessionFactoryHelper().createJoinSequence(impliedJoin, propertyType, tableAlias, this.joinType, joinColumns);
            FromElementFactory factory = new FromElementFactory(currentFromClause, this.getLhs().getFromElement(), joinPath, classAlias, joinColumns, impliedJoin);
            elem = factory.createEntityJoin(associatedEntityName, tableAlias, joinSequence, this.fetch, this.getWalker().isInFrom(), propertyType);
        } else {
            currentFromClause.addDuplicateAlias(classAlias, elem);
        }
        this.setImpliedJoin(elem);
        this.getWalker().addQuerySpaces(elem.getEntityPersister().getQuerySpaces());
        this.setFromElement(elem);
    }

    private void setImpliedJoin(FromElement elem) {
        DotNode dotLhs;
        this.impliedJoin = elem;
        if (this.getFirstChild().getType() == 15 && (dotLhs = (DotNode)this.getFirstChild()).getImpliedJoin() != null) {
            this.impliedJoin = dotLhs.getImpliedJoin();
        }
    }

    public FromElement getImpliedJoin() {
        return this.impliedJoin;
    }

    private boolean isReferenceToPrimaryKey(String propertyName, EntityType owningType) {
        EntityPersister persister = this.getSessionFactoryHelper().getFactory().getEntityPersister(owningType.getAssociatedEntityName());
        if (persister.getEntityMetamodel().hasNonIdentifierPropertyNamedId()) {
            return propertyName.equals(persister.getIdentifierPropertyName()) && owningType.isReferenceToPrimaryKey();
        }
        if ("id".equals(propertyName)) {
            return owningType.isReferenceToPrimaryKey();
        }
        String keyPropertyName = this.getSessionFactoryHelper().getIdentifierOrUniqueKeyPropertyName(owningType);
        return keyPropertyName != null && keyPropertyName.equals(propertyName) && owningType.isReferenceToPrimaryKey();
    }

    private void checkForCorrelatedSubquery(String methodName) {
        if (this.isCorrelatedSubselect() && log.isDebugEnabled()) {
            log.debug((Object)(methodName + "() : correlated subquery"));
        }
    }

    private boolean isCorrelatedSubselect() {
        return this.getWalker().isSubQuery() && this.getFromElement().getFromClause() != this.getWalker().getCurrentFromClause();
    }

    private void checkLhsIsNotCollection() throws SemanticException {
        if (this.getLhs().getDataType() != null && this.getLhs().getDataType().isCollectionType()) {
            throw ILLEGAL_COLL_DEREF_EXCP_BUILDER.buildIllegalCollectionDereferenceException(this.propertyName, this.getLhs());
        }
    }

    private void dereferenceComponent(AST parent) {
        this.dereferenceType = 2;
        this.setPropertyNameAndPath(parent);
    }

    private void dereferenceEntityIdentifier(String propertyName, DotNode dotParent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceShortcut() : property " + propertyName + " in " + this.getFromElement().getClassName() + " does not require a join."));
        }
        this.initText();
        this.setPropertyNameAndPath((AST)dotParent);
        if (dotParent != null) {
            dotParent.dereferenceType = 5;
            dotParent.setText(this.getText());
            dotParent.columns = this.getColumns();
        }
    }

    private void setPropertyNameAndPath(AST parent) {
        if (this.isDotNode(parent)) {
            DotNode dotNode = (DotNode)parent;
            AST lhs = dotNode.getFirstChild();
            AST rhs = lhs.getNextSibling();
            this.propertyName = rhs.getText();
            dotNode.propertyPath = this.propertyPath = this.propertyPath + "." + this.propertyName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unresolved property path is now '" + dotNode.propertyPath + "'"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("terminal propertyPath = [" + this.propertyPath + "]"));
        }
    }

    public Type getDataType() {
        if (super.getDataType() == null) {
            FromElement fromElement = this.getLhs().getFromElement();
            if (fromElement == null) {
                return null;
            }
            Type propertyType = fromElement.getPropertyType(this.propertyName, this.propertyPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDataType() : " + this.propertyPath + " -> " + propertyType));
            }
            super.setDataType(propertyType);
        }
        return super.getDataType();
    }

    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public FromReferenceNode getLhs() {
        FromReferenceNode lhs = (FromReferenceNode)this.getFirstChild();
        if (lhs == null) {
            throw new IllegalStateException("DOT node with no left-hand-side!");
        }
        return lhs;
    }

    public String getPath() {
        if (this.path == null) {
            FromReferenceNode lhs = this.getLhs();
            if (lhs == null) {
                this.path = this.getText();
            } else {
                SqlNode rhs = (SqlNode)lhs.getNextSibling();
                this.path = lhs.getPath() + "." + rhs.getOriginalText();
            }
        }
        return this.path;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    public void setScalarColumnText(int i) throws SemanticException {
        String[] sqlColumns = this.getColumns();
        ColumnHelper.generateScalarColumns(this, sqlColumns, i);
    }

    public void resolveSelectExpression() throws SemanticException {
        if (this.getWalker().isShallowQuery() || this.getWalker().getCurrentFromClause().isSubQuery()) {
            this.resolve(false, true);
        } else {
            this.resolve(true, false);
            Type type = this.getDataType();
            if (type.isEntityType()) {
                FromElement fromElement = this.getFromElement();
                fromElement.setIncludeSubclasses(true);
                if (useThetaStyleImplicitJoins) {
                    fromElement.getJoinSequence().setUseThetaStyle(true);
                    FromElement origin = fromElement.getOrigin();
                    if (origin != null) {
                        ASTUtil.makeSiblingOfParent((AST)origin, (AST)fromElement);
                    }
                }
            }
        }
        for (FromReferenceNode lhs = this.getLhs(); lhs != null; lhs = (FromReferenceNode)lhs.getFirstChild()) {
            this.checkSubclassOrSuperclassPropertyReference(lhs, lhs.getNextSibling().getText());
        }
    }

    public void setResolvedConstant(String text) {
        this.path = text;
        this.dereferenceType = 6;
        this.setResolved();
    }

    private boolean checkSubclassOrSuperclassPropertyReference(FromReferenceNode lhs, String propertyName) {
        FromElement source;
        if (lhs != null && !(lhs instanceof IndexNode) && (source = lhs.getFromElement()) != null) {
            source.handlePropertyBeingDereferenced(lhs.getDataType(), propertyName);
        }
        return false;
    }

    static {
        ILLEGAL_COLL_DEREF_EXCP_BUILDER = DEF_ILLEGAL_COLL_DEREF_EXCP_BUILDER = new IllegalCollectionDereferenceExceptionBuilder(){

            public QueryException buildIllegalCollectionDereferenceException(String propertyName, FromReferenceNode lhs) {
                String lhsPath = ASTUtil.getPathText((AST)lhs);
                return new QueryException("illegal attempt to dereference collection [" + lhsPath + "] with element property reference [" + propertyName + "]");
            }
        };
        log = LogFactory.getLog(DotNode.class);
    }

    public static interface IllegalCollectionDereferenceExceptionBuilder {
        public QueryException buildIllegalCollectionDereferenceException(String var1, FromReferenceNode var2);
    }
}

