/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;

public abstract class WebServerInvoker
extends ServerInvoker {
    public static String HEADER_SESSION_ID = "sessionId";
    public static String HEADER_SUBSYSTEM = "subsystem";

    public WebServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public WebServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public boolean isTransportBiDirectional() {
        return false;
    }

    protected String getDefaultDataType() {
        return "http";
    }

    protected InvocationRequest getInvocationRequest(Map metadata, Object obj) {
        InvocationRequest request = null;
        if (obj instanceof InvocationRequest) {
            request = (InvocationRequest)obj;
            if (request.getRequestPayload() == null) {
                request.setRequestPayload(metadata);
            } else {
                request.getRequestPayload().putAll(metadata);
            }
        } else {
            request = this.createNewInvocationRequest(metadata, obj);
        }
        return request;
    }

    public UnMarshaller getUnMarshaller() {
        UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), this.getClass().getClassLoader());
        if (unmarshaller == null) {
            unmarshaller = MarshalFactory.getUnMarshaller(this.getDataType(), this.getSerializationType());
        }
        return unmarshaller;
    }

    public Marshaller getMarshaller() {
        Marshaller marshaller = MarshalFactory.getMarshaller(this.getLocator(), this.getClass().getClassLoader());
        if (marshaller == null) {
            marshaller = MarshalFactory.getMarshaller(this.getDataType(), this.getSerializationType());
        }
        return marshaller;
    }

    protected InvocationRequest createNewInvocationRequest(Map metadata, Object payload) {
        String sessionId = this.getSessionId(metadata);
        String subSystem = (String)metadata.get(HEADER_SUBSYSTEM);
        InvocationRequest request = new InvocationRequest(sessionId, subSystem, payload, metadata, null, null);
        request.setReturnPayload(new HashMap());
        return request;
    }

    protected String getSessionId(Map metadata) {
        String sessionId = (String)metadata.get(HEADER_SESSION_ID);
        if (sessionId == null || sessionId.length() == 0) {
            String userAgent = (String)metadata.get("User-Agent");
            String host = (String)metadata.get("Host");
            String idSeed = userAgent + ":" + host;
            sessionId = Integer.toString(idSeed.hashCode());
        }
        return sessionId;
    }

    protected int getContentLength(Object response) throws IOException {
        if (response != null) {
            if (response instanceof String) {
                return ((String)response).length();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(response);
            oos.flush();
            bos.flush();
            byte[] buffer = bos.toByteArray();
            return buffer.length;
        }
        return 0;
    }
}

