/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.types.Include;
import org.jboss.ant.types.Pattern;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.SourceSink;
import org.jboss.ant.types.build.Artifact;
import org.jboss.ant.types.component.GeneratedSourceDefinition;
import org.jboss.ant.types.component.SourceDefinition;
import org.jboss.ant.util.AttributeUtil;

public abstract class MacroUtil {
    public static RuntimeConfigurable createMacro(String name, Project project, Target target) {
        UnknownElement element = new UnknownElement(name);
        RuntimeConfigurable rc = new RuntimeConfigurable((Object)element, name);
        element.setRuntimeConfigurableWrapper(rc);
        element.setNamespace("");
        element.setTaskName(name);
        element.setTaskType(name);
        MacroUtil.initTask((Task)element, project, target);
        return rc;
    }

    public static void configure(RuntimeConfigurable rc, DynamicType taskDefinition, Object dataType, Project project, Target target) {
        String text = taskDefinition.getText();
        if (text != null) {
            rc.addText(AttributeUtil.replace(dataType, text));
        }
        Hashtable attributes = taskDefinition.getAttributes();
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = AttributeUtil.replace(dataType, (String)attributes.get(key));
            rc.setAttribute(key, value);
        }
        Vector children = taskDefinition.getElements();
        int i2 = 0;
        while (i2 < children.size()) {
            Set set;
            DynamicType child = (DynamicType)((Object)children.get(i2));
            if ("output".equals(child.getId())) {
                MacroUtil.appendFileSet(dataType, rc, project, target);
            } else if ("pathelements".equals(child.getId())) {
                set = new HashSet();
                MacroUtil.getPathElements(set, dataType, true);
                MacroUtil.appendPaths(set, rc, project, target);
            } else if ("buildpathelements".equals(child.getId())) {
                set = new HashSet();
                MacroUtil.getBuildPathElements(set, dataType, true);
                MacroUtil.appendPaths(set, rc, project, target);
            } else if ("filesets".equals(child.getId())) {
                set = MacroUtil.getFileSets(dataType);
                MacroUtil.appendPaths(set, rc, project, target);
            } else if ("sourcepaths".equals(child.getId())) {
                set = new HashSet();
                MacroUtil.getSourcePaths(set, dataType);
                MacroUtil.appendPaths(set, rc, project, target);
            } else if ("sourcepathelements".equals(child.getId())) {
                set = new HashSet();
                MacroUtil.getSourcePathElements(set, dataType);
                MacroUtil.appendPaths(set, rc, project, target);
            } else if ("srcelements".equals(child.getId())) {
                set = new HashSet();
                MacroUtil.getSourceElements(set, dataType);
                MacroUtil.appendPaths(set, rc, project, target);
            } else {
                RuntimeConfigurable childrc = MacroUtil.createChild(rc, child.getId(), project, target);
                MacroUtil.configure(childrc, child, dataType, project, target);
            }
            ++i2;
        }
    }

    protected static void initTask(Task task, Project project, Target target) {
        task.setProject(project);
        task.setOwningTarget(target);
        task.init();
    }

    public static String dumpMacro(UnknownElement element) {
        StringBuffer buffer = new StringBuffer();
        MacroUtil.dumpElement(buffer, element, 0);
        return buffer.toString();
    }

    private MacroUtil() {
    }

    protected static void appendPaths(Set set, RuntimeConfigurable rc, Project project, Target target) {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            PathDescription pd = (PathDescription)i.next();
            pd.appendPath(rc, project, target);
        }
    }

    protected static void appendFileSet(Object dataType, RuntimeConfigurable rc, Project project, Target target) {
        PathDescription pd = MacroUtil.getFileSet(dataType);
        pd.appendPath(rc, project, target);
    }

    protected static PathDescription getFileSet(Object dataType) {
        if (dataType instanceof Source) {
            Source source = (Source)((Object)dataType);
            File file = source.getOutput();
            if (file.isDirectory()) {
                return new DirectoryFileSet(file.toString(), null, null);
            }
            return new FileFileSet(file.toString(), null);
        }
        throw new BuildException("Not a Source " + dataType);
    }

    protected static void getPathElements(Set set, Object dataType, boolean output) {
        if (dataType instanceof SourceSink) {
            SourceSink sink = (SourceSink)((Object)dataType);
            if (output) {
                File file = sink.getOutput();
                set.add(new PathElement(file.toString()));
            }
            int j = 0;
            while (j < sink.getSize()) {
                Include include = sink.getInclude(j);
                List sources = include.getSources();
                int k = 0;
                while (k < sources.size()) {
                    Source source = (Source)((Object)sources.get(k));
                    if (source instanceof SourceDefinition || source instanceof Artifact) {
                        File file = source.getOutput();
                        set.add(new PathElement(file.toString()));
                        if (source instanceof SourceDefinition) {
                            MacroUtil.getPathElements(set, (Object)source, false);
                        }
                        if (source instanceof Artifact) {
                            MacroUtil.getArtifactClassPath(set, (Artifact)source);
                        }
                    }
                    ++k;
                }
                ++j;
            }
        } else {
            throw new BuildException("Not a SourceSink " + dataType);
        }
    }

    protected static void getBuildPathElements(Set set, Object dataType, boolean output) {
        if (dataType instanceof SourceSink) {
            SourceSink sink = (SourceSink)((Object)dataType);
            if (output) {
                File file = sink.getOutput();
                set.add(new PathElement(file.toString()));
            }
            int j = 0;
            while (j < sink.getSize()) {
                Include include = sink.getInclude(j);
                List sources = include.getSources();
                int k = 0;
                while (k < sources.size()) {
                    Source source = (Source)((Object)sources.get(k));
                    if (source instanceof SourceDefinition || source instanceof Artifact) {
                        File file = source.getOutput();
                        set.add(new PathElement(file.toString()));
                    }
                    ++k;
                }
                ++j;
            }
        } else {
            throw new BuildException("Not a SourceSink " + dataType);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void getArtifactClassPath(Set set, Artifact artifact) {
        if (!"jar".equals(artifact.getArtifactType().getId())) return;
        File file = artifact.getOutput();
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Manifest manifest = jarFile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                String classPath = attributes.getValue(Attributes.Name.CLASS_PATH);
                if (classPath != null) {
                    StringTokenizer tokenizer = new StringTokenizer(classPath);
                    while (tokenizer.hasMoreTokens()) {
                        String id = tokenizer.nextToken();
                        Object reference = artifact.getProject().getReference(id);
                        if (reference == null) {
                            artifact.log("Unable to locate '" + id + "' in Class-Path of " + artifact.getId());
                        }
                        if (!(reference instanceof Artifact)) continue;
                        Artifact referenced = (Artifact)((Object)reference);
                        set.add(new PathElement(referenced.getOutput().toString()));
                        MacroUtil.getArtifactClassPath(set, referenced);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                jarFile.close();
                throw throwable;
            }
            {
                Object var11_14 = null;
                jarFile.close();
                return;
            }
        }
        catch (IOException e) {
            artifact.log("IOException reading manifest: " + e, 1);
        }
    }

    protected static Set getFileSets(Object dataType) {
        if (dataType instanceof SourceSink) {
            HashSet<PathDescription> set = new HashSet<PathDescription>();
            SourceSink sink = (SourceSink)((Object)dataType);
            int j = 0;
            while (j < sink.getSize()) {
                Include include = sink.getInclude(j);
                List files = include.getFiles();
                int k = 0;
                while (k < files.size()) {
                    File file = (File)files.get(k);
                    if (file.isDirectory()) {
                        set.add(new DirectoryFileSet(file.toString(), include.getPrefix(), include.getIncludes(), include.getExcludes()));
                    } else if (include.getIncludes().size() > 0 || include.getExcludes().size() > 0) {
                        set.add(new ArchiveFileSet(file.toString(), include.getIncludes(), include.getExcludes()));
                    } else {
                        set.add(new FileFileSet(file.toString(), include.getPrefix()));
                    }
                    ++k;
                }
                ++j;
            }
            return set;
        }
        throw new BuildException("Not a SourceSink " + dataType);
    }

    protected static void getSourcePaths(Set set, Object dataType) {
        if (dataType instanceof SourceSink) {
            SourceSink sink = (SourceSink)((Object)dataType);
            int j = 0;
            while (j < sink.getSize()) {
                Include include = sink.getInclude(j);
                List sources = include.getSources();
                int k = 0;
                while (k < sources.size()) {
                    Source source = (Source)((Object)sources.get(k));
                    if (source instanceof SourceDefinition) {
                        SourceDefinition definition = (SourceDefinition)source;
                        set.add(new PathElement(definition.getSourcePath()));
                    }
                    ++k;
                }
                ++j;
            }
        } else {
            throw new BuildException("Not a SourceSink " + dataType);
        }
    }

    protected static void getSourceElements(Set set, Object dataType) {
        if (dataType instanceof SourceDefinition) {
            SourceDefinition source = (SourceDefinition)((Object)dataType);
            int j = 0;
            while (j < source.getSize()) {
                Include include = source.getInclude(j);
                List sources = include.getSources();
                int k = 0;
                while (k < sources.size()) {
                    Source includedSource = (Source)((Object)sources.get(k));
                    if (includedSource instanceof GeneratedSourceDefinition) {
                        GeneratedSourceDefinition genSrcDef = (GeneratedSourceDefinition)includedSource;
                        set.add(new SrcElement(genSrcDef.getOutput().getPath()));
                    }
                    ++k;
                }
                ++j;
            }
        } else {
            throw new BuildException("Not a SourceDefinition " + dataType);
        }
    }

    protected static void getSourcePathElements(Set set, Object dataType) {
        if (dataType instanceof SourceSink) {
            SourceSink sink = (SourceSink)((Object)dataType);
            int j = 0;
            while (j < sink.getSize()) {
                Include include = sink.getInclude(j);
                List sources = include.getSources();
                int k = 0;
                while (k < sources.size()) {
                    Source source = (Source)((Object)sources.get(k));
                    if (source instanceof SourceDefinition) {
                        SourceDefinition definition = (SourceDefinition)source;
                        MacroUtil.getPathElements(set, (Object)definition, false);
                    }
                    ++k;
                }
                ++j;
            }
        } else {
            throw new BuildException("Not a SourceSink " + dataType);
        }
    }

    protected static void appendIncludesExcludes(RuntimeConfigurable parent, Vector includes, Vector excludes, Project project, Target target) {
        RuntimeConfigurable rc;
        int i;
        if (includes != null && includes.size() > 0) {
            i = 0;
            while (i < includes.size()) {
                Pattern theInclude = (Pattern)((Object)includes.get(i));
                rc = MacroUtil.createChild(parent, "include", project, target);
                rc.setAttribute("name", theInclude.getPattern());
                ++i;
            }
        }
        if (excludes != null && excludes.size() > 0) {
            i = 0;
            while (i < excludes.size()) {
                Pattern theExclude = (Pattern)((Object)excludes.get(i));
                rc = MacroUtil.createChild(parent, "exclude", project, target);
                rc.setAttribute("name", theExclude.getPattern());
                ++i;
            }
        }
    }

    protected static RuntimeConfigurable createChild(RuntimeConfigurable parent, String name, Project project, Target target) {
        RuntimeConfigurable rc = MacroUtil.createMacro(name, project, target);
        parent.addChild(rc);
        ((UnknownElement)parent.getProxy()).addChild((UnknownElement)rc.getProxy());
        return rc;
    }

    protected static void dumpElement(StringBuffer buffer, UnknownElement element, int indent) {
        MacroUtil.dumpIndent(buffer, indent);
        buffer.append("<").append(element.getTag());
        MacroUtil.dumpAttributes(buffer, element);
        String text = element.getRuntimeConfigurableWrapper().getText().toString().trim();
        List children = element.getChildren();
        if (children != null || text.length() > 0) {
            buffer.append(">");
            if (text.length() > 0) {
                buffer.append(text);
            }
            if (children != null) {
                MacroUtil.dumpChildren(buffer, element, indent);
                MacroUtil.dumpIndent(buffer, indent);
            }
            buffer.append("</").append(element.getTag()).append('>');
        } else {
            buffer.append("/>");
        }
    }

    protected static void dumpAttributes(StringBuffer buffer, UnknownElement element) {
        RuntimeConfigurable rc = element.getRuntimeConfigurableWrapper();
        Hashtable attributes = rc.getAttributeMap();
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            buffer.append(' ').append(key).append("=\"").append(attributes.get(key)).append("\"");
        }
    }

    protected static void dumpChildren(StringBuffer buffer, UnknownElement element, int indent) {
        List list = element.getChildren();
        int i = 0;
        while (i < list.size()) {
            UnknownElement child = (UnknownElement)list.get(i);
            MacroUtil.dumpElement(buffer, child, indent + 1);
            ++i;
        }
    }

    protected static void dumpIndent(StringBuffer buffer, int indent) {
        buffer.append('\n');
        int i = 0;
        while (i < indent) {
            buffer.append("  ");
            ++i;
        }
    }

    protected static abstract class PathDescription {
        protected PathDescription() {
        }

        public abstract void appendPath(RuntimeConfigurable var1, Project var2, Target var3);

        public boolean equalsVector(Vector one, Vector two) {
            if (one == null && two == null) {
                return true;
            }
            if (one == null && two != null) {
                return false;
            }
            return one.equals(two);
        }
    }

    protected static class DirectoryFileSet
    extends PathDescription {
        private String directory;
        private String prefix;
        private Vector includes;
        private Vector excludes;

        public DirectoryFileSet(String directory, Vector includes, Vector excludes) {
            this.directory = directory;
            this.includes = includes;
            this.excludes = excludes;
        }

        public DirectoryFileSet(String directory, String prefix, Vector includes, Vector excludes) {
            this.directory = directory;
            this.prefix = prefix;
            this.includes = includes;
            this.excludes = excludes;
        }

        public void appendPath(RuntimeConfigurable rc, Project project, Target target) {
            RuntimeConfigurable fileSet = null;
            if (this.prefix == null) {
                fileSet = MacroUtil.createChild(rc, "fileset", project, target);
            } else {
                fileSet = MacroUtil.createChild(rc, "zipfileset", project, target);
                fileSet.setAttribute("prefix", this.prefix);
            }
            fileSet.setAttribute("dir", this.directory);
            MacroUtil.appendIncludesExcludes(fileSet, this.includes, this.excludes, project, target);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof DirectoryFileSet)) {
                return false;
            }
            DirectoryFileSet other = (DirectoryFileSet)object;
            if (!this.directory.equals(other.directory)) {
                return false;
            }
            return this.equalsVector(this.includes, other.includes) && this.equalsVector(this.excludes, other.excludes);
        }

        public int hashCode() {
            return this.directory.hashCode();
        }
    }

    protected static class ArchiveFileSet
    extends PathDescription {
        private String archive;
        private Vector includes;
        private Vector excludes;

        public ArchiveFileSet(String archive, Vector includes, Vector excludes) {
            this.archive = archive;
            this.includes = includes;
            this.excludes = excludes;
        }

        public void appendPath(RuntimeConfigurable rc, Project project, Target target) {
            RuntimeConfigurable fileSet = MacroUtil.createChild(rc, "zipfileset", project, target);
            fileSet.setAttribute("src", this.archive);
            MacroUtil.appendIncludesExcludes(fileSet, this.includes, this.excludes, project, target);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ArchiveFileSet)) {
                return false;
            }
            ArchiveFileSet other = (ArchiveFileSet)object;
            if (!this.archive.equals(other.archive)) {
                return false;
            }
            return this.equalsVector(this.includes, other.includes) && this.equalsVector(this.excludes, other.excludes);
        }

        public int hashCode() {
            return this.archive.hashCode();
        }
    }

    protected static class FileFileSet
    extends PathDescription {
        private String file;
        private String prefix;

        public FileFileSet(String file, String prefix) {
            this.file = file;
            this.prefix = prefix;
        }

        public void appendPath(RuntimeConfigurable rc, Project project, Target target) {
            RuntimeConfigurable fileSet = null;
            if (this.prefix == null) {
                fileSet = MacroUtil.createChild(rc, "fileset", project, target);
            } else {
                fileSet = MacroUtil.createChild(rc, "zipfileset", project, target);
                fileSet.setAttribute("prefix", this.prefix);
            }
            fileSet.setAttribute("file", this.file);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof FileFileSet)) {
                return false;
            }
            FileFileSet other = (FileFileSet)object;
            return this.file.equals(other.file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }

    protected static class PathElement
    extends PathDescription {
        private String location;

        public PathElement(String location) {
            this.location = location;
        }

        public void appendPath(RuntimeConfigurable rc, Project project, Target target) {
            RuntimeConfigurable pathElement = MacroUtil.createChild(rc, "pathelement", project, target);
            pathElement.setAttribute("location", this.location);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PathElement)) {
                return false;
            }
            PathElement other = (PathElement)object;
            return this.location.equals(other.location);
        }

        public int hashCode() {
            return this.location.hashCode();
        }
    }

    protected static class SrcElement
    extends PathDescription {
        private String sourceDir;

        public SrcElement(String sourceDir) {
            this.sourceDir = sourceDir;
        }

        public void appendPath(RuntimeConfigurable rc, Project project, Target target) {
            RuntimeConfigurable pathElement = MacroUtil.createChild(rc, "src", project, target);
            pathElement.setAttribute("path", this.sourceDir);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof SrcElement)) {
                return false;
            }
            SrcElement other = (SrcElement)object;
            return this.sourceDir.equals(other.sourceDir);
        }

        public int hashCode() {
            return this.sourceDir.hashCode();
        }
    }
}

