/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.ScrollableResults;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.query.QueryTranslator;
import cirrus.hibernate.type.Type;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ScrollableResultsImpl
implements ScrollableResults {
    private final ResultSet rs;
    private final SessionImplementor sess;
    private final Type[] types;
    private final boolean single;
    private final String[][] names;

    public boolean scroll(int i) throws SQLException, HibernateException {
        return this.rs.relative(i);
    }

    public boolean first() throws SQLException, HibernateException {
        return this.rs.first();
    }

    public boolean last() throws SQLException, HibernateException {
        return this.rs.last();
    }

    public boolean next() throws SQLException, HibernateException {
        return this.rs.next();
    }

    public boolean previous() throws SQLException, HibernateException {
        return this.rs.previous();
    }

    public Object[] get() throws SQLException, HibernateException {
        Object[] row = new Object[this.types.length];
        int i = 0;
        while (i < this.types.length) {
            row[i] = this.types[i].nullSafeGet(this.rs, this.names[i], this.sess, null);
            ++i;
        }
        return row;
    }

    public Object get(int col) throws SQLException, HibernateException {
        return this.types[col].nullSafeGet(this.rs, this.names[col], this.sess, null);
    }

    public ScrollableResultsImpl(ResultSet rs, SessionImplementor sess, Type[] types) throws HibernateException, SQLException {
        this.rs = rs;
        this.sess = sess;
        this.types = types;
        this.single = types.length == 1;
        this.names = new String[types.length][];
        int i = 0;
        while (i < types.length) {
            int span = types[i].getColumnSpan(sess.getFactory());
            this.names[i] = new String[span];
            int j = 0;
            while (j < span) {
                this.names[i][j] = QueryTranslator.scalarName(i, j);
                ++j;
            }
            ++i;
        }
    }

    public BigDecimal getBigDecimal(int col) throws SQLException, HibernateException {
        return (BigDecimal)this.get(col);
    }

    public byte[] getBinary(int col) throws SQLException, HibernateException {
        return (byte[])this.get(col);
    }

    public Blob getBlob(int col) throws SQLException, HibernateException {
        return (Blob)this.get(col);
    }

    public Clob getClob(int col) throws SQLException, HibernateException {
        return (Clob)this.get(col);
    }

    public Boolean getBoolean(int col) throws SQLException, HibernateException {
        return (Boolean)this.get(col);
    }

    public Byte getByte(int col) throws SQLException, HibernateException {
        return (Byte)this.get(col);
    }

    public Character getCharacter(int col) throws SQLException, HibernateException {
        return (Character)this.get(col);
    }

    public Date getDate(int col) throws SQLException, HibernateException {
        return (Date)this.get(col);
    }

    public Calendar getCalendar(int col) throws SQLException, HibernateException {
        return (Calendar)this.get(col);
    }

    public Double getDouble(int col) throws SQLException, HibernateException {
        return (Double)this.get(col);
    }

    public Float getFloat(int col) throws SQLException, HibernateException {
        return (Float)this.get(col);
    }

    public Integer getInteger(int col) throws SQLException, HibernateException {
        return (Integer)this.get(col);
    }

    public Long getLong(int col) throws SQLException, HibernateException {
        return (Long)this.get(col);
    }

    public Short getShort(int col) throws SQLException, HibernateException {
        return (Short)this.get(col);
    }

    public String getString(int col) throws SQLException, HibernateException {
        return (String)this.get(col);
    }

    public void afterLast() throws SQLException, HibernateException {
        this.rs.afterLast();
    }

    public void beforeFirst() throws SQLException, HibernateException {
        this.rs.beforeFirst();
    }

    public void close() throws SQLException, HibernateException {
        this.rs.close();
    }

    public Locale getLocale(int col) throws SQLException, HibernateException {
        return (Locale)this.get(col);
    }

    public TimeZone getTimeZone(int col) throws SQLException, HibernateException {
        return (TimeZone)this.get(col);
    }

    public Type getType(int i) {
        return this.types[i];
    }
}

