/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.invocation.InvocationHandler;

public class DefaultLifecycleHandler
implements LifecycleHandler {
    protected final Logger log = Logger.getLogger(this.getClass());

    public void create(Endpoint ep) {
        this.log.debug((Object)("Create: " + ep.getName()));
        InvocationHandler invHandler = ep.getInvocationHandler();
        if (invHandler == null) {
            throw new IllegalStateException("Invocation handler not available");
        }
        invHandler.init(ep);
        ep.setState(Endpoint.EndpointState.CREATED);
    }

    public void start(Endpoint ep) {
        this.log.debug((Object)("Start: " + ep.getName()));
        Endpoint.EndpointState state = ep.getState();
        if (state == Endpoint.EndpointState.UNDEFINED || state == Endpoint.EndpointState.DESTROYED) {
            this.log.error((Object)("Cannot start endpoint in state: " + state));
        } else {
            if (ep.getEndpointMetrics() != null) {
                ep.getEndpointMetrics().start();
            }
            ep.setState(Endpoint.EndpointState.STARTED);
        }
    }

    public void stop(Endpoint ep) {
        this.log.debug((Object)("Stop: " + ep.getName()));
        Endpoint.EndpointState state = ep.getState();
        if (state != Endpoint.EndpointState.STARTED) {
            this.log.error((Object)("Cannot stop endpoint in state: " + state));
        } else {
            if (ep.getEndpointMetrics() != null) {
                ep.getEndpointMetrics().stop();
            }
            ep.setState(Endpoint.EndpointState.STOPPED);
        }
    }

    public void destroy(Endpoint ep) {
        this.log.debug((Object)("Destroy: " + ep.getName()));
        ep.setState(Endpoint.EndpointState.DESTROYED);
    }
}

