/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.List;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DecisionProbe;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.BitSet;
import org.antlr.test.ErrorQueue;
import org.antlr.test.unit.FailedAssertionException;
import org.antlr.test.unit.TestSuite;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarNonDeterminismMessage;
import org.antlr.tool.Message;

public class TestSemanticPredicates
extends TestSuite {
    public void testPredsButSyntaxResolves() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A | {p2}? B ;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testLL_1_Pred() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A | {p2}? A ;");
        String string = ".s0-A->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testLL_2_Pred() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A B | {p2}? A B ;");
        String string = ".s0-A->.s1\n.s1-B->.s2\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testPredicatedLoop() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : ( {p1}? A | {p2}? A )+;");
        String string = ".s0-A->.s2\n.s0-EOF->:s1=>3\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testPredicatedToStayInLoop() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : ( {p1}? A )+ (A)+;");
        String string = ".s0-A->.s1\n.s1-{!(p1)}?->:s2=>1\n.s1-{p1}?->:s3=>2\n";
    }

    public void testAndPredicates() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? {p1a}? A | {p2}? A ;");
        String string = ".s0-A->.s1\n.s1-{(p1&&p1a)}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testOrPredicates() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | {p2}? A ;\nb : {p1}? A | {p1a}? A ;");
        String string = ".s0-A->.s1\n.s1-{(p1||p1a)}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testIgnoresHoistingDepthGreaterThanZero() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A {p1}? | A {p2}?;");
        String string = ".s0-A->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "A", null, null, 2);
    }

    public void testHoist2() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | c ;\nb : {p1}? A ;\nc : {p2}? A ;\n");
        String string = ".s0-A->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testHoistCorrectContext() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | {p2}? ID ;\nb : {p1}? ID | INT ;\n");
        String string = ".s0-ID->.s1\n.s0-INT->:s4=>1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testDefaultPredNakedAltIsLast() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | ID ;\nb : {p1}? ID | INT ;\n");
        String string = ".s0-ID->.s1\n.s0-INT->:s4=>1\n.s1-{p1}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testDefaultPredNakedAltNotLast() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : ID | b ;\nb : {p1}? ID | INT ;\n");
        String string = ".s0-ID->.s1\n.s0-INT->:s4=>2\n.s1-{!(p1)}?->:s2=>1\n.s1-{p1}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testLeftRecursivePred() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\ns : a ;\na : {p1}? a | ID ;\n");
        String string = ".s0-ID->.s1\n.s1-{p1}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testIgnorePredFromLL2Alt() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A B | A C | {p2}? A | {p3}? A | A ;\n");
        String string = ".s0-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n.s1-{!((p3||p2))}?->:s6=>5\n.s1-{p2}?->:s4=>3\n.s1-{p3}?->:s5=>4\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testPredGets2SymbolSyntacticContext() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | A B | C ;\nb : {p1}? A B ;\n");
        String string = ".s0-A->.s1\n.s0-C->:s5=>3\n.s1-B->.s2\n.s2-{p1}?->:s3=>1\n.s2-{true}?->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testMatchesLongestThenTestPred() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | c ;\nb : {p}? A ;\nc : {q}? (A|B)+ ;");
        String string = ".s0-A->.s1\n.s0-B->:s4=>2\n.s1-{p}?->:s2=>1\n.s1-{q}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testLexerMatchesLongestThenTestPred() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : {p}? 'a' ;\nC : {q}? ('a'|'b')+ ;");
        String string = ".s0-'a'->.s1\n.s0-'b'->:s5=>2\n.s1-'a'..'b'->:s5=>2\n.s1-<EOT>->.s2\n.s2-{p}?->:s3=>1\n.s2-{q}?->:s4=>2\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, null, 0);
    }

    public void testGatedPred() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : {p}? => 'a' ;\nC : {q}? => ('a'|'b')+ ;");
        String string = ".s0-'a'&&{(q||p)}?->.s1\n.s0-'b'&&{q}?->:s5=>2\n.s1-'a'..'b'&&{q}?->:s5=>2\n.s1-<EOT>&&{(q||p)}?->.s2\n.s2-{p}?->:s3=>1\n.s2-{q}?->:s4=>2\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, null, 0);
    }

    public void testGatedPredInCyclicDFA() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : {p}?=> ('a')+ 'x' ;\nB : {q}?=> ('a'|'b')+ 'x' ;");
        String string = ".s0-'a'&&{(p||q)}?->.s1\n.s0-'b'&&{q}?->:s6=>2\n.s1-'a'&&{(p||q)}?->.s1\n.s1-'b'&&{q}?->:s6=>2\n.s1-'x'&&{(q||p)}?->.s2\n.s2-<EOT>&&{(p||q)}?->.s3\n.s3-{p}?->:s4=>1\n.s3-{q}?->:s5=>2\n";
        this.checkDecision(grammar, 3, string, null, null, null, null, null, 0);
    }

    public void testGatedPredDoesNotForceAllToBeGated() throws Exception {
        Grammar grammar = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}? C ;\n");
        String string = ".s0-B->:s1=>1\n.s0-C&&{q}?->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testGatedPredDoesNotForceAllToBeGated2() throws Exception {
        Grammar grammar = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}?=> C\n  | B\n  ;\n");
        String string = ".s0-B&&{q}?->.s1\n.s0-C&&{(q&&r)}?->:s4=>2\n.s1-{p}?->:s2=>1\n.s1-{q}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testORGatedPred() throws Exception {
        Grammar grammar = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}?=> C\n  | {s}?=> B\n  ;\n");
        String string = ".s0-B&&{(q&&s)}?->.s1\n.s0-C&&{(q&&r)}?->:s4=>2\n.s1-{(q&&s)}?->:s3=>2\n.s1-{p}?->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0);
    }

    public void testIncompleteSemanticHoistedContext() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : b | B;\nb : {p1}? B | B ;");
        String string = ".s0-B->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "B", new int[]{1}, null, 3);
    }

    public void testIncompleteSemanticHoistedContext2() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : b | B;\nb : {p1}? B | B D ;");
        String string = ".s0-B->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "B", new int[]{1}, null, 3);
    }

    public void testTooFewSemanticPredicates() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : {p1}? A | A | A ;");
        String string = ".s0-A->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2, 3}, new int[]{1, 2, 3}, "A", null, null, 2);
    }

    public void testPredWithK1() throws Exception {
        Grammar grammar = new Grammar("\tlexer grammar TLexer;\nA\noptions {\n  k=1;\n}\n  : {p1}? ('x')+ '.'\n  | {p2}? ('x')+ '.'\n  ;\n");
        String string = ".s0-'x'->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int n = 0;
        this.checkDecision(grammar, 3, string, nArray, nArray2, string2, nArray3, nArray4, n);
    }

    public void testPredWithArbitraryLookahead() throws Exception {
        Grammar grammar = new Grammar("\tlexer grammar TLexer;\nA : {p1}? ('x')+ '.'\n  | {p2}? ('x')+ '.'\n  ;\n");
        String string = ".s0-'x'->.s1\n.s1-'.'->.s2\n.s1-'x'->.s1\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int n = 0;
        this.checkDecision(grammar, 3, string, nArray, nArray2, string2, nArray3, nArray4, n);
    }

    public void testUniquePredicateOR() throws Exception {
        Grammar grammar = new Grammar("parser grammar v;\n\na : {a}? b\n  | {b}? b\n  ;\n\nb : {c}? (X)+ ;\n\nc : a\n  | b\n  ;\n");
        String string = ".s0-X->.s1\n.s1-{((b&&c)||(a&&c))}?->:s2=>1\n.s1-{c}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int n = 0;
        this.checkDecision(grammar, 3, string, nArray, nArray2, string2, nArray3, nArray4, n);
    }

    public void _template() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A | B;");
        String string = "\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "L ID R";
        int[] nArray3 = new int[]{1};
        int[] nArray4 = null;
        int n = 1;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, nArray4, n);
    }

    protected void checkDecision(Grammar grammar, int n, String string, int[] nArray, int[] nArray2, String string2, int[] nArray3, int[] nArray4, int n2) throws FailedAssertionException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        CodeGenerator codeGenerator = new CodeGenerator(new Tool(), grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        if (grammar.getNumberOfDecisions() == 0) {
            grammar.createNFAs();
            grammar.createLookaheadDFAs();
        }
        if (errorQueue.size() != n2) {
            System.err.println("Warnings issued: " + errorQueue);
        }
        this.assertTrue(errorQueue.size() == n2, "unexpected number of expected problems: " + errorQueue.size() + "; expecting " + n2);
        DFA dFA = grammar.getLookaheadDFA(n);
        FASerializer fASerializer = new FASerializer(grammar);
        String string3 = fASerializer.serialize(dFA.startState);
        List list = dFA.getUnreachableAlts();
        if (nArray != null) {
            object4 = new BitSet();
            ((BitSet)object4).addAll(nArray);
            object3 = new BitSet();
            ((BitSet)object3).addAll(list);
            this.assertTrue(((BitSet)object4).equals(object3), "unreachable alts mismatch; expecting " + object4 + " found " + object3);
        } else {
            this.assertTrue(list.size() == 0, "unreachable alts mismatch; expecting none found " + list);
        }
        if (string2 != null) {
            object4 = (Message)errorQueue.warnings.get(0);
            this.assertTrue(object4 instanceof GrammarNonDeterminismMessage, "expecting nondeterminism; found " + object4.getClass().getName());
            object3 = this.getNonDeterminismMessage(errorQueue.warnings);
            object2 = ((GrammarNonDeterminismMessage)object3).probe.getSampleNonDeterministicInputSequence(((GrammarNonDeterminismMessage)object3).problemState);
            object = ((GrammarNonDeterminismMessage)object3).probe.getInputSequenceDisplay((List)object2);
            this.assertEqual(object, string2);
        }
        if (nArray2 != null) {
            object4 = this.getNonDeterminismMessage(errorQueue.warnings);
            this.assertTrue(object4 != null, "found no nondet alts; expecting: " + this.str(nArray2));
            object3 = ((GrammarNonDeterminismMessage)object4).probe.getNonDeterministicAltsForState(((GrammarNonDeterminismMessage)object4).problemState);
            object2 = new BitSet();
            ((BitSet)object2).addAll(nArray2);
            object = new BitSet();
            ((BitSet)object).addAll((List)object3);
            this.assertTrue(((BitSet)object2).equals(object), "nondet alts mismatch; expecting " + object2 + " found " + object);
        } else {
            object4 = this.getNonDeterminismMessage(errorQueue.warnings);
            this.assertTrue(object4 == null, "found nondet alts, but expecting none");
        }
        this.assertEqual(string3, string);
    }

    protected GrammarNonDeterminismMessage getNonDeterminismMessage(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            if (!(message instanceof GrammarNonDeterminismMessage)) continue;
            return (GrammarNonDeterminismMessage)message;
        }
        return null;
    }

    protected String str(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            int n = nArray[i];
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }
}

