/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.FObj;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.InlineSpace;

public abstract class Area
extends Box {
    protected FontState fontState;
    protected BorderAndPadding bp = null;
    protected ArrayList children = new ArrayList();
    protected int maxHeight;
    protected int currentHeight = 0;
    protected int tableCellXOffset = 0;
    private int absoluteYtop = 0;
    protected int contentRectangleWidth;
    protected int allocationWidth;
    protected Page page;
    protected BackgroundProps background;
    private IDReferences idReferences;
    protected FObj generatedBy;
    protected String areaClass;
    protected boolean isFirst = false;
    protected boolean isLast = false;
    public FObj foCreator;

    public Area(FontState fontState) {
        this.setFontState(fontState);
    }

    public Area(FontState fontState, int allocationWidth, int maxHeight) {
        this.setFontState(fontState);
        this.allocationWidth = allocationWidth;
        this.contentRectangleWidth = allocationWidth;
        this.maxHeight = maxHeight;
    }

    public void addChild(Box child) {
        this.children.add(child);
        child.parent = this;
    }

    public void addChildAtStart(Box child) {
        this.children.add(0, child);
        child.parent = this;
    }

    public void addDisplaySpace(int size) {
        this.addChild(new DisplaySpace(size));
        this.currentHeight += size;
    }

    public void addInlineSpace(int size) {
        this.addChild(new InlineSpace(size));
    }

    public void end() {
    }

    public int getAbsoluteHeight() {
        return this.absoluteYtop + this.getPaddingTop() + this.getBorderTopWidth() + this.currentHeight;
    }

    public int getAllocationWidth() {
        return this.allocationWidth;
    }

    public BackgroundProps getBackground() {
        return this.background;
    }

    public BorderAndPadding getBorderAndPadding() {
        return this.bp;
    }

    public int getBorderBottomWidth() {
        return this.bp == null ? 0 : this.bp.getBorderBottomWidth(false);
    }

    public int getBorderLeftWidth() {
        return this.bp == null ? 0 : this.bp.getBorderLeftWidth(false);
    }

    public int getBorderRightWidth() {
        return this.bp == null ? 0 : this.bp.getBorderRightWidth(false);
    }

    public int getBorderTopWidth() {
        return this.bp == null ? 0 : this.bp.getBorderTopWidth(false);
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public int getContentHeight() {
        return this.currentHeight;
    }

    public int getContentWidth() {
        return this.contentRectangleWidth;
    }

    public FontInfo getFontInfo() {
        return this.page.getFontInfo();
    }

    public FontState getFontState() {
        return this.fontState;
    }

    public FObj getGeneratedBy() {
        return this.generatedBy;
    }

    public int getHeight() {
        return this.currentHeight + this.getPaddingTop() + this.getPaddingBottom() + this.getBorderTopWidth() + this.getBorderBottomWidth();
    }

    public IDReferences getIDReferences() {
        return this.idReferences;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public AreaContainer getNearestAncestorAreaContainer() {
        Area area = this.getParent();
        while (area != null && !(area instanceof AreaContainer)) {
            area = area.getParent();
        }
        return (AreaContainer)area;
    }

    public int getPaddingBottom() {
        return this.bp == null ? 0 : this.bp.getPaddingBottom(false);
    }

    public int getPaddingLeft() {
        return this.bp == null ? 0 : this.bp.getPaddingLeft(false);
    }

    public int getPaddingRight() {
        return this.bp == null ? 0 : this.bp.getPaddingRight(false);
    }

    public int getPaddingTop() {
        return this.bp == null ? 0 : this.bp.getPaddingTop(false);
    }

    public Page getPage() {
        return this.page;
    }

    public Area getParent() {
        return this.parent;
    }

    public int getTableCellXOffset() {
        return this.tableCellXOffset;
    }

    public FObj getfoCreator() {
        return this.foCreator;
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public boolean hasNonSpaceChildren() {
        if (this.children.size() > 0) {
            Iterator childIter = ((AbstractList)this.children).iterator();
            while (childIter.hasNext()) {
                if (childIter.next() instanceof DisplaySpace) continue;
                return true;
            }
        }
        return false;
    }

    public void increaseHeight(int amount) {
        this.currentHeight += amount;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void isFirst(boolean isFirst) {
        this.isFirst = isFirst;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void isLast(boolean isLast) {
        this.isLast = isLast;
    }

    public void remove() {
        this.parent.removeChild(this);
    }

    public void removeChild(Area area) {
        this.currentHeight -= area.getHeight();
        ((AbstractCollection)this.children).remove(area);
    }

    public void removeChild(DisplaySpace spacer) {
        this.currentHeight -= spacer.getSize();
        ((AbstractCollection)this.children).remove(spacer);
    }

    public void setAbsoluteHeight(int value) {
        this.absoluteYtop = value;
    }

    public void setAllocationWidth(int w) {
        this.contentRectangleWidth = this.allocationWidth = w;
    }

    public void setBackground(BackgroundProps bg) {
        this.background = bg;
    }

    public void setBorderAndPadding(BorderAndPadding bp) {
        this.bp = bp;
    }

    private void setFontState(FontState fontState) {
        this.fontState = fontState;
    }

    public void setGeneratedBy(FObj generatedBy) {
        this.generatedBy = generatedBy;
    }

    public void setHeight(int height) {
        int prevHeight = this.currentHeight;
        if (height > this.currentHeight) {
            this.currentHeight = height;
        }
        if (this.currentHeight > this.getMaxHeight()) {
            this.currentHeight = this.getMaxHeight();
        }
    }

    public void setIDReferences(IDReferences idReferences) {
        this.idReferences = idReferences;
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public void setParent(Area parent) {
        this.parent = parent;
    }

    public void setTableCellXOffset(int offset) {
        this.tableCellXOffset = offset;
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
    }
}

