/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jaccpropagation;

import java.security.Principal;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;

import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;

/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
public class Client
{
   private static final Logger log = Logger.getLogger(Client.class);
   public static final String SESSION_PRINCIPAL = "SessionPrincipal";
   public static final String SESSION_CREDENTIAL = "SessionCredential";
   
   public static final String JAAS_MODE = "JAAS";
   public static final String SA_MODE = "SA";
   public static final String SIMPLE = "SIMPLE";
   
   HttpServletRequest request;
   
   public Client()
   {
      
   }
   
   public Client(HttpServletRequest request)
   {
      this.request = request;
   }
   
   public String processSimple() throws Exception
   {
      log.info("!!! simple principal " + SecurityAssociation.getPrincipal());
      log.info("!!! simple subject " + SecurityAssociation.getSubject());
      
      InitialContext ctx = new InitialContext();
      SessionRemote session = (SessionRemote)ctx.lookup("SessionBean/remote");
      
      String result = session.testCustomPrincipal2();
      
      return result;
   }
   
   public String processSecurityAssociationRequest() throws Exception
   {
      String result = "";
      
      Object credential = "password".toCharArray();
      
      InitialContext ctx = new InitialContext();
      SessionRemote session = (SessionRemote)ctx.lookup("SessionBean/remote");
      
      log.info("!!! initial principal " + SecurityAssociation.getPrincipal());
      log.info("!!! initial subject " + SecurityAssociation.getSubject());
      
      session.testCustomPrincipal();
  
      CustomPrincipalImpl customPrincipal = (CustomPrincipalImpl)SecurityAssociation.getPrincipal();
      customPrincipal.setCustomRole("CustomRole1");
      
      Subject newSubject = new Subject(); 
      
      SecurityAssociation.pushSubjectContext(newSubject, customPrincipal, credential);
      
      log.info("!!! before principal " + SecurityAssociation.getPrincipal());
      log.info("!!! before subject " + SecurityAssociation.getSubject());
      
      result = session.testCustomPrincipal1();
      
      log.info("!!! after principal " + SecurityAssociation.getPrincipal());
      log.info("!!! after subject " + SecurityAssociation.getSubject());
      
      customPrincipal.setCustomRole("CustomRole2");
        
      SecurityAssociation.pushSubjectContext(newSubject, customPrincipal, credential);

      log.info("!!! before principal " + SecurityAssociation.getPrincipal());
      log.info("!!! before subject " + SecurityAssociation.getSubject());
      
      result = session.testCustomPrincipal2();
      
      log.info("!!! after principal " + SecurityAssociation.getPrincipal());
      log.info("!!! after subject " + SecurityAssociation.getSubject());
      
      // set "org.jboss.security.SecurityAssociation.ThreadLocal" property to true to use ThreadLocal 
      // vs. default InheritableThreadLocal
      request.getSession().setAttribute(SESSION_PRINCIPAL, SecurityAssociation.getPrincipal());
      request.getSession().setAttribute(SESSION_CREDENTIAL, credential);
      
      EJBInvoker invoker = new EJBInvoker();
      new Thread(invoker).start();
      Thread.sleep(1000);
      if (invoker.getException() != null)
         throw invoker.getException();

      return result;
   }
   
   public static String processJaasRequest() throws Exception
   {
      String result = "";
       
      AppCallbackHandler handler = new AppCallbackHandler("somebody", "password".toCharArray());
      LoginContext lc = new LoginContext("custom-client", handler);
      handler.setCustom("");
    
      lc.login();
      
      InitialContext ctx = new InitialContext();
     
      SessionRemote session = (SessionRemote)ctx.lookup("SessionBean/remote");
 
      session.testCustomPrincipal();
      
      lc.logout();
      handler.setCustom("custom");
      
      lc.login();
        
      result = session.testCustomPrincipal();
      
      lc.logout();

      return result;
   }
   
   public class EJBInvoker implements Runnable
   {
      protected Exception exception = null;
      
      public EJBInvoker()
      {
      }
      
      public void run()
      {
         try
         {
            InitialContext ctx = new InitialContext();
            SessionRemote session = (SessionRemote)ctx.lookup("SessionBean/remote");

            log.info("!!! threaded before session principal " + SecurityAssociation.getPrincipal() );
            log.info("!!! threaded before session subject " + SecurityAssociation.getSubject());
            
            try
            {
               session.testCustomPrincipal2();
            } 
            catch (javax.ejb.EJBAccessException e)
            {
               //should be caught when ThreadLocal is used
            }
            
            Principal sessionPrincipal = (Principal)request.getSession().getAttribute(SESSION_PRINCIPAL);
            Object credential = request.getSession().getAttribute(SESSION_CREDENTIAL);
            SecurityAssociation.setPrincipal(sessionPrincipal);
            SecurityAssociation.setCredential(credential);
            
            log.info("!!! threaded before principal " + SecurityAssociation.getPrincipal() );
            log.info("!!! threaded before subject " + SecurityAssociation.getSubject());
            
            session.testCustomPrincipal2();
            
            log.info("!!! threaded after principal " + SecurityAssociation.getPrincipal());
            log.info("!!! threaded after subject " + SecurityAssociation.getSubject());
         }
         catch (Exception e)
         {
            exception = e;
         }
      }
      
      public Exception getException()
      {
         return exception;
      }
   }
}
