/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.ws.api.pipe.ContentType;

public final class ContentTypeImpl
implements ContentType {
    private final String contentType;
    private final String soapAction;
    private final String accept;

    public ContentTypeImpl(String contentType) {
        this.contentType = contentType;
        this.soapAction = null;
        this.accept = null;
    }

    public ContentTypeImpl(String contentType, String soapAction) {
        this.contentType = contentType;
        this.soapAction = this.getQuotedSOAPAction(soapAction);
        this.accept = null;
    }

    public ContentTypeImpl(String contentType, String soapAction, String accept) {
        this.contentType = contentType;
        this.accept = accept;
        this.soapAction = this.getQuotedSOAPAction(soapAction);
    }

    private String getQuotedSOAPAction(String soapAction) {
        if (soapAction == null || soapAction.length() == 0) {
            return "\"\"";
        }
        if (soapAction.charAt(0) != '\"' && soapAction.charAt(soapAction.length() - 1) != '\"') {
            return "\"" + soapAction + "\"";
        }
        return soapAction;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getSOAPActionHeader() {
        return this.soapAction;
    }

    public String getAcceptHeader() {
        return this.accept;
    }
}

