/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.publisher.Publisher;

class AuthTokenTable {
    private static Log log = LogFactory.getLog((Class)AuthTokenTable.class);
    static String insertSQL = null;
    static String selectPublisherSQL = null;
    static String deleteSQL = null;
    static String touchSQL = null;
    static String selectLastUsedSQL = null;
    static String invalidateSQL = null;
    static String selectTokenStateSQL = null;

    AuthTokenTable() {
    }

    public static void insert(String authToken, Publisher publisher, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, authToken);
            statement.setString(2, publisher.getPublisherID());
            statement.setString(3, publisher.getName());
            statement.setTimestamp(4, timestamp);
            statement.setTimestamp(5, timestamp);
            log.debug((Object)("insert into AUTH_TOKEN table:\n\n\t" + insertSQL + "\n\t AUTH_TOKEN=" + authToken + "\n\t PUBLISHER_ID=" + publisher.getPublisherID() + "\n\t PUBLISHER_NAME=" + publisher.getName() + "\n\t CREATED=" + timestamp.toString() + "\n\t LAST_USED=" + timestamp.toString() + "\n\t NUMBER_OF_USES=1" + "\n\t TOKEN_STATE=1\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static Publisher selectPublisher(String authToken, Connection connection) throws SQLException {
        Publisher publisher = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectPublisherSQL);
            statement.setString(1, authToken);
            log.debug((Object)("select from AUTH_TOKEN table:\n\n\t" + selectPublisherSQL + "\n\t AUTH_TOKEN=" + authToken + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                publisher = new Publisher();
                publisher.setPublisherID(resultSet.getString(1));
                publisher.setName(resultSet.getString(2));
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void delete(String authToken, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, authToken);
            log.debug((Object)("delete from AUTH_TOKEN table:\n\n\t" + deleteSQL + "\n\t AUTH_TOKEN=" + authToken + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void touch(String authToken, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        try {
            statement = connection.prepareStatement(touchSQL);
            statement.setTimestamp(1, timestamp);
            statement.setString(2, authToken);
            log.debug((Object)("update AUTH_TOKEN table:\n\n\t" + touchSQL + "\n\t AUTH_TOKEN=" + authToken + "\n\t LAST_USED=" + timestamp.toString() + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static long selectLastUsed(String authToken, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        long lastUsed = -1L;
        try {
            Timestamp timestamp;
            statement = connection.prepareStatement(selectLastUsedSQL);
            statement.setString(1, authToken);
            log.debug((Object)("select LAST_USED from AUTH_TOKEN table:\n\n\t" + selectLastUsedSQL + "\n\t AUTH_TOKEN=" + authToken + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next() && (timestamp = resultSet.getTimestamp("LAST_USED")) != null) {
                lastUsed = timestamp.getTime();
            }
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return lastUsed;
    }

    public static void invalidate(String authToken, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        try {
            statement = connection.prepareStatement(invalidateSQL);
            statement.setTimestamp(1, timestamp);
            statement.setString(2, authToken);
            log.debug((Object)("update AUTH_TOKEN table:\n\n\t" + invalidateSQL + "\n\t LAST_USED=" + timestamp.toString() + "\n\t AUTH_TOKEN=" + authToken + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static long selectTokenState(String authToken, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        long tokenState = -1L;
        try {
            statement = connection.prepareStatement(selectTokenStateSQL);
            statement.setString(1, authToken);
            log.debug((Object)("SQL Statement: [" + selectTokenStateSQL + "], parameter authToken: [" + authToken + "]"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                tokenState = resultSet.getLong("TOKEN_STATE");
            }
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return tokenState;
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(350);
        sql.append("INSERT INTO AUTH_TOKEN (");
        sql.append("AUTH_TOKEN,");
        sql.append("PUBLISHER_ID,");
        sql.append("PUBLISHER_NAME,");
        sql.append("CREATED,");
        sql.append("LAST_USED,");
        sql.append("NUMBER_OF_USES,");
        sql.append("TOKEN_STATE) ");
        sql.append("VALUES (?,?,?,?,?,0,1)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("PUBLISHER_ID,");
        sql.append("PUBLISHER_NAME ");
        sql.append("FROM AUTH_TOKEN ");
        sql.append("WHERE AUTH_TOKEN=?");
        selectPublisherSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM AUTH_TOKEN ");
        sql.append("WHERE AUTH_TOKEN=?");
        deleteSQL = sql.toString();
        sql = new StringBuffer(150);
        sql.append("UPDATE AUTH_TOKEN ");
        sql.append("SET LAST_USED=?,");
        sql.append("NUMBER_OF_USES=NUMBER_OF_USES+1 ");
        sql.append("WHERE AUTH_TOKEN=? ");
        touchSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LAST_USED ");
        sql.append("FROM AUTH_TOKEN ");
        sql.append("WHERE AUTH_TOKEN=?");
        selectLastUsedSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("UPDATE AUTH_TOKEN ");
        sql.append("SET LAST_USED=?,");
        sql.append("NUMBER_OF_USES=NUMBER_OF_USES+1,");
        sql.append("TOKEN_STATE=0 ");
        sql.append("WHERE AUTH_TOKEN=? ");
        invalidateSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("TOKEN_STATE ");
        sql.append("FROM AUTH_TOKEN ");
        sql.append("WHERE AUTH_TOKEN=?");
        selectTokenStateSQL = sql.toString();
    }
}

