/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.GetPublisherDetail;
import org.apache.juddi.datatype.response.PublisherDetail;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnknownUserException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetPublisherDetailFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)GetPublisherDetailFunction.class);

    public GetPublisherDetailFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetPublisherDetail request = (GetPublisherDetail)regObject;
        String generic = request.getGeneric();
        Vector idVector = request.getPublisherIDVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            for (int i = 0; i < idVector.size(); ++i) {
                String publisherID = (String)idVector.elementAt(i);
                if (publisherID != null && publisherID.length() != 0 && dataStore.getPublisher(publisherID) != null) continue;
                throw new UnknownUserException("get_publisher: userID=" + publisherID);
            }
            Vector<Publisher> publisherVector = new Vector<Publisher>();
            for (int i = 0; i < idVector.size(); ++i) {
                String publisherID = (String)idVector.elementAt(i);
                publisherVector.add(dataStore.getPublisher(publisherID));
            }
            dataStore.commit();
            PublisherDetail detail = new PublisherDetail();
            detail.setGeneric(generic);
            detail.setPublisherVector(publisherVector);
            detail.setOperator(Config.getOperator());
            PublisherDetail publisherDetail = detail;
            return publisherDetail;
        }
        catch (UnknownUserException ukuex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ukuex.getMessage());
            throw ukuex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }
}

