/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging;

import com.arjuna.common.internal.util.logging.commonPropertyManager;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

public class DefaultLog
implements Log {
    static final String LOG_ENABLED_PROPERTY = "com.arjuna.common.util.logging.default";
    static final String LOG_LEVEL = "com.arjuna.common.util.logging.default.level";
    static final String SHOW_LOG_NAME = "com.arjuna.common.util.logging.default.showLogName";
    static final String SHOW_SHORT_LOG_NAME = "com.arjuna.common.util.logging.default.showShortLogName";
    static final String SHOW_DATE = "com.arjuna.common.util.logging.default.showDate";
    static final String LOG_FILE = "com.arjuna.common.util.logging.default.logFile";
    static final String LOG_FILE_APPEND = "com.arjuna.common.util.logging.default.logFileAppend";
    static final String LOG_FILE_DEFAULT = "error.log";
    protected static final Properties simpleLogProps = new Properties();
    protected static boolean showLogName = false;
    protected static boolean showShortName = true;
    protected static boolean showDateTime = true;
    protected static DateFormat dateFormatter = null;
    static PrintStream defaultLogFile = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected String logName = null;
    protected int currentLogLevel;
    private String prefix = null;

    private static String getStringProperty(String name) {
        String prop = commonPropertyManager.propertyManager.getProperty(name);
        if (prop == null) {
            prop = System.getProperty(name);
        }
        return prop == null ? simpleLogProps.getProperty(name) : prop;
    }

    private static String getStringProperty(String name, String dephault) {
        String prop = DefaultLog.getStringProperty(name);
        return prop == null ? dephault : prop;
    }

    private static boolean getBooleanProperty(String name, boolean dephault) {
        String prop = DefaultLog.getStringProperty(name);
        return prop == null ? dephault : "true".equalsIgnoreCase(prop);
    }

    public DefaultLog(String name) {
        this.logName = name;
        this.setLevel(2);
        String lvl = commonPropertyManager.propertyManager.getProperty(LOG_LEVEL, null);
        if (lvl == null) {
            lvl = System.getProperty(LOG_LEVEL, "info");
        }
        if ("all".equalsIgnoreCase(lvl)) {
            this.setLevel(0);
        } else if ("trace".equalsIgnoreCase(lvl)) {
            this.setLevel(1);
        } else if ("debug".equalsIgnoreCase(lvl)) {
            this.setLevel(2);
        } else if ("info".equalsIgnoreCase(lvl)) {
            this.setLevel(3);
        } else if ("warn".equalsIgnoreCase(lvl)) {
            this.setLevel(4);
        } else if ("error".equalsIgnoreCase(lvl)) {
            this.setLevel(5);
        } else if ("fatal".equalsIgnoreCase(lvl)) {
            this.setLevel(6);
        } else if ("off".equalsIgnoreCase(lvl)) {
            this.setLevel(7);
        }
    }

    public void setLevel(int currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    protected void log(int type, Object message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        if (showDateTime) {
            buf.append(dateFormatter.format(new Date()));
            buf.append(" ");
        }
        switch (type) {
            case 1: {
                buf.append("[TRACE] ");
                break;
            }
            case 2: {
                buf.append("[DEBUG] ");
                break;
            }
            case 3: {
                buf.append("[INFO] ");
                break;
            }
            case 4: {
                buf.append("[WARN] ");
                break;
            }
            case 5: {
                buf.append("[ERROR] ");
                break;
            }
            case 6: {
                buf.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.prefix == null) {
                this.prefix = this.logName.substring(this.logName.lastIndexOf(".") + 1) + " - ";
                this.prefix = this.prefix.substring(this.prefix.lastIndexOf("/") + 1) + "-";
            }
            buf.append(this.prefix);
        } else if (showLogName) {
            buf.append(String.valueOf(this.logName)).append(" - ");
        }
        buf.append(String.valueOf(message));
        if (t != null) {
            buf.append(" <");
            buf.append(t.toString());
            buf.append(">");
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            buf.append(sw.toString());
        }
        defaultLogFile.println(buf.toString());
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public final void debug(Object message) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, null);
        }
    }

    public final void debug(Object message, Throwable t) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, t);
        }
    }

    public final void trace(Object message) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, null);
        }
    }

    public final void trace(Object message, Throwable t) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, t);
        }
    }

    public final void info(Object message) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, null);
        }
    }

    public final void info(Object message, Throwable t) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, t);
        }
    }

    public final void warn(Object message) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, null);
        }
    }

    public final void warn(Object message, Throwable t) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, t);
        }
    }

    public final void error(Object message) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, null);
        }
    }

    public final void error(Object message, Throwable t) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, t);
        }
    }

    public final void fatal(Object message) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, null);
        }
    }

    public final void fatal(Object message, Throwable t) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, t);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        if (classLoader == null) {
            try {
                Method method = Thread.class.getMethod("getContextClassLoader", null);
                try {
                    classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), (Object[])null);
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof SecurityException)) {
                        throw new LogConfigurationException("Unexpected InvocationTargetException", e.getTargetException());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (classLoader == null) {
            classLoader = DefaultLog.class.getClassLoader();
        }
        return classLoader;
    }

    private static InputStream getResourceAsStream(final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = DefaultLog.getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }

    static {
        showLogName = DefaultLog.getBooleanProperty(SHOW_LOG_NAME, showLogName);
        showShortName = DefaultLog.getBooleanProperty(SHOW_SHORT_LOG_NAME, showShortName);
        showDateTime = DefaultLog.getBooleanProperty(SHOW_DATE, showDateTime);
        showLogName = DefaultLog.getBooleanProperty(SHOW_LOG_NAME, showLogName);
        dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
        String fileName = DefaultLog.getStringProperty(LOG_FILE, LOG_FILE_DEFAULT);
        boolean fileAppend = DefaultLog.getBooleanProperty(LOG_FILE_APPEND, true);
        try {
            FileOutputStream fOut = new FileOutputStream(fileName, fileAppend);
            defaultLogFile = new PrintStream(fOut, true);
            defaultLogFile.println();
            defaultLogFile.println();
            defaultLogFile.println("---------------------------------------------------------------");
            defaultLogFile.println("DEFAULT LOG, started " + dateFormatter.format(new Date()));
            defaultLogFile.println("---------------------------------------------------------------");
        }
        catch (Exception e) {
            System.err.println("cannot set up default log for error messages to file " + fileName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

