/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.loader;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.LockMode;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.loader.Loader;
import cirrus.hibernate.loader.UniqueEntityLoader;
import cirrus.hibernate.persister.Loadable;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;

public final class SimpleEntityLoader
extends Loader
implements UniqueEntityLoader {
    private final Loadable[] persister;
    private final Type[] idType;
    private final String sql;
    private final LockMode lockMode;
    private static final String[] NO_SUFFIX = new String[]{""};

    public SimpleEntityLoader(Loadable persister, String sql, LockMode lockMode) {
        this.persister = new Loadable[]{persister};
        this.idType = new Type[]{persister.getIdentifierType()};
        this.sql = sql;
        this.lockMode = lockMode;
    }

    public String getSQLString() {
        return this.sql;
    }

    public Loadable[] getPersisters() {
        return this.persister;
    }

    public CollectionPersister getCollectionPersister() {
        return null;
    }

    public String[] getSuffixes() {
        return NO_SUFFIX;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public Object load(SessionImplementor session, Serializable id, Object object) throws HibernateException, SQLException {
        List list = this.loadEntity(session, new Object[]{id}, this.idType, object, id, false);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        throw new HibernateException("More than one row with the given identifier was found: " + id + ", for class: " + this.persister[0].getClassName());
    }
}

